//    

alias(Union=intlib::_union):
alias(Match=intlib::match_aux):
alias(Matchplus=intlib::matchplus):
alias(Matchmult=intlib::matchmult):

// _pattern is now defined in stdlib.mu
//_pattern:=slot(_pattern,"type","_pattern"): # for pattern variable #

intlib::matchEnv :=
proc()
  save dummy;
begin
  delete dummy;
  intlib::match_aux(args());
end_proc:

intlib::match :=
proc(e,p)
  local vars;
begin
  userinfo(8,"trying to match",e,"with pattern",p);
  vars:=op(indets(p));
  if iszero(nops(vars)) then Match(e,p)
  else
    sysassign(intlib::matchEnv,subsop(intlib::matchEnv,
				      [4,1]=(hold(_delete)(vars);),
				      11=vars,Unsimplified));
    intlib::matchEnv(e,p)
  end_if
end_proc:


intlib::matchassign := proc() local _s;
begin
   _s:=intlib::match1(args());
   if _s=FAIL then FALSE
   else
     map(_s,((X)->evalassign(op(X,1),op(X,2),1))); TRUE
   end_if
end_proc:


intlib::match1:=proc(e,p)
begin
   userinfo(8,"trying to match",e,"with pattern",p);
   Match(e,p)
end_proc:

/* if the expression e matches the pattern p,
   then return a set of assignments of the pattern variables _pattern(...),
   otherwise return FAIL
*/
Match := proc(e,p) local r,m,i;
begin
   userinfo(110,"trying to match",e,"with pattern",p);
   if e=p then {}
   elif type(p)=DOM_IDENT then FAIL // necessary p<>e 
   elif type(p)="_pattern" then
      if nops(p)=1 then {op(p)=e} // no condition 
      else
         r:=op(p,2);
         if contains({DOM_FUNC_ENV,DOM_PROC,DOM_EXEC,"_not"},type(r)) then
            r:=r(e,op(p,3..nops(p)))
         else r:=testtype(e,r)
         end_if;
         if r=TRUE then {op(p,1)=e} else FAIL end_if
      end_if
   elif type(p)="_power" then
      if type(e)="_power" then 
         r:=Match(op(e,1),op(p,1));
         if r=FAIL then
            // try with power 1 (power 0 cannot be because e is a power) 
            Union(Match(e,op(p,1)),Match(1,op(p,2)))
         else // op(e,1) and op(p,1) match 
            Union(r,Match(op(e,2),op(p,2)))
         end_if
      else // e is not a power 
         r:=Union(Match(1,op(p,2)),Match(e,op(p,1))); // power 1 
         if r<>FAIL then r else Union(Match(0,op(p,2)),Match(e,1)) end_if
      end_if
   elif type(p)="_plus" then
      r:=select(p,testtype,DOM_INT);
      p:=p-r;
      e:=e-r;
      if type(p)<>"_plus" then Match(e,p)
      else Matchplus(intlib::plus2list(e),[op(p)])
      end_if
   elif type(p)="_mult" then
      if e=0 then
         for r in p do
            if (r:=Match(0,r))<>FAIL then return(r) end_if
         end_for;
         return(FAIL)
      end_if;
      r:=select(p,testtype,DOM_INT);
      p:=p/r; e:=e/r;
      if type(p)<>"_mult" then Match(e,p)
      else
         p:=sort(intlib::mult2list(p),
                 ()->bool(length(args(1))>length(args(2))));
         Matchmult(intlib::mult2list(e),p)
      end_if
   elif p=op(p) then if e=p then {} else FAIL end_if
   elif nops(e)=nops(p) and (m:=Match(op(e,0),op(p,0)))<>FAIL then
         for i from 1 to nops(p) do
            r:=Match(op(e,i),op(p,i));
            if r=FAIL then return(FAIL) end_if;
            m:=Union(m,r);
         end_for;
         m
   elif type(p)="exp" then
      if e=1 then Match(0,op(p))
      elif type(e)="_power" and type(op(e,1))="exp" then
         Match(op(e,[1,1])*op(e,2),op(p))
      else FAIL
      end_if
   else FAIL
   end_if;
end_proc:

// this should be implemented in the kernel 
Union:=proc(a,b) option hold; local l;
begin
   if (a:=context(a))=FAIL then FAIL
   elif (b:=context(b))=FAIL then FAIL
   else
      // checks that there is no contradiction 
      l := [op(map(a,op,1) intersect map(b,op,1))];
      if subs(l,op(a))<>subs(l,op(b)) then FAIL else a union b end_if
   end_if
end_proc:

intlib::mult2list:=(e)->(if type(e)="_mult" then [op(e)] else [e] end_if):
intlib::plus2list:=(e)->(if type(e)="_plus" then [op(e)] else [e] end_if):

// e and p are lists 
Matchmult := proc(e,p) local i,y,j;
begin
      if p=[] then if e=[] then {} else FAIL end_if
      elif nops(p)=1 then Match(_mult(op(e)),p[1])
      else // pattern not empty 
         for j from 1 to nops(p) do
            for i from 1 to nops(e) do
               y:=Union(Match(e[i],p[j]),
			Matchmult(subsop(e,i=null()),subsop(p,j=null())));
               if y<>FAIL then return(y) end_if
            end_for;
            // it may match 1 too 
            y:=Union(Match(1,p[j]),Matchmult(e,subsop(p,j=null())));
            if y<>FAIL then return(y) end_if
         end_for;
         FAIL
      end_if
end_proc:

// e and p are lists 
Matchplus := proc(e,p) local i,y,j;
begin
      if p=[] then if e=[] then {} else FAIL end_if
      elif nops(p)=1 then Match(_plus(op(e)),p[1])
      else // pattern not empty 
         for j from 1 to nops(p) do
            for i from 1 to nops(e) do
               y:=Union(Match(e[i],p[j]),
			Matchplus(subsop(e,i=null()),subsop(p,j=null())));
               if y<>FAIL then return(y) end_if
            end_for;
            // it may match 0 too 
            y:=Union(Match(0,p[j]),Matchplus(e,subsop(p,j=null())));
            if y<>FAIL then return(y) end_if
         end_for;
         FAIL
      end_if
end_proc:
