intlib::definite:=funcenv(proc(f,a,b,opt)
local result,result2,ops,i,dosubst;
begin
  if has(f, [hold(heaviside)]) then
    return(FAIL);
  end_if;

  userinfo (2, "trying definite integration for " . expr2text(hold(int)(f, _X_=a..b)));
  userinfo (3, "_X_ has properties: " . expr2text(getprop(_X_)));

  // if integral has the form int(f(sin(x),cos(x)), x=0..PI/2), then do a substition
  // to get rid of the sin/cos functions
  if a=0 and b=PI/2 then
    ops:=[prog::find(f, _X_)];
    dosubst:=TRUE;
    for i in ops do
      if not op(f, i[1..-2].[0]) in { hold(sin), hold(cos), hold(tan) } then
        dosubst:=FALSE;
        break;
      end_if;
    end_for;

    if dosubst then
      // if f is rational in sin, cos, tan, try intlib::antiderivative first,
      // since intlib::ratSinCos is rather powerful (and avoids introducing algebraic terms)
      if testtype(subs(f, [#t=1234, sin(_X_)=#t, cos(_X_)=#t, tan(_X_)=#t]),
        Type::RatExpr(#t, Type::IndepOf(#t))) then
        result := intlib::antiderivative(f, _X_=a..b, opt);
        if result <> FAIL and type(result) <> "int" then
          return(result);
        end_if;
      end_if;
      
      for i in ops do
        case op(f, i[1..-2].[0])
          of hold(sin) do
            f:=subsop(f, i[1..-2]=_X_, Unsimplified);
            break;
          of hold(cos) do
            f:=subsop(f, i[1..-2]=sqrt(1-_X_^2), Unsimplified);
            break;
          of hold(tan) do
            f:=subsop(f, i[1..-2]=_X_/sqrt(1-_X_^2), Unsimplified);
            break;
        end_case;
      end_for;

      return(int(Simplify(f/sqrt(1-_X_^2), Steps=20), _X_=0..1, opt));
    end_if;
  end_if;
  
  result:=intlib::definite::lookup(f,a,b,opt);
  if result<>FAIL then
    return(result);
  end_if;

  if is(a<0 and b>0)=TRUE then
    userinfo(3, "Splitting interval of integration at 0");
    
    result:=intlib::definite::lookup(f,0,b,opt);
    if result<>FAIL and is(abs(result)<infinity)=TRUE then
      result2:=intlib::definite::lookup(subs(f, _X_=-_X_,EvalChanges),0,-a,opt);
      if result2<>FAIL and is(abs(result2)<infinity)=TRUE then
        return(result+result2);
      end_if;
    end_if;
  end_if;

  return(FAIL);
end_proc):

intlib::definite::userpatterns:=[]:
intlib::definite::userpatternFSA:=FAIL:

intlib::definite::addpattern:=proc(pattern, var, pat_vars)
local pat,conds,result,lb,ub,nb;
begin
  // pattern is [ pattern, result, lowerbound, upperbound, conditions ]
  if var <> _X_ and has(pattern, _X_) then
    [pattern, pat_vars] := subs([pattern, pat_vars], _X_=genident("_X_"));
  end;
  [pattern, pat_vars] :=
    subs([pattern, pat_vars], var = _X_);

  [pat, result, lb, ub, conds] := pattern;

  matchlib::addpatterns(intlib::definite::userpatternFSA,
                            intlib::definite::userpatterns,
                            [[`#defint`(pat, lb, ub), [result, _X_, lb, ub], pat_vars, conds,
                              map(pat_vars, v -> subs(matchlib::block(not has(`#v`, _X_)), `#v`=v))]],
                            intlib::definite::generalize, FALSE, FAIL);

  if testtype(ub,DOM_IDENT) and testtype(lb,Type::IndepOf(coerce(pat_vars,DOM_SET))) and has(pat_vars,ub) and not has(pat,ub) then
    // for patterns like int(foo(t), t=0..x) also handle int(foo(t), t=a..b)
    nb:=genident(expr2text(ub));
    
    matchlib::addpatterns(intlib::definite::userpatternFSA,
                          intlib::definite::userpatterns,
                          [[`#defint`(pat, nb, ub), 
                            [(matchlib::block@(x->x))
                              (matchlib::unblock(result)-
                               matchlib::unblock(subs(result,ub=nb))),
                             _X_, nb, ub], pat_vars.[nb], 
                            conds . subs(select(conds, has, ub), ub=nb),
                            map(pat_vars.[nb], v->subs(matchlib::block(not has(`#v`, _X_)), `#v`=v))]],
                          intlib::definite::generalize, FALSE, FAIL);

    eval(hold(int::addpattern)(pat, _X_, subs(result,ub=_X_),
      select(pat_vars, not _equal, ub),
      subs(conds, ub=_X_)));
  end_if;

  intlib::defInt(Remember, Clear);
  null();
end_proc:

// this routine gets a partly compiled pattern,
// with pattern variables in `##`(...)
intlib::definite::generalize :=
proc(pat)
  local getvar, f, l, r, nl, nr, fx, fpx, bl,
        pat1, newconds, subst_in_result, subst_in_conds;
begin
  [f, l, r] := [op(pat[1])];
  getvar :=
  proc(pref)
  begin
    if has(pat, pref) then
      genident("".pref);
    else
      pref
    end_if;
  end:
  
  nl := getvar(`#left`);
  nr := getvar(`#right`);
  fx := getvar(`#f(_X_)`);
  fpx := getvar(`#f'(_X_)`);
  // matchlib::block without option hold
  bl := (matchlib::block@(x -> x));
  newconds := [];
  subst_in_result := [_X_=fx];
  subst_in_conds := [_X_=fx];
  if op(l, 0)=`##` then
    if has(f, l) then
      newconds := newconds.[bl(hold(subs)(fx, _X_=nl)=op(l, 1))];
    else
      subst_in_result := subst_in_result.
           [op(l, 1)=hold(subs)(fx, _X_=nl)];
      subst_in_conds := subst_in_conds.
           [op(l, 1)=hold(subs)(fx, _X_=nl)];
    end_if;
  else
    newconds := newconds.[bl(hold(subs)(fx, _X_=nl)=l)]
  end_if;
  if op(r, 0)=`##` then
    if has(f, r) then
      newconds := newconds.[bl(hold(subs)(fx, _X_=nr)=op(r, 1))];
    else
      subst_in_result := subst_in_result.
         [op(r, 1)=hold(subs)(fx, _X_=nr)];
      subst_in_conds := subst_in_conds.
         [op(r, 1)=hold(subs)(fx, _X_=nr)];
    end_if;
  else
    newconds := newconds.[bl(hold(subs)(fx, _X_=nr)=r)]
  end_if;
      
  pat1 := [`#defint`(subs(op(pat[1], 1), _X_=`##`(fx))*`##`(fpx),
                     `##`(nl), `##`(nr)),
           [subs(pat[2][1], subst_in_result), 
            [bl(hold(rewrite)(intlib::getConstOfConstTimesDiff(fx, fpx, _X_)*
                              subs(matchlib::unblock(pat[2][2])[1], 
                                   subst_in_result, Unsimplified), hold(D)))].
             map(subs(matchlib::unblock(pat[2][2])[2..-1], subst_in_result), bl)],
           [bl(hold(has)(fx, _X_)),
            intlib::isConstTimesDiff(fx, fpx, _X_)].
           subs(pat[3], subst_in_conds).
           newconds];
  pat1, subs(pat1, `##`(fpx)=1, fpx=1, EvalChanges);
end:


// intlib::definite::patternFSA:=loadproc(intlib::definite::patternFSA, pathname("INTLIB","DEFINITE"), "load_patterns"):
// intlib::definite::patternFSA_Cauchy:=loadproc(intlib::definite::patternFSA_Cauchy, pathname("INTLIB","DEFINITE"), "load_patterns"):
autoload(intlib::definite::patterns):
intlib::definite::cauchy_patterns:=
  loadproc(intlib::definite::cauchy_patterns, pathname("INTLIB","DEFINITE"),
  "patterns"):

intlib::definite::lookup:=proc(f,a,b,options)
local fab, g, results, r, r2, x, dx, tmp, goodresults;
begin

  if type(f)="_mult" then
    g:=_mult(select(op(f), _not@has, _X_));
    if g<>1 then
      f:=_mult(select(op(f), has, _X_));
      userinfo (3, "Splitting off constant factor ".expr2text(g));
    end_if;
  else
    g:=1;
  end_if;

  fab := `#defint`(f, a, b);
  goodresults:={};
 
  results := [];
  /*
  for FSA in [op(intlib::definite::patternFSA)] do
    if op(FSA, 1) in {hold(Default), RatExpr} or
       hastype(fab, op(FSA, 1)) then
      results := results.op(map(FSA[2], fsa -> matchlib::evalFSA(fab, fsa)));
    end_if;
  end_for;
  */
  results := results.matchlib::einwohner(fab, _X_, op(intlib::definite::patterns));

  if options[PrincipalValue] = TRUE then
    /*
    for FSA in [op(intlib::definite::patternFSA_Cauchy)] do
      if op(FSA, 1) in {hold(Default), RatExpr} or
         hastype(fab, op(FSA, 1)) then
        results := results.op(map(FSA[2], fsa -> matchlib::evalFSA(fab, fsa)));
      end_if;
    end_for;
    */
    results := results.matchlib::einwohner(fab, _X_, op(intlib::definite::cauchy_patterns));
  end_if;

  // check user supplied patterns
  if nops(intlib::definite::userpatterns)>0 then
    results:=matchlib::evalFSA(fab, intlib::definite::userpatternFSA) . results;
  end_if;
  
  // perform late checks of conditions now
  for r in results do
    userinfo (4, "Checking match ".expr2text(r));

    r2 := FAIL;
    r := matchlib::unblock(r);
    if traperror((r[1] := eval(matchlib::unblock(r[1])))) <> 0 or
     is(r[1], Goal=FALSE)=FALSE then
      next;
    end_if;
    r[2] := map(r[2], matchlib::unblock);
    if traperror((repeat
        [r, r2] := [eval(unfreeze(matchlib::unblock(eval(
          subs(r, hold(sum::sum_fn)=sum::expand_sum_fn))))), r];
      until r=r2 end)) <> 0 or
      r[2][1] = FAIL then
      next;
    end_if;
    
    x := r[2][2];
    dx:=diff(x, _X_);
    if iszero(dx) then
      next;
    end_if;

    r := [r[1] and intlib::limit(x, _X_=a, Right)=r[2][3]
               and intlib::limit(x, _X_=b, Left) =r[2][4],
          r[2][1]];
    if traperror((tmp := is(r[1]))) <> 0 or tmp=FALSE then
      next;
    end_if;

    userinfo (1, "Found match ".expr2text(r));

    if is(r[1]) = TRUE then
      userinfo (2, "Unconditionally returning result: ".expr2text(r[2]*g));
      return(r[2]*g);
    end_if;

    goodresults := goodresults union {r};

    userinfo (4, "Results so far: ".expr2text(goodresults));
  end_for;

  if nops(goodresults) > 0 then
    goodresults := piecewise(op(goodresults))*g;
  else
    goodresults := undefined;
  end_if;

  if goodresults=undefined then
    userinfo (1, "No match for " . expr2text(hold(int)(f, _X_=a..b)));
    return(FAIL);
  end_if;

  return(goodresults);
end:

//// a couple of specialized functions which are used in the patterns:

// (k,l) -> int(sin(x)^k/x^l,x=0..infinity),
// for k and l positive integers, l DOM_INT, k >= l
intlib::definite::sin_power_times_x_power :=
proc(k,l)
  option remember;
begin
  if l<=2 then
    binomial(k-l,k/2-l/2)*PI/2^(k+1-l)
  else
    k*((k-1)*intlib::definite::sin_power_times_x_power(k-2,l-2)
    -k*intlib::definite::sin_power_times_x_power(k,l-2))/(l-1)/(l-2)
  end_if
end_proc;

prog::setcheckglobals(intlib::definite, {_X_}):
prog::setcheckglobals(intlib::definite::addpattern, {_X_}):
prog::setcheckglobals(intlib::definite::lookup, {_X_}):
