//    

DOM_POLY::int:=
proc(p:DOM_POLY, xx)
  name DOM_POLY::int;
  local e,x,result,pos,R;
begin                
  if args(0) = 1 then
    x:=op(p,2);
    if nops(x) <> 1 then
      error("need integration variable")
    else
      x:=op(x,1)
    end_if
  elif type(xx) = "_equal" then
    x:=op(xx,1);
    e:=op(xx,2);
    if type( e ) <> "_range" then
      error("no range of integration")
    end_if;

    result:=DOM_POLY::int( p,x,args(3..args(0)) );
    if result=FAIL then return( hold(int)(args()) )
    else
      result:=evalp(result,x=op(e,2))-evalp(result,x=op(e,1));
      if result=FAIL then return( hold(int)(args()) )
      else return( result );
      end_if;
    end_if;
  else
    x:=xx
  end_if;

  // indefinite integration
  pos:=contains(op(p,2),x);
  if iszero(pos) then return( hold(int)(args()) )  // not an indeterminate of p
  else
    if nops(op(p))=3 then
      R:=op(p,3);
      if R::dom=DOM_DOMAIN and R::hasProp(Dom::BaseDomain)=TRUE and
        not(R::hasProp(Cat::Field)=TRUE or
         R::hasProp(Cat::Algebra(Dom::Fraction(Dom::Integer)))=TRUE or
         R::hasProp(Cat::Algebra(Dom::Rational))=TRUE)
        then R:=Dom::Fraction(R)
      end_if;
    else
      R:=null()
    end_if;
    e:=poly(map(poly2list(expr(p),[x]), e->[e[1]/(e[2]+1),e[2]+1]), [x]);
    return( poly(expr(e),op(p,2),R) );
  end_if
  end_proc:

// end of file 
