
// intlib::intOverset(f, x, S)
//

// return int_{-\infty}^{\infty} f(x) chi_S(x) dx
// where chi_S is the characteristic function of S



intlib::intOverSet:=
proc(integrand, variable: DOM_IDENT, set)
  local a, b, el, iel, s1, s2, options;
begin

  if set::dom::intOverSet <> FAIL then
    return(set::dom::intOverSet(args()))
  end_if;

  options := intlib::getOptions(args(4..args(0)));
    
  integrand := eval(integrand);
  
  case type(set)
    of Dom::Interval do
      a:= set::dom::left(set);
      b:= set::dom::right(set);
      return(piecewise
             ([a < b, int(integrand, variable=a..b, options)],
              [a >= b, 0]))
    of DOM_SET do
      // integral over a finite set is zero
      // (ignoring the case dirac(..) at the moment)
      return(0)
    of "_union" do
      s1 := {};
      s2 := 0;
      for el in set do
        iel := intlib::intOverSet(integrand, variable, el, options);
        if op(iel, 0) = procname then
          s1 := s1 union el;
        else
          s2 := s2 + iel;
        end;
      end;
      if s1 <> {} then
        return(s2 + procname(integrand, variable, s1, intlib::printOptions(options)));
      else
        return(s2);
      end;
  end_case;

  procname(args())
end_proc:


intlib::intOverSet:=funcenv(intlib::intOverSet):

intlib::intOverSet::type:="intOverSet":

intlib::intOverSet::freeIndets:=
proc(J: "intOverSet")
begin
  (freeIndets(op(J, 1), args(2..args(0))) minus {op(J, 2)})
  union freeIndets(op(J, 3), args(2..args(0)))
end_proc:

intlib::intOverSet::evalAt:=
proc(J: "intOverSet", subst: DOM_SET)
begin
  // in J:= int_{x in S} g(x), do not substitute x in g when
  // evaluating J | x=C; however, substitute it in S if S depends on x
  eval(subsop(J,
              1 = evalAt(op(J, 1), select(subst,
                                          proc(equ)
                                          begin
                                            op(equ, 1) <> op(J, 2)
                                          end_proc
                                          )
                         ),
              3 = evalAt(op(J, 3), subst)
              )
       )
end_proc:

intlib::intOverSet::Content :=
proc(Out, data)
begin
  if nops(data) <> 3 then
    return(Out::stdFunc(data));
  end_if;
  if type(op(data, 3)) = Dom::Interval then
    // output as standard definite integral
    Out::Capply(Out::Cint,
		Out::Cbvar(Out(op(data, 2))),
		Out::Clowlimit(Out(Dom::Interval::left(op(data, 3)))),
		Out::Cuplimit(Out(Dom::Interval::right(op(data, 3)))),
		Out(op(data, 1)));
  else
    Out::Capply(Out::Cint,
		Out::Cbvar(Out(op(data, 2))),
		Out::Ccondition(Out(hold(_in)(op(data, 2), op(data, 3)))),
		Out(op(data,1)));
  end_if;
end_proc:
