//    

/*++ ---------------- heaviInt.mu ---------------------

Description:
This file contains functions for integrating (generalized) functions containing
the heaviside function.
							  
Functions: 

 - used Parameter:
    ++ f  :DOM_EXPR
    ++ x  :DOM_IDENT				  
    ++ f     = (complex) generalized function (distribution)
    ++ x     = indeterminate of f					  

 - intlib::heavisideInt(f,x)
    ++ returns FAIL or an (formal) antiderivative of the (generalized) function
    ++ f w.r.t. x, wherby the antiderivative F is defined as follows:
    ++
    ++          F:=int(g(x)*heaviside(p(x)),x)
    ++    and
    ++          F = int(g(x),x)*heaviside(p(x))-int(int(g(x),x)*dirac(p(x)),x)
    ++
    ++ When it is not possible to evaluate int(g(x),x) explicitly, FAIL is
    ++ is returned.
                    
Examples:
++*/

intlib::heavisideInt:=
  proc(f,x) 
    local g,G,H,s;
  begin
    //print("entering heavisideInt with ",f,x);
    case type(f)
      of "_plus" do //print("case _plus");
        return( map(f, e->if hastype(e,"heaviside") then
                            intlib::heavisideInt(e,x) 
                          else intlib::int(e,x) 
                          end_if)); break;
      of "heaviside" do //print("case heaviside");
        g:=1; H:=f; break;
      of "_mult" do //print("case _mult");
        s:=split(f,hastype,"heaviside");
        if type(s[1])="heaviside" then H:=s[1]; g:=s[2]*s[3] else return(FAIL)
        end_if; break;
      otherwise //print("case otherwise");
        return(FAIL);
    end_case;

    // now f(x)=g(x)*heaviside(p(x))
    if degree(poly(op(H),[x]))=1 then 
      G:=int(g,x);
      if has(G,int) then FAIL
      elif has(G,heaviside) then //to avoid loops int(heaviside(.)*dirac(.)..)
        if f=G*dirac(op(H)) then G*H/2 else 0 end_if;
      else
        G*H-int(G*dirac(op(H)),x);
      end_if;
    else
      FAIL;
    end_if;
  end_proc:
