// 

testargs(TRUE):
alias(bl=matchlib::block):

// compile patterns for indefinite integration
// Ausführen in INTLIB um patternFSA.mb zu erzeugen
//
// Globale Annahmen:
// Integrationsvariable x
// a, b, c, ..., v, w, y, z  sind von x unabhängig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted
// px, qx are polynomial expressions
// qx1 is the reciprocal of a polynomial expression

default_assumptions :=
// map([a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,y,z],
//   v -> subs(bl(not has(`#v`, _X)), `#v`=v)) .
map([m, mp1, n, m0, n0, m1, m2, n1, n2],
    v -> v in Z_ intersect Dom::Interval([1], infinity)).
[bl(m2 in 2*Z_),
 bl(n2 in 2*Z_),
 bl(m1 in 2*Z_+1),
 bl(n1 in 2*Z_+1),
 bl(n3 in Z_),
 bl(m3 in Z_),
 mp1 = m+1,
 bl(testtype(px, Type::PolyExpr([_X], Type::IndepOf(_X)))),
 bl(testtype(qx, Type::PolyExpr([_X], Type::IndepOf(_X)))),
 bl(testtype(1/qx1, Type::PolyExpr([_X], Type::IndepOf(_X)))),
 null()
]:

assume(m in Z_ intersect Dom::Interval([1], infinity)):
assume(n in Z_ intersect Dom::Interval([1], infinity)):
assume(m0 in Z_ intersect Dom::Interval([1], infinity)):
assume(n0 in Z_ intersect Dom::Interval([1], infinity)):
assume(m2 in 2*Z_ intersect Dom::Interval(1,infinity)):
assume(n2 in 2*Z_ intersect Dom::Interval(1,infinity)):
assume(m1 in 2*Z_+1 intersect Dom::Interval([1],infinity)):
assume(n1 in 2*Z_+1 intersect Dom::Interval([1],infinity)):
assume(m0 in Z_):
assume(n0 in Z_):
assumeAlso(mp1=m+1):

assumptions :=
proc(pattern)
  local vars;
begin
  vars := indets(pattern) union Type::ConstantIdents union stdlib::PROTECTED union {_X, `#matchlib::block`};
  select(default_assumptions,
         a->indets(a) minus vars = {});
end:

include_assumptions :=
proc(p)
begin
  [p[1], p[2],
//   [op(indets(p) minus (Type::ConstantIdents union stdlib::PROTECTED union {_X, `#matchlib::block`}))],
   if nops(p) = 3 then
     p[3]
   else
     []
   end_if.
   assumptions(p[1])];
end_proc:


// here, the vars have not been renamed yet
extractconstants :=
proc(pat)
  local pat1, noX, dummy;
begin
  if type(pat[1]) = "_mult" then
    [pat1, noX, dummy] := split([op(pat[1])],
                                has, hold([x, fx, gx, f1x, g1x, px, qx, qx1]));
    noX := _mult(op(noX));
    if noX <> 1 then
      [_mult(op(pat1)),
       subs(matchlib::block(`#a`/`#b`),
            `#a`=matchlib::unblock(pat[2]),
            `#b`=noX),
       if nops(pat)>2 then
         pat[3]
       else
         null()
       end_if];
    else
      pat;
    end_if;
  else
    pat
  end_if;
end_proc:

LEVEL := 1: // spart Zeit beim Einlesen

START := time():

//---------------------------------------------------

read("patterns_indefinite.mu"):

//int_patterns := select(int_patterns, has, hold(hypergeom)):

//int_patterns := int_patterns[01..200]:

// int_patterns := []:
// int_patterns := int_patterns[150..150].int_patterns[277..277]:

// int_patterns := select(int_patterns, has, hold(cos)):

// check for errors happening often:
boundIndets :=
proc(ex)
local poss, pos, res;
begin
	poss := {prog::find(ex, hold(sum)),
		prog::find(ex, hold(product)),
		prog::find(ex, hold(int))};
	res := {};
	for pos in poss do
		res := res union {op(ex, pos[1..-2].[2,1])};
	end_for;
	res;
end_proc:

for pat in int_patterns do
  if domtype(pat) <> DOM_LIST then
    error("Not a list: ".expr2text(pat));
  end_if;
  if nops(pat) > 2 then
    if domtype(pat[3]) <> DOM_LIST then
      error("illegal conditions at ".expr2text(pat[1]));
    end_if;
  end_if;
  if select(indets(pat[2]) minus indets(pat[1]) 
      minus boundIndets(pat[2]) minus {x, `#matchlib::block`}
		minus Type::ConstantIdents, i -> i = eval(i)) <> {} then
	error("result contains more indets than pattern: ".expr2text(pat));
  end_if;
end_for:



// constant factors
int_patterns2 := subs(map(int_patterns, extractconstants), x=_X):

if Pref::userOptions()="showPatterns" then
// debugging help
for i from 1 to nops(int_patterns2) do
  if matchlib::isBlock(int_patterns2[i][2]) then
    int_patterns2[i][2][2] := int_patterns2[i][2][2]*(#pattern(i));
  else
    int_patterns2[i][2] := int_patterns2[i][2]*(#pattern(i));
  end_if;
end_for:
end_if:

print(Unquoted,
      _outputSequence(nops(int_patterns2) + nops(direct_patterns),
                      " patterns read in ",
                      (time()-START)/1000.0, " seconds")):

int_patterns2 := map(int_patterns2,
  proc(p)
    local pat, pat2;
    name alsoIncludeSimplifiedVersionOfInput;
  begin
    pat := p[1];
    pat2 := intlib::Simplify(pat);
    if pat = pat2 then
      p
    else
      p, subsop(p, 1=pat2)
    end_if;
  end_proc):

int_patterns2 := map(int_patterns2, include_assumptions):

allpatterns := []:

//matchlib::addpatterns(intlib::patternFSA, allpatterns, int_patterns2,
//	                  int::addpattern::generalize, 0, 
//                      [[RatExpr, ex -> testtype(subs(ex[1], `##`(`#f(_X)`)=_X), 
//	                          Type::Rational(_X, Type::IndepOf(_X)))],
//                       "sin", "cos", "ln", "tan", "cot",
//                       "arctan", "sinh", "cosh", "tanh", "coth",
//                       "exp", "arcsin", "arccos",
//                       "arcsinh", "arccosh", "arccot",
//                       "erf", "psi", "lambertW", "besselJ"]):

unprotect(intlib):
intlib::patterns := matchlib::einwohner::compile(int_patterns2, _X):


print(Unquoted,
      _outputSequence("compilation finished, ", (time()-START)/1000.0, " seconds")):
print(nops(allpatterns));

bytes();
// share():
// bytes();

if not Pref::userOptions()="showPatterns" and doNotSavePatterns <> TRUE then
  patterns := intlib::patterns:
  write("patterns_bin.mb", patterns):
end_if:

/*
setuserinfo(intlib, 10):
intlib::lookup((x^2 + 2*x + 11)^(3/2), x);
int(1/(sqrt(x-1)+sqrt(x+1)),x);
int(y''(x)/y(x)-y'(x)^2/y(x)^2, x);
int(sin(f(x))*f'(x), x);

intlib::lookup(sqrt(x)/(3+x)^2, x);
 */
 
/*
setuserinfo(intlib, 9):
int(1/(sqrt(z^2+1)*(z^2+2)), z);
int(1/(sqrt(z^2+1)*(z^2+2)), z=0..infinity);
*/

/*
print("starting hyperint example"):
[p, q, f]:= [x,x^2-1,x^5+2*x^4-x^3-4*x^2+x-19]:
prog::profile(intlib::lookup(p/q/sqrt(f), x));
*/

/*
setuserinfo(matchlib, 10):
intlib::lookup(1/x/sqrt(x^2-1), x):
*/
