//
// look for substitutions that allow integration
//
// returns the first integral found. Tries to substitute
// less complicated subexpressions first.

intlib::findSubst :=
proc(f, x, options=table())
  local subexpressions, vars, ex, dex, ddex, res, pex, t;
  save MAXEFFORT;
begin
  if MAXEFFORT < 10000 then return(FAIL); end_if;
  if hastype(f, "int") then return(FAIL); end_if;     // subsex doesn't work properly here
  if hastype(f, "sum") then return(FAIL); end_if;     // subsex doesn't work properly here
  if hastype(f, "product") then return(FAIL); end_if; // subsex doesn't work properly here
  if hastype(f, "diff") then return(FAIL); end_if;    // subsex doesn't work properly here
  if hastype(f, "D") then return(FAIL); end_if;       // subsex doesn't work properly here
  subexpressions := table(0);
  misc::maprec(f,
    {DOM_EXPR} = (ex -> (if has(ex, x) then
                           subexpressions[ex] := subexpressions[ex]+1;
                           if type(ex)="_power" and op(ex, 1)=x and
                             testtype(op(ex, 2), DOM_INT) and op(ex, 2)<0 then
                             subexpressions[1/x] := subexpressions[1/x]+1;
                           end_if;
                         end_if; ex)), NoOperators, Unsimplified);
  subexpressions := prog::sort([op(map({op(subexpressions)}, op, 1))],
    length);
  // don't extract bound idents from symbolic sums etc.
  vars := freeIndets(f);
  subexpressions := select(subexpressions,
    ex -> freeIndets(ex) minus vars = {});
  MAXEFFORT := min(MAXEFFORT-100, 1.2*MAXEFFORT/nops(subexpressions));
  t := solvelib::getIdent(Any, indets([args()]));
  for ex in subexpressions do
    // do not use intlib::tryChangeVar - it calls solve
    // which may take almost arbitrarily long for uncontrolled inputs
    // --> only look for "more obvious" solutions
    //
    // Don't even bother checking symbolic sums and products:
    if hastype(ex, "sum") or hastype(ex, "product") then
      next;
    end_if;
    // the recursive int call assumes its var. of integration is real
    if has(f, [hold(abs), hold(sign), hold(dirac), hold(heaviside)]) and
      is(ex in R_, Goal=TRUE) <> TRUE then
      next;
    end_if;
    userinfo(10, "Trying to substitute ".expr2text(ex));
    dex := subsex(f/diff(ex, x), ex=t);
    if has(dex, [x]) and MAXEFFORT > 50*length(dex) then
      ddex := diff(dex, x);
      if has(ddex, hold([whittakerW, whittakerM, hypergeom, meijerG])) then
        next;
      end_if;
      if testeq(ddex, 0, hold(NumberOfRandomRatTests) = 2, NumberOfRandomTests=5, Steps=0) <> FALSE then
        dex := intlib::Simplify(dex, options, Steps=15);
      end_if;
    end_if;
    if has(dex, [x, undefined]) then next; end_if;
//    print(intlib::Simplify::defaultValuation(f),
//     intlib::Simplify::defaultValuation(dex));
//    if intlib::Simplify::defaultValuation(dex) >
//      1.1*intlib::Simplify::defaultValuation(f) then
//      next;
//    end_if;
    userinfo(5, "Substituting ".expr2text(ex)." worked");
    // linear substitutions only for selected integration rules:
    pex := poly(ex, [x]);
    if pex <> FAIL and degree(pex) = 1 and not has(poly2list(pex), [x]) then
      res := intlib::lookup(dex, t, options);
      if res = FAIL then
        res := intlib::ratSinCos(f, x, options);
      end_if;
    else
      res := intlib::int(dex, t, options);
    end_if;
    if res <> FAIL and not hastype(res, "int") and not has(res, intlib::frozenInt) then
      return(evalAt(res, t=ex));
    end_if;
  end_for;
  FAIL;
end:
