/*++ ---------------- getOptions.mu ---------------------

Description:
This file contains functions for handling the user given options.
                                                          
Functions: 


++*/

intlib::defaultOptions:=
table(
      PrincipalValue=FALSE,
      Continuous=FALSE,
      IgnoreSpecialCases=FALSE,
      hold(AlwaysExtractIntegrableParts)=FALSE,
      IgnoreAnalyticConstraints=FALSE,
      hold(DontSimplifyComplexIntegral)=FALSE,
      hold(RetryCall)=FALSE, // internal to intlib::int_intern, don't use anywhere else!
      hold(NoWarning)=FALSE
      ):

// don't print these
intlib::hiddenOptions := {Continuous, hold(AlwaysExtractIntegrableParts),
                          hold(RetryCall)}:

intlib::getOptions:=
  proc()
    local options;  
  begin
    options := prog::getOptions(1, [args()], intlib::defaultOptions, TRUE)[1];
    if options[PrincipalValue] and options[Continuous] then
      error("Illegal combination of options")
    end_if;
    options    
  end_proc:

intlib::printOptions:=
  proc(optionTable=intlib::defaultOptions)
    local o;
  begin
    op([(if contains(intlib::defaultOptions, op(o, 1)) and
           not op(o, 1) in intlib::hiddenOptions then
           if op(o,2)<>intlib::defaultOptions[op(o,1)] then
             if op(o,2) = TRUE then
               op(o,1);
             else
               o;
             end_if;
           else
             null();
           end_if;
         else
           null();
         end_if) $ o in optionTable])
  end_proc:
