// utilitiy functions for the pattern matcher

// check whether not has(fp/diff(f,x), x), but return
// unevaluated if f does not contain x
intlib::isConstTimesDiff :=
proc(f, fp, x)
  local fpp;
begin
  if not has(f, x) then
    return(procname(args()));
  end_if;
  fpp := diff(fp/diff(f, x), x);
  testeq(fpp, 0, NumberOfRandomTests=20, Steps=5);
end:

// to actually retrieve this constant:
intlib::getConstOfConstTimesDiff :=
proc(f, fp, x)
  local fpp;
begin
  if not has(f, x) then
    return(procname(args()));
  end_if;
  fpp := fp/diff(f, x);
  Simplify(fpp, Steps=20);
end:
