// parameters for tuning some integration routines 
//
// these routines are called at different places.
// Each routine is supposed to return an integer,
// which is then used as the MaxSteps parameter
// to a traperror() call.

// // trivial implementations:
// intlib::simplifyMaxSteps:=60:     // time limit for simplify within int
// intlib::discontMaxSteps:=42:      // time limit for discont within int
// intlib::limitMaxSteps:=42:        // time limit for limit calls within int

// time limit for simplification:
// first arg is integrand
// second arg is expression to simplify
// third arg is context:
//   sincos, abs,
//   rectform, I, (first argument is antiderivative)
//   discont (before the discont call),
//   limit (before the limit call, first arg is antiderivative),
//   return
intlib::simplifyMaxSteps :=
proc(f, ex, where)
begin
  if where=return then
    42;
  elif where="simpCint" then
    77;
  else
    23;
  end_if;
end_proc:

intlib::discontMaxSteps :=
proc(f, x, a, b)
begin
  42;
end_proc:

// args as passed to limit
intlib::limitMaxSteps :=
proc(f, x_x0)
begin
  42+floor(MAXEFFORT/100000);
end_proc:

// simplification inside matcher to check
// for fp = c*diff(f, x)
intlib::isDiffOfMaxSteps :=
proc(f, fp)
begin
  42;
end_proc:

// computing subresultant sequences can lead to huge expression swell
intlib::subresMaxSteps :=
proc(a, b)
begin
  23 + ceil(nterms(a)*nterms(b)/50);
end_proc:
