// rational functions in trig functions: try standard tan substitutions

intlib::ratSinCos :=
proc(f, x, options)
  local f2, t, integral, sinpos, sinargs, sinarg, sinargsLinear, a, b, terms, quot, K, c1, c2;
begin
  if not has(f, {hold(sin), hold(cos), hold(tan)}) then
    return(FAIL);
  end;
  if has(f, #t) then
    t := genident("tmp") = #t;
    f := subs(f, op(t, 2) = op(t, 1), Unsimplified);
  else
    t := null();
  end_if;

  f := misc::maprec(f,
    {"cot", "sec", "csc", "sinh", "cosh", "tanh", "coth", "sech", "csch"} =
      (ex -> if has(ex, [x]) then rewrite(ex, sincos) else ex end_if));

  // look for sin(x)/cos(x) and make tan(x) from that
  sinpos := {prog::find(f, hold(sin))};
  sinargs := map(sinpos, p -> op(f, p[1..-2].[1]));
  sinargs := select(sinargs, has, [x]);
  f2 := f;
  for sinarg in sinargs do
    f2 := subsex(f2, sin(sinarg)/cos(sinarg)=tan(sinarg));
  end_for;
  if f2 <> f then
    if options[hold(RetryCall)] = TRUE then
      f := f2;
    else
      integral := intlib::int(f2, x, table(options, hold(RetryCall)=TRUE));
      if integral <> FAIL then
        return(integral);
      end_if;
    end_if;
  end_if;
  
  // check for linear transformation moving sin(a*x+b)-like terms
  // to sin(n*x), with n as low as possible
  sinpos := {prog::find(f, hold(sin)), prog::find(f, hold(cos)), prog::find(f, hold(tan))};
  sinargs := map(sinpos, p -> op(f, p[1..-2].[1]));
  sinargs := select(sinargs, has, [x]);
  sinargsLinear := map(sinargs, Type::Linear, [x]);
  if FALSE in sinargsLinear then
    return(FAIL); // we only handle terms rational in {sin,cos,tan,...}(x) below
  end_if;
  [a, b] := op(sinargsLinear, 1);
  sinargsLinear := sinargsLinear minus {[a, b]};
  if nops(sinargsLinear) > 0 then
    for terms in sinargsLinear do
      assert(not iszero(terms[1]));
      if terms[2]/terms[1] <> b/a then
        // incompatible linear terms. The transformations below won't succeed
        return(FAIL);
      end_if;
      quot := terms[1]/a;
      if not domtype(quot) in {DOM_INT, DOM_RAT} then
        // incompatible linear terms. The transformations below won't succeed
        return(FAIL);
      end_if;
      if domtype(quot) = DOM_RAT then
        a := a / denom(quot);
        b := b / denom(quot);
      end_if;
    end_for;
  end_if;
  // substitute a*x+b. To avoid generating new identifiers, we'll continue using the same x.
  f := subs(f, x = (x-b)/a);
  t := t, x = a*x+b; // backsubstitution

/*
  f2 := combine(f, sincos);
  if f2 <> f then
    userinfo(2, "trying to integrate after combining sin/cos terms");
    integral := intlib::int_intern(f2, x);
    if not hastype(integral, "int") then
      return(integral);
    end_if;
  end_if;
*/

  // f := expand(f);
  f := misc::maprec(f,
    {"sin", "cos", "tan"} = (ex -> if has(ex, [x]) and op(ex) <> x and
                                     testtype(op(ex)/x, DOM_INT) then
                                     expand(ex)
                                   else ex end_if));

  // test f for the general form we want to see
  [c1, c2] := [1, 1];
  while traperror((
    f2 := subs(f, sin(x)=#t, cos(x)=c1*#t, tan(x)=c2*#t)
    )) <> 0 do
    [c1, c2] := [c1+c2, c1+1];
  end_while;

  if has(f2, x) or not testtype(f2,
                  Type::RatExpr(#t, Type::IndepOf(#t))) then
    // the things below still *might* help in some cases,
    // but usually take very long without yielding a result
    return(FAIL);
  end_if;

  f2 := subsex(f, [sin(x)^2=#t^2/(#t^2+1),
                   cos(x)^2=1/(#t^2+1),
                   sin(x)*cos(x)=#t/(#t^2+1),
                   tan(x)=#t]);
  if not has(f2, x) and
     (testtype(f2, Type::RatExpr(#t, Type::IndepOf(#t))) or
      Simplify::defaultValuation(f2) < 2*Simplify::defaultValuation(f))
     then
    userinfo(2,"try to substitute t=tan(".expr2text(x).")");
    integral := intlib::int(f2/(#t^2+1), #t, options);
    if not hastype(integral, "int") then
      integral := subsex(integral/a,
        arctan(#t)=x,
        #t^2/(#t^2+1)=sin(x)^2,
        #t/(#t^2+1)=sin(x)*cos(x),
        1/(#t^2+1)=cos(x)^2,
        #t=tan(x),
        t);
      if discont(f, x=-2..2)={} and
        traperror((K := limit(integral, x=PI/2, Right) - limit(integral, x=PI/2, Left)),
          MaxSteps = 5) = 0 and
        not hastype(K, "limit") and not has(K, infinity) and not has(K, undefined) then
        integral := integral - K*(x-arctan(tan(x)))/PI;
      end_if;
      return(integral);
    end_if;
  end_if;

  f2 := subsex(f/sin(x), [sin(x)^2=1-#t^2,
                          cos(x)=#t]);
  if not has(f2, x) and
     (testtype(f2, Type::RatExpr(#t, Type::IndepOf(#t))) or
      Simplify::defaultValuation(f2) < 2*Simplify::defaultValuation(f))
    then
    userinfo(2,"try to substitute t=cos(".expr2text(x).")");
    integral := intlib::int(f2, #t, options);
    if not hastype(integral, "int") then
      return(-subsex(integral/a,
        1-#t^2=sin(x)^2,
        #t=cos(x),
        t));
    end_if;
  end_if;

  f2 := subsex(f/cos(x), [sin(x)=#t,
                          cos(x)^2=1-#t^2]);
  if not has(f2, x) and
     (testtype(f2, Type::RatExpr(#t, Type::IndepOf(#t))) or
      Simplify::defaultValuation(f2) < 2*Simplify::defaultValuation(f))
    then
    integral := intlib::int(f2, #t, options);
    userinfo(2,"try to substitute t=sin(".expr2text(x).")");
    if not hastype(integral, "int") then
      return(subsex(integral/a,
        1-#t^2=cos(x)^2,
        #t=sin(x),
        t));
    end_if;
  end_if;

  f2 := eval(subsex(f, [sin(x)=2*#t/(1+#t^2),
                        cos(x)=(1-#t^2)/(1+#t^2),
                        tan(x)=2*#t/(1-#t^2),
                        cot(x)=(1-#t^2)/2/#t,
                        tan(x/2)=#t]));
  if not has(f2, x) and
     (testtype(f2, Type::RatExpr(#t, Type::IndepOf(#t))) or
      Simplify::defaultValuation(f2) < 2*Simplify::defaultValuation(f))
    then
    userinfo(2,"try to substitute t=tan(".expr2text(x)."/2)");
    integral := intlib::int(2*f2/(1+#t^2), #t, options);
    if not hastype(integral, "int") then
      // simplify first with "incorrect" substitution.
      // to do this, we have to temporarily remove
      // the assumptions on x
      proc()
      begin
        save x;
        traperror(unprotect(x));
        traperror(eval(hold(_delete)(x)));
        integral := subsex(integral/a,
          arctan(#t)=x/2,
          #t/(1+#t^2)=sin(x)/2,
          #t/(1-#t^2)=tan(x)/2,
          (1-#t^2)/(1+#t^2)=cos(x),
          (1-#t^2)/#t=2*cot(x),
          #t=tan(x/2));
        integral := intlib::Simplify(integral, options, Steps=30);
        if discont(f, x=-4..4)={} and
          traperror((K := limit(integral, x=PI, Right) - limit(integral, x=PI, Left)),
            MaxSteps = 5) = 0 and
          not hastype(K, "limit") and not has(K, infinity) and not has(K, undefined) then
          integral := integral - K*(x/2-arctan(tan(x/2)))/PI;
        end_if;
        return(integral);
      end_proc();
      return(subs(integral, t));
    end_if;
  end_if;

  FAIL;
end_proc:
