
// intlib::Simplify - specific rules and valuation for integration
intlib::Simplify :=
funcenv(
proc(ex, options=table() : DOM_TABLE)
  local sloppy;
begin
  sloppy := if options[IgnoreAnalyticConstraints] = TRUE then IgnoreAnalyticConstraints end_if;
  if type(ex)=piecewise then
    piecewise::extmap(ex, intlib::Simplify::Simplify, args(3..args(0)), sloppy)
  else
    intlib::Simplify::Simplify(ex, args(3..args(0)), sloppy)
  end_if
end_proc):

intlib::Simplify::operatorTable := subs(Simplify::defaultOperatorTable,
  hold(Simplify::complexity) = hold(intlib::Simplify::complexity)):
  
intlib::Simplify::operatorTable["ln"] := [45, 2]:
intlib::Simplify::operatorTable["sin"] := [26, 1.5]:
intlib::Simplify::operatorTable["cos"] := [26.01, 1.5]:
intlib::Simplify::operatorTable["exp"] := [25.5, 1.5]:
intlib::Simplify::operatorTable["tan"] := [70, 3]:
intlib::Simplify::operatorTable["cot"] := [75, 3]:
intlib::Simplify::operatorTable["abs"] := [120, 1.2]:
intlib::Simplify::operatorTable["I"] := 8:

intlib::Simplify::complexity :=
  Simplify::createValuation(intlib::Simplify::operatorTable):

intlib::Simplify::defaultValuation:=
proc(EXPR)
begin
  float(Simplify::indetComplexity(EXPR) + intlib::Simplify::complexity(EXPR)/2
        + Simplify::pairPenalty(EXPR))
end_proc:

// "inherit" match rules from Simplify, with local modifications
intlib::Simplify::Rules := newDomain("intlib::Simplify::Rules"):

/*intlib::Simplify::Rules::tan :=
proc(ex: "tan")
begin
  Simplify::Rules::tan(ex) .
  [
    Rule(tan(`#x`), sin(`#x`)/cos(`#x`)),
    Rule(tan(`#x`), 2*tan(`#x`/2)/(1-tan(`#x`/2)^2)),
    Rule(tan(`#x`), -tan(2*`#x`)*(tan(`#x`)^2-1)/2)
  ]
end_proc:
*/

intlib::Simplify::Rules::All :=
proc(ex) : DOM_LIST
//  local ;
begin
  Simplify::All(ex) . [
    if domtype(ex) = DOM_EXPR then
      if has(ex, {hold(tan)}) then
        Rule(x -> rewrite(x, cos), {}, table("Default" = 0.8)),
        Rule(x -> expand(rewrite(x, cos)), {}, table("Default" = 1.3))
      else null() end_if,
      if has(ex, {hold(tan)}) then
        Rule(x -> rewrite(x, sin), {}, table("Default" = 0.8)),
        Rule(x -> expand(rewrite(x, sin)), {}, table("Default" = 1.3))
      else null() end_if,
      if indets(ex)={} then
        Rule(x -> combine(x), {}, table("Default" = 0.7))
      else null() end_if,
      if has(ex, I) and indets(ex)={} then
        Rule(x -> expr(rectform(x)), {}, table("Default" = 0.8))
      else null() end_if
    else null() end_if
  ]
end_proc:

// "Global" rules apply at top level only.
// For antiderivatives, at this place, we want
// to allow simplifications that ignore
// piecewise constants. NOTE: These rules work
// if and only if the variable of integration is _X!
intlib::Simplify::RulesAntiderivative := 
newDomain("RulesAntiderivative"):

intlib::Simplify::RulesAntiderivative::Global :=
proc(ex) : DOM_LIST
begin
  intlib::Simplify::Rules::Global(ex) . [
    if type(ex) = "_plus" then
      Rule(x -> select(x, has, _X), {}, table("Default" = 0.9)),

      Rule(`#a`+arctan(tan(`#b`)), `#a`+`#b`, {}, table("Default" = 0.8)),
      Rule(`#a`+arcsin(sin(`#b`)), `#a`+`#b`, {}, table("Default" = 0.8)),
      Rule(`#a`+ln(exp(`#b`)), `#a`+`#b`, {}, table("Default" = 0.8)),
      Rule(#a+ln(#b*#c)*#d, #a+ln(#b)*#d, {#c -> not has(#c, _X), #d -> not has(#d, _X)}, table("Default" = 0.8))
    else null() end_if
  ]
end_proc:

intlib::Simplify::RulesAntiderivative::make_slot := 
proc(DOM, e)
//  local t;
begin
  slot(intlib::Simplify::Rules, e);
end_proc:

intlib::Simplify::Rules::make_slot := 
proc(DOM, e)
//  local t;
begin
  slot(Simplify, e);
end_proc:




intlib::Simplify::Simplify := subsop(Simplify::Simplifier(
  RuleBase  = intlib::Simplify::Rules,
  Valuation = intlib::Simplify::defaultValuation,
//  Discard   = FALSE,
  KernelSteps = 7,
  Steps = 25,
  Remember  = FALSE // we must change the name first ...
), 6=NIL):

intlib::Simplify::Simplify := prog::remember(
  intlib::Simplify::Simplify,
  property::depends,
  PreventRecursion,
  x -> x // first arg only
):

null():
