/*-
 
 Graph - 2002 by Joern Maas
 Library package for working with Graphs (directed graphs)
-*/


Graph := newDomain("Graph"):
Graph::create_dom:=hold(Graph):
Graph::info := "Library 'Graph': package for handling directed and undirected graphs":
Graph::interface :=
{
 hold(addEdges), hold(addVertices), hold(bipartite), hold(breadthFirstSearch),
 hold(checkForVertices), hold(chromaticNumber), hold(chromaticPolynomial), 
 hold(createCircleGraph), hold(createCompleteGraph),
 hold(createRandomEdgeWeights), hold(createRandomEdgeCosts), 
 hold(createRandomVertexWeights), hold(createRandomGraph),
 hold(depthFirstSearch), hold(getAdjacentEdgesEntering), 
 hold(getAdjacentEdgesLeaving), hold(getBestAdjacentEdge), hold(getEdgeCosts),
 hold(getEdgeDescriptions), hold(getEdges), hold(getEdgesEntering),
 hold(getEdgesLeaving), hold(getEdgeWeights), hold(getEdgeNumber),
 hold(getSubGraph), hold(getVertexNumber), hold(getVertexWeights),
 hold(getVertices), hold(inDegree), hold(isConnected), hold(isDirected),
 hold(isEdge), hold(isVertex), hold(minimumSpanningTree), hold(outDegree), 
 hold(plotBipartiteGraph), hold(plotCircleGraph), hold(plotGridGraph),
 hold(printGraphInformation), hold(printVertexInformation),
 hold(printEdgeInformation), hold(printEdgeDescInformation),
 hold(printEdgeCostInformation), hold(printEdgeWeightInformation),
 hold(removeEdge), hold(removeVertex), hold(residualGraph), hold(revert), 
 hold(setEdgeCosts), hold(setEdgeDescriptions), hold(setEdgeWeights),
 hold(setVertexWeights), hold(shortestPathSingleSource),
 hold(shortestPathAllPairs), hold(stronglyConnectedComponents), hold(topSort),
 hold(contract), hold(createGraphFromMatrix), hold(convertSSQ),
 hold(admissibleFlow), hold(minCut), hold(minCost), hold(maxFlow),
 hold(residualGraph), hold(longestPath), hold(new)
}:
  
alias(path = pathname("GRAPH")):

// ***************************************************************************************************
// Here come all the procedures defined in the Graph-library
// ***************************************************************************************************
Graph::new                         := loadproc(Graph::new, path, "new"):
Graph::addEdges                    := loadproc(Graph::addEdges, path, "addEdge"):
Graph::selectEdge                  := loadproc(Graph::selectEdge, path, "selectEdge"):
Graph::removeEdge                  := loadproc(Graph::removeEdge, path, "removeEdge"):
Graph::selectVertex                := loadproc(Graph::selectVertex, path, "selectVertex"):
Graph::addVertices                 := loadproc(Graph::addVertices, path, "addVertex"):
Graph::removeVertex                := loadproc(Graph::removeVertex, path, "removeVertex"):
Graph::createRandomEdgeCosts       := loadproc(Graph::createRandomEdgeCosts, path, "createRandomEdgeCosts"):
Graph::createRandomEdgeWeights     := loadproc(Graph::createRandomEdgeWeights, path, "createRandomEdgeWeights"):
Graph::createRandomVertexWeights   := loadproc(Graph::createRandomVertexWeights, path, "createRandomVertexWeights"):
Graph::createCompleteGraph         := loadproc(Graph::createCompleteGraph, path, "createCompleteGraph"):
Graph::createGraphFromMatrix       := loadproc(Graph::createGraphFromMatrix, path, "createGraphFromMatrix"):
Graph::createRandomGraph           := loadproc(Graph::createRandomGraph, path, "createRandomGraph"):
Graph::createCircleGraph           := loadproc(Graph::createCircleGraph, path, "createCircleGraph"):
Graph::setVertexWeights            := loadproc(Graph::setVertexWeights, path, "setVertexWeights"):
Graph::setEdgeDescriptions         := loadproc(Graph::setEdgeDescriptions, path, "setEdgeDescriptions"):
Graph::setEdgeWeights              := loadproc(Graph::setEdgeWeights, path, "setEdgeWeights"):
Graph::setEdgeCosts                := loadproc(Graph::setEdgeCosts, path, "setEdgeCosts"):
Graph::topSort                     := loadproc(Graph::topSort, path, "topSort"):
Graph::getSubGraph                 := loadproc(Graph::getSubGraph, path, "getSubGraph"):
Graph::plotCircleGraph             := loadproc(Graph::plotCircleGraph, path, "plotCircleGraph"):
Graph::plotBipartiteGraph          := loadproc(Graph::plotBipartiteGraph, path, "plotBipartiteGraph"):
Graph::plotGridGraph               := loadproc(Graph::plotGridGraph, path, "plotGridGraph"):
Graph::checkForVertices            := loadproc(Graph::checkForVertices, path, "checkForVertices"):
Graph::revert                      := loadproc(Graph::revert, path, "revertGraph"):
Graph::_union                      := loadproc(Graph::_union, path, "union"):
Graph::chromaticPolynomial         := loadproc(Graph::chromaticPolynomial, path, "chromaticPolynomial"):
Graph::chromaticNumber             := loadproc(Graph::chromaticNumber, path, "chromaticNumber"):
Graph::depthFirstSearch            := loadproc(Graph::depthFirstSearch, path, "depthFirstSearch"):
Graph::breadthFirstSearch          := loadproc(Graph::breadthFirstSearch, path, "breadthFirstSearch"):
Graph::getBestAdjacentEdge         := loadproc(Graph::getBestAdjacentEdge, path, "getBestAdjacentEdge"):
Graph::bipartite                   := loadproc(Graph::bipartite, path, "bipartite"):
Graph::isConnected                 := loadproc(Graph::isConnected, path, "isConnected"):
Graph::stronglyConnectedComponents := loadproc(Graph::stronglyConnectedComponents, path, "stronglyConnectedComponents"):
Graph::contract                    := loadproc(Graph::contract, path, "contract"):
Graph::longestPath                 := loadproc(Graph::longestPath, path, "longestPath"):

// Collection of very small procedures
Graph::isEmpty                  := loadproc(Graph::isEmpty, path, "toolSet"):
Graph::createMinSort            := loadproc(Graph::createMinSort, path, "toolSet"):
Graph::getVertices              := loadproc(Graph::getVertices, path, "toolSet"):
Graph::getEdges                 := loadproc(Graph::getEdges, path, "toolSet"):
Graph::getVertexWeights         := loadproc(Graph::getVertexWeights, path, "toolSet"):
Graph::getEdgeDescriptions      := loadproc(Graph::getEdgeDescriptions, path, "toolSet"):
Graph::getEdgeWeights           := loadproc(Graph::getEdgeWeights, path, "toolSet"):
Graph::getEdgeCosts             := loadproc(Graph::getEdgeCosts, path, "toolSet"):
Graph::getEdgesEntering         := loadproc(Graph::getEdgesEntering, path, "toolSet"):
Graph::getEdgesLeaving          := loadproc(Graph::getEdgesLeaving, path, "toolSet"):
Graph::isDirected               := loadproc(Graph::isDirected, path, "toolSet"):
Graph::isVertex                 := loadproc(Graph::isVertex, path, "toolSet"):
Graph::isEdge                   := loadproc(Graph::isEdge, path, "toolSet"):
Graph::graphCheck               := loadproc(Graph::graphCheck, path, "toolSet"):
Graph::getVertexNumber          := loadproc(Graph::getVertexNumber, path, "toolSet"):
Graph::getEdgeNumber            := loadproc(Graph::getEdgeNumber, path, "toolSet"):
Graph::getAdjacentEdgesEntering := loadproc(Graph::getAdjacentEdgesEntering, path, "toolSet"):
Graph::getAdjacentEdgesLeaving  := loadproc(Graph::getAdjacentEdgesLeaving, path, "toolSet"):

// In- and Out-Degree
Graph::inDegree  := loadproc(Graph::inDegree, path, "degree"):
Graph::outDegree := loadproc(Graph::outDegree, path, "degree"):

// Everything that has to do with printing
Graph::print                      := loadproc(Graph::print, path, "printCollection"):
Graph::expr2text                  := loadproc(Graph::expr2text, path, "printCollection"):
Graph::outputStrings              := loadproc(Graph::outputStrings, path, "printCollection"):
Graph::printGraphInformation      := loadproc(Graph::printGraphInformation, path, "printCollection"):
Graph::printVertexInformation     := loadproc(Graph::printVertexInformation, path, "printCollection"):
Graph::printEdgeInformation       := loadproc(Graph::printEdgeInformation, path, "printCollection"):
Graph::printEdgeDescInformation   := loadproc(Graph::printEdgeDescInformation, path, "printCollection"):
Graph::printEdgeCostInformation   := loadproc(Graph::printEdgeCostInformation, path, "printCollection"):
Graph::printEdgeWeightInformation := loadproc(Graph::printEdgeWeightInformation, path, "printCollection"):

// Everything for Single Source Shortest Path
Graph::shortestPathSingleSource := loadproc(Graph::shortestPathSingleSource, path, "shortestPathSingleSource"):
Graph::sssp_Dijkstra            := loadproc(Graph::sssp_Dijkstra, path, "shortestPathSingleSource"):
Graph::sssp_Bellman             := loadproc(Graph::sssp_Bellman, path, "shortestPathSingleSource"):

// Everything for Single Source All Pairs
Graph::shortestPathAllPairs := loadproc(Graph::shortestPathAllPairs, path, "shortestPathAllPairs"):
Graph::apsp_Floyd := loadproc(Graph::apsp_Floyd, path, "shortestPathAllPairs"):

// Everything for Minimum Spanning Tree
Graph::minimumSpanningTree := loadproc(Graph::minimumSpanningTree, path, "minimumSpanningTree"):
Graph::mst_Kruskal := loadproc(Graph::mst_Kruskal, path, "minimumSpanningTree"):

// Everything for Networks
Graph::convertSSQ := loadproc(Graph::convertSSQ, path, "convertSSQ"):
Graph::admissibleFlow := loadproc(Graph::admissibleFlow, path, "admissibleFlow"):
Graph::pp_fifo := loadproc(Graph::pp_fifo, path, "pp_fifo"):
Graph::minCut := loadproc(Graph::minCut, path, "minCut"):
Graph::minCost := loadproc(Graph::minCost, path, "minCost"):
Graph::maxFlow := loadproc(Graph::maxFlow, path, "maxFlow"):
Graph::residualGraph := loadproc(Graph::residualGraph, path, "residualGraph"):
Graph::relaxation := loadproc(Graph::relaxation, path, "relaxation"):

