Pref:= newDomain("Pref"):
Pref::create_dom:=hold(Pref):
Pref::info:= "The domain of preferences [try ?Pref for details]":
Pref::interface:= 
    {hold(verboseRead), hold(callBack), hold(callOnExit),
     hold(floatFormat), hold(maxTime), hold(maxMem), hold(output), hold(postInput),
     hold(postOutput), hold(report), hold(typeCheck), hold(keepOrder), hold(kernel),
     hold(userOptions), hold(ignoreNoDebug), hold(trailingZeroes), hold(alias),
     hold(unloadableModules), hold(warnDeadProcEnv), hold(dbgAutoList),
     hold(abbreviateOutput), hold(outputDigits),
     hold(dbgAutoDisplay), hold(autoPlot), hold(autoExpansionLimit)}:

Pref::new:=
    // Pref()     -  print table of preferences and corresponding values 
    // Pref(NIL)  -  reset preferences to their default values           
    // 
    // Note: A new preference must be entered in the set Pref::interfaces, 
    //       otherwise 'Pref()' and 'Pref(NIL)' will not work correctly!   
    proc()
        local s, l, e, sf;
	save PRETTYPRINT, TEXTWIDTH;
    begin
        PRETTYPRINT:= FALSE;
        TEXTWIDTH:= 32000:

        case args(0)
        of 0 do
            sf:= map( Pref::interface,expr2text );
            l:= max( op(map(sf,length)) ) + 6;

            s:= [];
            for e in sf do
                s:= s . [stringlib::format( "Pref::".e,l,Left ) . ": " . expr2text( slot(Pref,e)() ) . "\n"]
            end_for;
            print(Unquoted, _concat(op(sort(s))));
            return(null());
        of 1 do 
            if args(1) <> NIL then error("expecting 'NIL' as argument") end_if;

            // reset preferences to their default value 
            sf:= map( Pref::interface,expr2text );
            for e in sf do
                case (s:= slot( slot( Pref,e ),"default" ))
                of FAIL do break; // read-only 
                of "NIL" do // default value is NIL 
                    slot( Pref,e )(NIL); break
                otherwise
                    slot( Pref,e )(s)
                end_case
            end_for;
            return( null() )
        otherwise
            error("expecting either none or one argument")
        end_case;
    end_proc:

proc()
    option noDebug;
    local path;
begin

path := pathname("PREF");

autoload(Pref::verboseRead):
autoload(Pref::alias):

Pref::callBack:=
    loadproc(Pref::callBack,path,"callback"):

Pref::callOnExit:=
    loadproc(Pref::callOnExit,path,"callexit"):

Pref::allComplete := 
    loadproc(Pref::allComplete, path, "complall"):
Pref::noComplete  := 
    loadproc(Pref::noComplete,  path, "complall"):
Pref::keywords  := 
    loadproc(Pref::keywords,  path, "complall"):

autoload(Pref::floatFormat):

Pref::maxTime:=
    loadproc(Pref::maxTime,path,"maxtime"):

Pref::maxMem:=
    loadproc(Pref::maxMem,path,"maxmem"):

autoload(Pref::output):
autoload(Pref::postInput):
autoload(Pref::postOutput):
autoload(Pref::prompt):
autoload(Pref::report):
autoload(Pref::typeCheck):
autoload(Pref::keepOrder):
autoload(Pref::kernel):
autoload(Pref::promptString):
autoload(Pref::userOptions):
autoload(Pref::moduleTrace):
autoload(Pref::ignoreNoDebug):

Pref::trailingZeroes:=
    loadproc(Pref::trailingZeroes,path,"delzero"):

autoload(Pref::warnDeadProcEnv):

autoload(Pref::abbreviateOutput):
autoload(Pref::autoExpansionLimit):
autoload(Pref::autoPlot):
autoload(Pref::dbgAutoDisplay):
autoload(Pref::dbgAutoList):
autoload(Pref::mackichan):
autoload(Pref::outputDigits):
autoload(Pref::unloadableModules):

null()
end_proc():

// end of file 

