// series.mu--library for series expansions

alias(path = pathname("SERIES")):


Series:=newDomain("Series"):
Series::create_dom:=hold(Series):
Series::info:="Library 'Series': tools and data structures for series expansions":
Series::interface:={hold(Puiseux),hold(gseries)}:

// Puiseux and Laurent series expansions
Series::Puiseux:= loadproc(Series::Puiseux, path, "laurent"):
// generalized series expansions
Series::gseries:= loadproc(Series::gseries, path, "gseries"):

// internal functions used in Puiseux:
Series::printO:= loadproc(Series::printO, path, "series"):
Series::series:= loadproc(Series::series, path, "series"):
Series::expr2coeff:= loadproc(Series::expr2coeff, path, "FPS"):
Series::unknown:= loadproc(Series::unknown, path, "series"):
Series::check_point:= loadproc(Series::check_point, path, "series"):

null():

