//     

/*++
Type -- the domain of type expressions

A type expression is an object with 5 operands:-

1. an identifier with the name of the type
2. a procedure for testing the type of an expression
3. additional argument for the type testing procedure
4. a boolean value signalling that the type is a kind of _exprseq
5. an (optional) argument for the library `property'
...

The type testing procedure is called to check the type of an
expression. It is called with the 3rd operand of the type
expression and the expression to test as arguments.

The type testing procedure must return TRUE if
the expression has the correct type, FALSE if the expression
has not the correct type and FAIL if the routine can't
decide if the expression has the correct type.
++*/

Type:= newDomain("Type"):
Type::create_dom:=hold(Type):

Type::info:= "Library 'Type': type expressions and properties":
Type::interface:=
   {hold(ListOf), hold(Union), hold(Intersection), hold(SequenceOf),
    hold(RatExpr), hold(PolyExpr),
    hold(AlgebraicConstant),
    hold(Constant),
    hold(Condition),
    hold(ConstantIdents),
    hold(ElementOf),
    hold(Product), // -> Sequence?
    hold(ListProduct), //uberflussig
    hold(PolyOf), hold(SetOf),
    hold(IndepOf),
    hold(Unknown),
    hold(NonZero),
    hold(Zero),
    hold(Prime),
    hold(PosInt),
    hold(NonNegInt),
    hold(NegInt),
    hold(Integer),
    hold(PosRat),
    hold(NonNegRat),
    hold(NegRat),
    hold(Rational),
    hold(Positive),
    hold(NonNegative),
    hold(Negative),
    ////hold(Irrational), // nicht dokumentiert
    hold(Real),
    ////hold(IntImaginary), // nicht dokumentiert
    hold(Imaginary),
    hold(Complex),
    hold(Residue),
    hold(Even),
    hold(Odd),
    hold(Interval),
    hold(AnyType), hold(Series), hold(TableOfIndex),
    hold(TableOf),
    hold(TableOfEntry), hold(Relation), hold(Equation), hold(Singleton),
    hold(Numeric),
    hold(Arithmetical),
    hold(Property),
    hold(Set),
    hold(Boolean),
    hold(Function),
    hold(Indeterminate),
    hold(Predicate)
}:

Type::type:=
	proc(T) option noDebug; begin extop(T, 1) end_proc:

Type::testtype:=
  proc(x,T)
    option noDebug;
  begin
    if domtype(x) = Type then
      case T 
         of Type::AnyType do 
         of Type do
           return(TRUE)
         of Type::Property do
           // overload by second argument
           break
         otherwise
           return(FALSE)
      end_case;
    end_if;
    // now x is not a Type, or T is Type::Property
    extop(T,2)(extop(T,3), x)
end_proc:

Type::print:= proc(x)
    option noDebug;
begin
    if slot(extop(x, 0), "prop") <> FAIL then
      slot(extop(x, 0), "print")(x)
    elif extop(x, 3) = FALSE then
      hold(slot)(Type, extop(x, 1))
    else
      hold(slot)(Type, extop(x, 1))(op(extop(x, 3)))
    end_if
end_proc:

Type::TeX :=
proc(x, prio)
    option noDebug;
begin
  if slot(extop(x, 0), "prop") <> FAIL then
    slot(extop(x, 0), "TeX")(x, prio);
    if % <> FAIL then return(%); end_if;
  end_if;
  generate::tex(dom::print(x), prio);
end_proc:

Type::isSeqType:= proc(t)
  option noDebug;
begin
    if domtype(t) = Type then
      extop(t,4)
    else
      FALSE
    end_if
end_proc:

// AnyType matches any type
Type::AnyType:= new(Type, "AnyType", TRUE, FALSE, FALSE):

alias(path = pathname("TYPE")):

Type::Condition := autoload( Type::Condition ):
Type::ElementOf:= loadproc(Type::ElementOf, path, "ElementOf"):
Type::Equation:= loadproc(Type::Equation, path, "Equation"):
Type::Unknown:= loadproc(Type::Unknown, path, "Unknown"):
Type::IndepOf:= loadproc(Type::IndepOf, path, "IndepOf"):
Type::ListOf:= loadproc(Type::ListOf, path, "ListOf"):

Type::ListProduct:= loadproc(Type::ListProduct, path, "LstProd"):
Type::PolyOf:= loadproc(Type::PolyOf, path, "PolyOf"):
Type::Product:= loadproc(Type::Product, path, "Product"):
Type::Relation:= loadproc(Type::Relation, path, "Relation"):
Type::SequenceOf:= loadproc(Type::SequenceOf, path, "SequOf"):
Type::SetOf:= loadproc(Type::SetOf, path, "SetOf"):
Type::TableOf:= loadproc(Type::TableOf, path, "TableOf"):
Type::TableOfIndex:= loadproc(Type::TableOfIndex, path, "TblOfInd"):
Type::TableOfEntry:= loadproc(Type::TableOfEntry, path, "TblOfEnt"):
Type::Union:= loadproc(Type::Union, path, "Union"):
Type::Intersection:= loadproc(Type::Intersection, path, "Intersection"):
Type::Singleton:= loadproc(Type::Singleton, path, "Single"):

Type::Property:= loadproc(Type::Property, path, "Property"):
Type::Boolean:= loadproc(Type::Boolean, path, "BoolExpr"):
Type::Set:= loadproc(Type::Set, path, "SetExpr"):
Type::Predicate:= loadproc(Type::Predicate, path, "Predicate"):

Type::NonZero:= loadproc(Type::NonZero, path, "NonZero"):
Type::Zero:= loadproc(Type::Zero, path, "Zero"):
Type::Prime:= loadproc(Type::Prime, path, "Prime"):
Type::PosInt:= loadproc(Type::PosInt, path, "PosInt"):
Type::NonNegInt:= loadproc(Type::NonNegInt, path, "NoNegInt"):
Type::NegInt:= loadproc(Type::NegInt, path, "NegInt"):
Type::Integer:= loadproc(Type::Integer, path, "Integer"):
Type::PosRat:= loadproc(Type::PosRat, path, "PosRat"):
Type::NonNegRat:= loadproc(Type::NonNegRat, path, "NoNegRat"):
Type::NegRat:= loadproc(Type::NegRat, path, "NegRat"):
Type::Rational:= loadproc(Type::Rational, path, "Rational"):
Type::Irrational:= loadproc(Type::Irrational, path, "Irration"):
Type::Positive:= loadproc(Type::Positive, path, "Positive"):
Type::NonNegative:= loadproc(Type::NonNegative, path, "NonNegat"):
Type::Negative:= loadproc(Type::Negative, path, "Negative"):
Type::Real:= loadproc(Type::Real, path, "RealNum"):
Type::IntImaginary:= loadproc(Type::IntImaginary, path, "IntImag"):
Type::Imaginary:= loadproc(Type::Imaginary, path, "Imagin"):
Type::Complex:= loadproc(Type::Complex, path, "Complex"):
Type::Numeric:= loadproc(Type::Numeric, path, "Numeric"):

Type::Residue:= loadproc(Type::Residue, path, "Residue"):
Type::Even:= loadproc(Type::Even, path, "Even"):
Type::Odd:= loadproc(Type::Odd, path, "Odd"):

Type::Interval:= loadproc(Type::Interval, path, "IV"):

Type::AlgebraicConstant:= loadproc(Type::AlgebraicConstant, path, "AlgConst"):
Type::Constant:= loadproc(Type::Constant, path, "Constant"):
Type::ConstantIdents:= loadproc(Type::ConstantIdents, path, "Constant"):
Type::PolyExpr:= loadproc(Type::PolyExpr, path, "PolyExpr"):
Type::RatExpr:= loadproc(Type::RatExpr, path, "RatExpr"):
Type::Arithmetical:= loadproc(Type::Arithmetical, path, "Arith"):

Type::Series:= loadproc(Type::Series, path, "Series"):

Type::ODE:= loadproc(Type::ODE, path, "ODE"):
Type::Linear:= loadproc(Type::Linear, path, "Linear"):

Type::Function:= loadproc(Type::Function, path, "Function"):
Type::Indeterminate := loadproc(Type::Indeterminate, path, "Indeterminate"):


null():

// end of file
