// 

/*

   DOM_INTERVAL -- sets up the methods of DOM_INTERVAL.

*/

alias(path=pathname("INTERVAL")):

DOM_INTERVAL := domtype(hull(0)):
DOM_INTERVAL::new := hull:
DOM_INTERVAL::new_extelement := DOM_ARRAY::new_extelement:
DOM_INTERVAL::ln := `DOM_INTERVAL::ln`:
sysdelete(`DOM_INTERVAL::ln`):
DOM_INTERVAL::exp := `DOM_INTERVAL::exp`:
sysdelete(`DOM_INTERVAL::exp`):
DOM_INTERVAL::sin_internal := `DOM_INTERVAL::sin`:
sysdelete(`DOM_INTERVAL::sin`):
DOM_INTERVAL::cos_internal := `DOM_INTERVAL::cos`:
sysdelete(`DOM_INTERVAL::cos`):
DOM_INTERVAL::arctan_internal := `DOM_INTERVAL::arctan`:
sysdelete(`DOM_INTERVAL::arctan`):
DOM_INTERVAL::sinh_internal := `DOM_INTERVAL::sinh`:
sysdelete(`DOM_INTERVAL::sinh`):

// due to lack of documentation:
DOM_INTERVAL::interface := {}:
//        hold(Im), hold(Re), hold(TeX), hold(abs), 
//        hold(arccos), hold(arccosh), hold(arccot), hold(arccoth),
//        hold(arccsc), hold(arccsch), hold(arcsec), hold(arcsech),
//        hold(arcsin), hold(arcsinh), hold(arctan), hold(arctanh),
//        hold(arg),
//        hold(beta),
//        hold(ceil), hold(center), 
//        hold(cos), hold(cosh), hold(cot), hold(coth),
//        hold(csc), 
//        hold(dirac),
//        hold(exp),
//        hold(floor),
//        hold(gamma),
//        hold(ln),
//        hold(lhs),
//        hold(mag), hold(mig),
//        hold(random),
//        hold(rhs),
//        hold(round),
//        hold(sec),
//        hold(sign),
//        hold(sin), hold(sinh), 
//        hold(sqrt),
//        hold(tan), hold(tanh),
//        hold(trunc), hold(width),
//        hold(zeta)
//        }:

// First, set up DOM_INTERVAL
DOM_INTERVAL::sin      := loadproc(DOM_INTERVAL::sin, path, "iv_sin"):
DOM_INTERVAL::cos      := loadproc(DOM_INTERVAL::cos, path, "iv_sin"):
DOM_INTERVAL::tan      := loadproc(DOM_INTERVAL::tan, path, "iv_sin"):
DOM_INTERVAL::cot      := loadproc(DOM_INTERVAL::cot, path, "iv_sin"):
DOM_INTERVAL::csc      := loadproc(DOM_INTERVAL::csc, path, "iv_sin"):
DOM_INTERVAL::sec      := loadproc(DOM_INTERVAL::sec, path, "iv_sin"):
DOM_INTERVAL::arcsin   := loadproc(DOM_INTERVAL::arcsin, path, "iv_sin"):
DOM_INTERVAL::arccos   := loadproc(DOM_INTERVAL::arccos, path, "iv_sin"):
DOM_INTERVAL::arctan   := loadproc(DOM_INTERVAL::arctan, path, "iv_sin"):
DOM_INTERVAL::arccot   := loadproc(DOM_INTERVAL::arccot, path, "iv_sin"):
DOM_INTERVAL::arccsc   := loadproc(DOM_INTERVAL::arccsc, path, "iv_sin"):
DOM_INTERVAL::arcsec   := loadproc(DOM_INTERVAL::arcsec, path, "iv_sin"):
DOM_INTERVAL::cosh     := loadproc(DOM_INTERVAL::cosh, path, "iv_sinh"):
DOM_INTERVAL::arccosh  := loadproc(DOM_INTERVAL::arccosh, path, "iv_sinh"):
DOM_INTERVAL::arcsinh  := loadproc(DOM_INTERVAL::arcsinh, path, "iv_sinh"):
DOM_INTERVAL::arccsch  := loadproc(DOM_INTERVAL::arccsch, path, "iv_sinh"):
DOM_INTERVAL::arcsech  := loadproc(DOM_INTERVAL::arcsech, path, "iv_sinh"):
DOM_INTERVAL::arccoth  := loadproc(DOM_INTERVAL::arccoth, path, "iv_sinh"):
DOM_INTERVAL::sinh     := loadproc(DOM_INTERVAL::sinh, path, "iv_sinh"):
DOM_INTERVAL::coth     := loadproc(DOM_INTERVAL::coth, path, "iv_sinh"):
DOM_INTERVAL::tanh     := loadproc(DOM_INTERVAL::tanh, path, "iv_sinh"):
DOM_INTERVAL::arctanh  := loadproc(DOM_INTERVAL::arctanh, path, "iv_sinh"):
DOM_INTERVAL::center   := loadproc(DOM_INTERVAL::center, path, "iv_abs"):
DOM_INTERVAL::width    := loadproc(DOM_INTERVAL::width, path, "iv_abs"):
DOM_INTERVAL::dirac    := loadproc(DOM_INTERVAL::dirac, path, "iv_abs"):
DOM_INTERVAL::sign     := loadproc(DOM_INTERVAL::sign, path, "iv_abs"):
DOM_INTERVAL::zeta     := loadproc(DOM_INTERVAL::zeta, path, "zeta"):
DOM_INTERVAL::psi      := loadproc(DOM_INTERVAL::psi, path, "psi"):
//DOM_INTERVAL::lambertW := loadproc(DOM_INTERVAL::lambertW, path, "lambertW"):

// DOM_INTERVAL::besselJ := loadproc(DOM_INTERVAL::besselJ, path, "besselJ"):

DOM_INTERVAL::random  := () -> hull(frandom(), frandom()):

DOM_INTERVAL::TeX     := loadproc(DOM_INTERVAL::TeX, path, "iv_util"):

DOM_INTERVAL::sqrt := x -> x^(1/2):

DOM_INTERVAL::set2expr := `DOM_INTERVAL::set2expr`:
sysdelete(`DOM_INTERVAL::set2expr`):

// still broken:
// DOM_INTERVAL::igamma := loadproc(DOM_INTERVAL::igamma, path, "igamma"):

DOM_INTERVAL::Re := loadproc(DOM_INTERVAL::Re, path, "ReIm"):
DOM_INTERVAL::Im := loadproc(DOM_INTERVAL::Im, path, "ReIm"):

DOM_INTERVAL::arg := `DOM_INTERVAL::arg`:
sysdelete(`DOM_INTERVAL::arg`):
DOM_INTERVAL::abs := `DOM_INTERVAL::abs`:
sysdelete(`DOM_INTERVAL::abs`):

DOM_INTERVAL::ceil  := loadproc(DOM_INTERVAL::ceil,  path, "ceil"):
DOM_INTERVAL::rhs   := loadproc(DOM_INTERVAL::rhs,   path, "ceil"):
DOM_INTERVAL::floor := loadproc(DOM_INTERVAL::floor, path, "ceil"):
DOM_INTERVAL::lhs   := loadproc(DOM_INTERVAL::lhs,   path, "ceil"):
DOM_INTERVAL::round := loadproc(DOM_INTERVAL::round, path, "ceil"):
DOM_INTERVAL::trunc := loadproc(DOM_INTERVAL::trunc, path, "ceil"):

DOM_INTERVAL::beta := loadproc(DOM_INTERVAL::beta, path, "beta"):

DOM_INTERVAL::mag := x -> rhs(DOM_INTERVAL::abs(x)):
DOM_INTERVAL::mig := x -> lhs(DOM_INTERVAL::abs(x)):

DOM_INTERVAL::_bernoulli := loadproc(DOM_INTERVAL::_bernoulli, path, "gamma"):
DOM_INTERVAL::_compute_gamma_coeffs := loadproc(DOM_INTERVAL::_compute_gamma_coeffs, path, "gamma"):
DOM_INTERVAL::gamma := loadproc(DOM_INTERVAL::gamma, path, "gamma"):
DOM_INTERVAL::ln_gamma := loadproc(DOM_INTERVAL::ln_gamma, path, "gamma"):
unalias(path):

DOM_INTERVAL::Content :=
proc(Out, x)
  local hlp;
begin
  if op(x, 0) = hold(_union) then
    // proceed recursively on unions
    Out::Cunion(map(op(x), Out));
  elif op(x, 0) = FAIL then
    // the interval is in the complex plane
    Out(hold(_plus)(op(x, 1),
                    _mult_intern(op(x,2), I)));
  else
    hlp := (num, dir) -> Out(hold(``).rdfloat2text(num, DIGITS, dir));
    hlp(RD_NINF, -1) := Out(RD_NINF);
    hlp(RD_NINF,  1) := Out(RD_NINF);
    hlp(RD_INF,  -1) := Out(RD_INF);
    hlp(RD_INF,   1) := Out(RD_INF);
    
    // simple real interval
    Out::Cinterval([], hlp(lhs(x), -1), hlp(rhs(x), 1)):
  end_if;
end:

_range::hull := hull:
