//    

// kg, 29/12/93 

// groebner.mu -- the 'groebner' library for Gr"obner-bases 

/*++
User Functions:

spoly   - returns S-Polynomial of two polynomials
normalf - returns normal form of polynomial modulo an ideal
gbasis  - returns reduced normalized Gr"obner-basis

Implemented is Buchbergers improved algorithm with 'normal' selection
strategy. Coefficient growth is not taken care of.

Note that one may not only use the package for rational polynomials
but also for polynomials over IntMod(p) with prime number p or for
polynomials over a domain which represents a field. (If the coefficient
ring is a domain, it is not checked if the domain represents a
field.)
++*/

/*--
The algorithms of the package are from two sources:

K.O.Geddes et al: "Algorithms for Computer Algebra", Kluwer 1992
T.Becker, V.Weispfenning: "Gr"obner Bases", Springer 1993
--*/

groebner:= newDomain("groebner"):
groebner::create_dom:=hold(groebner):
groebner::info:= "Library 'groebner': calculation of Groebner-bases for polynomial ideals":
groebner::interface:= { hold(spoly), hold(normalf), hold(gbasis),
	hold(dimension), hold(eliminate), hold(stronglyIndependentSets) }:

alias(path = pathname("GROEBNER")):

groebner::spoly:= loadproc(groebner::spoly, path,"spoly"):
groebner::normalf:= loadproc(groebner::normalf, path,"normalf"):
groebner::gbasis:= loadproc(groebner::gbasis, path,"gbasis"):
groebner::eliminate:= loadproc(groebner::eliminate, path, "eliminate"):

groebner::s_poly:= loadproc(groebner::s_poly, path,"s_poly"):
groebner::reduce:= loadproc(groebner::reduce, path,"reduce"):
groebner::basis:= loadproc(groebner::basis, path,"basis"):
groebner::test_poly:= loadproc(groebner::test_poly, path,"testpoly"):
groebner::test_polyset:= loadproc(groebner::test_polyset, path,"testpset"):
groebner::test_domain:= loadproc(groebner::test_domain, path,"testdom"):
groebner::pair_less:= loadproc(groebner::pair_less, path,"pairless"):
groebner::term_less:= loadproc(groebner::term_less, path,"termless"):
groebner::reduce_basis:= loadproc(groebner::reduce_basis, path,"red_base"):
groebner::term_lcm:= loadproc(groebner::term_lcm, path,"term_lcm"):
groebner::opt_order:= loadproc(groebner::opt_order, path,"optorder"):
groebner::update:= loadproc(groebner::update, path,"update"):
groebner::redset_insert:= loadproc(groebner::redset_insert, path,"redset"):
groebner::normalize:= loadproc(groebner::normalize, path,"normal"):
groebner::primpart:= loadproc(groebner::primpart, path,"normal"):
groebner::factor:= loadproc(groebner::factor, path,"factor"):
groebner::triangular_set:= loadproc(groebner::triangular_set, path, "tri_set"):
groebner::dimension:= loadproc(groebner::dimension, path, "dimen"):

groebner::stronglyIndependentSets:=
loadproc(groebner::stronglyIndependentSets, path, "strIndep"):

groebner::getoptions:= loadproc(groebner::getoptions, path, "getopt"):

null():

// end of file 
