intlib:=newDomain("intlib"):
intlib::create_dom:=hold(intlib):
  intlib::info:="Library 'intlib': symbolic definite and indefinite integration":
  intlib::interface:={hold(byparts), 
                      hold(changevar),
                      hold(intOverSet),
                      hold(printWarnings)
                      }:

/* NOTE: There are some global (pattern-)variables in intlib defined for
        the lookup pattern matcher (see below) */  

alias(path = pathname("INTLIB")):

intlib::applyEulerIdentity:=
   loadproc(intlib::applyEulerIdentity,path,"simpCInt"):
intlib::changevar:= loadproc(intlib::changevar, path, "changevr"):
intlib::tryChangeVar:= loadproc(intlib::tryChangeVar, path, "changevr"):
intlib::byparts:= loadproc(intlib::byparts,path,"byparts"):
intlib::complexLnConversion:=
    loadproc(intlib::complexLnConversion,path,"simpCInt"):
intlib::expandExp:= loadproc(intlib::expandExp,path,"int"):
intlib::expandSum:= loadproc(intlib::expandSum,path,"simpCInt"):
intlib::getOptions:= loadproc(intlib::getOptions,path,"getOptions"):
intlib::hasLnExp:= loadproc(intlib::hasLnExp,path,"simpCInt"):
intlib::hasNegativeSquareRoots:= loadproc(intlib::hasNegativeSquareRoots,
                                         path,"simpCInt"):
intlib::int:= loadproc(intlib::int,path,"int"):
intlib::int_intern:= loadproc(intlib::int_intern,path,"int"):
intlib::intOverSet:= loadproc(intlib::intOverSet, path, "OverSet"):
intlib::lnToArctan:= loadproc(intlib::lnToArctan,path,"simpCInt"):
intlib::frozenInt:= loadproc(intlib::frozenInt,path,"lookup"):
intlib::lookup:= loadproc(intlib::lookup,path,"lookup"):
intlib::lookup_user:= loadproc(intlib::lookup_user,path,"lookup"):
intlib::printOptions:= loadproc(intlib::printOptions,path,"getOptions"):
intlib::removeNegativeSquareRoots:= loadproc(intlib::removeNegativeSquareRoots,
                                         path,"simpCInt"):
intlib::Simplify:= loadproc(intlib::Simplify,path,"simplify"):
intlib::simplifyComplexIntegral:=
    loadproc(intlib::simplifyComplexIntegral,path,"simpCInt"):

autoload(intlib::symbolicDiffs):
autoload(intlib::findSubst):

autoload(intlib::trafoLookup):
intlib::ratOfSqrt := loadproc(intlib::ratOfSqrt, path, "trafoLookup"):

autoload(intlib::ratSinCos):

autoload(intlib::patterns):

intlib::userpatterns := []:
intlib::userpatternsFSA := FAIL:

autoload(intlib::discont):

intlib::isConstTimesDiff := loadproc(intlib::isConstTimesDiff, path, "lookupUtils"):
intlib::getConstOfConstTimesDiff :=
  loadproc(intlib::getConstOfConstTimesDiff, path, "lookupUtils"):
// intlib::triprod := loadproc(intlib::triprod, path, "lookupUtils"):

// elliptic integrals
unalias(path):
alias(path = pathname("INTLIB", "ELLIPTIC")):
intlib::elliptic:=loadproc(intlib::elliptic,path,"elliptic"):
intlib::circular:=loadproc(intlib::circular,path,"circular"):
intlib::hyperbolic:=loadproc(intlib::hyperbolic,path,"hyperbolic"):

// integration of special functions 

unalias(path):
alias(path = pathname("INTLIB", "SPECFUNC")):

intlib::absInt:=loadproc(intlib::absInt,path,"specfunc"):
intlib::bigOhInt:=loadproc(intlib::bigOhInt,path,"specfunc"):
intlib::contDiffAt:= loadproc(intlib::contDiffAt,path,"diracInt"):
// intlib::diff2D:= loadproc(intlib::diff2D,path,"diracInt"):
intlib::diracInt:= loadproc(intlib::diracInt,path,"diracInt"):
intlib::diracDef:= loadproc(intlib::diracDef,path,"diracInt"):
intlib::heavisideInt:= loadproc(intlib::heavisideInt,path,"heaviInt"):
intlib::isContinuousAt:= loadproc(intlib::isContinuousAt,path,"diracInt"):
intlib::linArgSolve:= loadproc(intlib::linArgSolve,path,"diracInt"):
intlib::specialFunctionDef:=
  loadproc(intlib::specialFunctionDef,path,"specfunc"):
intlib::specialFunctionInt:=
  loadproc(intlib::specialFunctionInt,path,"specfunc"):

// algorithmic integration using differential algebra
autoloadLibrary(intlib::algebraic):

// definite integration 

unalias(path):
alias(path = pathname("INTLIB", "DEFINITE")):

intlib::definite:=loadproc(intlib::definite, path, "newdefinite"):
intlib::antiderivative:= loadproc(intlib::antiderivative,path,"definite"):
intlib::defInt:= loadproc(intlib::defInt,path,"definite"):
intlib::defInt_ceil_floor := loadproc(intlib::defInt_ceil_floor,
				      path, "ceil"):
intlib::defInt_abs := loadproc(intlib::defInt_abs,
			       path, "abs"):
intlib::defInt_intern:= loadproc(intlib::defInt_intern,path,"definite"):
intlib::intdef1:= loadproc(intlib::intdef1,path,"intdef"):
intlib::int_eval:= loadproc(intlib::int_eval,path,"definite"):
intlib::limit:= loadproc(intlib::limit,path,"definite"):
intlib::match:= loadproc(intlib::match,path,"match"):
intlib::matchassign:= loadproc(intlib::matchassign,path,"match"):
intlib::poleLRTest:= loadproc(intlib::poleLRTest,path,"definite"):
intlib::xrngTest:= loadproc(intlib::xrngTest,path,"definite"):
intlib::residueInt:= loadproc(intlib::residueInt,path,"residueInt"):


intlib::printWarningsFlag:= FALSE:
intlib::printWarnings:= proc(flag)
    local tmp;
begin
    if args(0) = 0 then 
        return( intlib::printWarningsFlag )
    else
        case flag
        of TRUE do
        of FALSE do
            tmp:= intlib::printWarningsFlag;
            sysassign( intlib::printWarningsFlag, flag );
            return( tmp )
        otherwise
            error("invalid argument")
        end_case
    end_if
end_proc:



// parameters for tuning some integration routines
unalias(path):
alias(path = pathname("INTLIB")):
intlib::simplifyMaxSteps   := loadproc(intlib::simplifyMaxSteps, path, "maxsteps"):
intlib::discontMaxSteps    := loadproc(intlib::discontMaxSteps, path, "maxsteps"):
intlib::limitMaxSteps      := loadproc(intlib::limitMaxSteps, path, "maxsteps"):
intlib::isDiffOfMaxSteps   := loadproc(intlib::isDiffOfMaxSteps, path, "maxsteps"):
intlib::subresMaxSteps     := loadproc(intlib::subresMaxSteps, path, "maxsteps"):

intlib::memGrowthFactor:=200: // limit factor for allowed complexity expansion

prog::setcheckglobals(intlib,
 {
  ellipticK,
  ellipticE,
  ellipticPi,
  _X,
  _X_,
  _Z,
  intlibDepthLevel,
  calledFromWithinDefInt,
  calledFromWithinDSolve
 }):

prog::setCheckedProtectedAssignments(intlib,
{
 calledFromWithinDefInt,
 intlibDepthLevel
}):

null():


