//    
// sello, 12.6.97 

/*++
	linopt.mu -- a domain for linear optimization problems
++*/

alias(path = pathname("LINOPT")):

linopt := newDomain("linopt"):
linopt::create_dom:=hold(linopt):
linopt::info := "Library 'linopt': a package for linear optimization":
linopt::interface := {
   hold(corners), hold(maximize), hold(minimize), hold(plot_data),
   hold(Transparent)
}:

linopt::maximize        := loadproc(linopt::maximize,           path, "maximize"):
linopt::minimize        := loadproc(linopt::minimize,           path, "minimize"):
linopt::intopt          := loadproc(linopt::intopt,             path, "intopt"):
linopt::plot_data       := loadproc(linopt::plot_data,          path, "plotdata"):
linopt::arrange_corners := loadproc(linopt::arrange_corners,    path, "arrange"):
linopt::corners         := loadproc(linopt::corners,            path, "corners"):
linopt::plot_line       := loadproc(linopt::plot_line,          path, "plotline"):
linopt::obj_penalty     := loadproc(linopt::obj_penalty,        path, "objpen"):
linopt::eukl_penalty    := loadproc(linopt::eukl_penalty,       path, "euklpen"):
linopt::branch          := loadproc(linopt::branch,             path, "branch"):
linopt::feasible        := loadproc(linopt::feasible,           path, "feasible"):
linopt::standardForm    := loadproc(linopt::standardForm,       path, "standard"):


linopt::objconst:= genident("linopt::objconst"): // only used as an identifier 
linopt::scr:= genident("linopt::scr"): // only used as an identifier 
linopt::slk:= genident("linopt::slk"): // only used as an identifier 

linopt::Heap:= loadproc(linopt::Heap, path, "heap"):


unalias(path):
alias(path = pathname("LINOPT","TABLEAU")):
alias(Tableau = linopt::Tableau):

Tableau := newDomain("linopt::Tableau"):
Tableau::info := "Library 'linopt::Tableau': datastructures of linear optimization problems":

Tableau::new            := loadproc(Tableau::new,               path, "newtab"):
Tableau::pivot1         := loadproc(Tableau::pivot1,            path, "pivot1"):
Tableau::pivot1_deg     := loadproc(Tableau::pivot1_deg,        path, "piv1deg"):
Tableau::pivot2         := loadproc(Tableau::pivot2,            path, "pivot2"):
Tableau::pivot2_deg     := loadproc(Tableau::pivot2_deg,        path, "piv2deg"):
Tableau::dualpivot      := loadproc(Tableau::dualpivot,         path, "dualpiv"):
Tableau::dualpivot_deg  := loadproc(Tableau::dualpivot_deg,     path, "dupivdeg"):
Tableau::optstep                := loadproc(Tableau::optstep,           path, "step"):
Tableau::reopt          := loadproc(Tableau::reopt,             path, "reopt"):
Tableau::reopt_bound    := loadproc(Tableau::reopt_bound,       path, "reoptbnd"):
Tableau::simplex        := loadproc(Tableau::simplex,           path, "simplex"):
Tableau::dual_prices    := loadproc(Tableau::dual_prices,       path, "dualpric"):
Tableau::result         := loadproc(Tableau::result,            path, "result"):
Tableau::print          := loadproc(Tableau::print,             path, "print"):
Tableau::empty          := loadproc(Tableau::empty,             path, "empty"):
Tableau::delcolumn      := loadproc(Tableau::delcolumn,         path, "delcol"):
Tableau::newupperbound  := loadproc(Tableau::newupperbound,     path, "newupper"):
Tableau::newlowerbound  := loadproc(Tableau::newlowerbound,     path, "newlower"):
Tableau::probe          := loadproc(Tableau::probe,             path, "probe"):
Tableau::feasible       := loadproc(Tableau::feasible,          path, "feasible"):
Tableau::_index         := loadproc(Tableau::_index,            path, "newtab"):
Tableau::indexval      := loadproc(Tableau::indexval,         path, "newtab"):
Tableau::decvec         := loadproc(Tableau::decvec,            path, "decvec"):
Tableau::elimobj        := loadproc(Tableau::elimobj,           path, "elimobj"):
Tableau::intfeasible    := loadproc(Tableau::intfeasible,       path, "intfea"):
Tableau::newequation    := loadproc(Tableau::newequation,       path, "newequ"):
Tableau::uinfo          := loadproc(Tableau::uinfo,             path, "uinfo"):

unalias(Tableau):

unalias(path):
alias(path = pathname("LINOPT","TRANSP")):
alias(Transparent = linopt::Transparent):

// Bullshit, who inserted this line ?
//Transparent:= loadproc(Transparent, path, "transp"):

// Dirty trick since substituion in domain does not work any more.
// the directory sturcture has to be reorganized.
prog::init(linopt::Tableau):
Transparent:= newDomain("linopt::Transparent",linopt::Tableau):
prog::init(Transparent):
Transparent:= subs(Transparent, hold(Tableau) = hold(Transparent)):

Transparent::interface:= {
   hold(autostep), hold(clean_basis), hold(convert), 
   hold(dual_prices), hold(phaseI_tableau),
   hold(phaseII_tableau), hold(result), hold(simplex),
   hold(suggest), hold(userstep)
}:
Transparent::new                := loadproc(Transparent::new,                   path, "newtrans"):
Transparent::pivot2             := loadproc(Transparent::pivot2,                path, "piv2"):
Transparent::simplex            := loadproc(Transparent::simplex,               path, "simplex"):
Transparent::print              := loadproc(Transparent::print,                 path, "print"):
Transparent::Content            := loadproc(Transparent::Content,                 path, "print"):
Transparent::phaseI_tableau     := loadproc(Transparent::phaseI_tableau,        path, "phaseI"):
Transparent::phaseII_tableau    := loadproc(Transparent::phaseII_tableau,       path, "phaseII"):
Transparent::autostep           := loadproc(Transparent::autostep,              path, "autostep"):
Transparent::suggest            := loadproc(Transparent::suggest,               path, "suggest"):
Transparent::userstep           := loadproc(Transparent::userstep,              path, "userstep"):
Transparent::clean_basis        := loadproc(Transparent::clean_basis,           path, "cleanbas"):
Transparent::convert            := loadproc(Transparent::convert,               path, "convert"):
Transparent::drive_out          := loadproc(Transparent::drive_out,             path, "driveout"):
Transparent::uinfo              := loadproc(Transparent::uinfo,                 path, "uinfo"):

unalias(Transparent):
unalias(path):

null():

// end of file 
