//    

// andi, 30/06/97 

// module.mu -- the 'module' library for module management 

/*++
User Functions:

load     - load modules (refer to 'loadmod')
displace - unload modules (refer to 'unloadmod')
func     - create DOM_FUNC_ENV of a mod.-func. (refer to 'external')

age      - get/set maximum age for loaded modules (module-aging)
max      - get/set maximum number of simultaneously loaded modules
stat     - prints out the state of module management
which    - get fullname (path) of a module

clean    - remove recursions in module domains
++*/

module:= newDomain("module"):
module::create_dom:=hold(module):

module::info:= "Library 'module': utilities for module management":
module::interface:= {	hold(func), hold(load), hold(displace), 
			hold(age),  hold(help), hold(max), 
			hold(stat), hold(which)
}:

alias(path = pathname("MODULE")):

module::load:=     loadproc(module::load, path,"load"):
module::displace:= loadproc(module::displace, path,"displace"):
module::unload:=   loadproc(module::unload, path,"unload"):
module::func:=     loadproc(module::func, path,"func"):

module::age:=    loadproc(module::age, path,"age"):
module::help:=   loadproc(module::help, path,"help"):
module::max:=    loadproc(module::max, path,"max"):
module::stat:=   loadproc(module::stat, path,"stat"):
module::which:=  loadproc(module::which, path,"which"):

module::clean:=  loadproc(module::clean, path,"clean"):

module::expr2text:= loadproc(module::expr2text, path,"expr2txt"):

module::new:= proc()
//save READPATH;  // undokumentiertes feature abgeschaltet, andi
local _n_,_a_,_o_;
begin
    if( (_n_:=args(0)) = 0 ) then 
        error( "Wrong number of arguments" );
    end_if;
    _a_:= args();
    _o_:= args(1);
    
    // undokumentiertes feature abgeschaltet, andi
    //if( type(_o_) = "_equal" ) then
    //    if( op(_o_,1) <> hold(Path) ) then
    //        error( "Unknown option ".expr2text(op(_o_,1)) );
    //    end_if;
    //    if( domtype(op(_o_,2)) <> DOM_STRING ) then
    //        error( "String expected for option ".expr2text(op(_o_,1)) );
    //    else
    //        if( not _pref(SecureKernel) ) then
    //            if( domtype(READPATH) = DOM_LIST ) then
    //                READPATH:= _o_, READPATH;
    //            else
    //                READPATH:= op(_o_,2);
    //            end_if;
    //        end_if;
    //    end_if;
    //    _a_:=subsop(_a_,1=null());
    //    _n_:=_n_-1;
    //end_if;

    if  ( _n_ = 2 ) then
       	module::func( _a_ );
    elif( _n_ = 1 ) then
       	module::load( _a_ );
    else
       	error( "Wrong number of arguments" );
    end_if;
end_proc:

if domtype(loadmod) <> DOM_FUNC_ENV then
   // Modules not available, meaning that the
   // kernel does not support the functions
   // loadmod, unloadmod and external.
   // Define dummy procedures. O.K.
   loadmod := proc() begin 
      error("Modules not supported.")
   end_proc:
   unloadmod := proc() begin 
      error("Modules not supported.")
   end_proc:
   external := proc() begin 
      error("Modules not supported.")
   end_proc:
end_if:
   
null():

// end of file 
