  ode:=newDomain("ode"):
  ode::create_dom:=hold(ode):
  ode::info:="Library 'ode': ordinary differential equations":
  ode::interface:={
        hold(companionSystem), hold(cyclicVector),
        hold(dAlembert), hold(evalOde), hold(exponentialSolutions),
        hold(exponents), hold(getOrder), hold(indicialEquation),
        hold(isFuchsian), hold(isLODE), hold(mkODE), hold(normalize),
        hold(polynomialSolutions), hold(rationalSolutions),
        hold(ratSys), hold(scalarEquation),
        hold(symmetricPower),hold(series), hold(unimodular),
        hold(vectorize), hold(wronskian)
                   
/*        hold(adjoint), hold(abel),  hold(autonomous), hold(bernoulli),
        hold(chini), hold(clairaut), hold(euler), hold(exact_first_order),
        hold(exact_second_order), 
        hold(homogeneous), hold(homogeneousG),  hold(homogeneousC),
        hold(homogeneousD), hold(int_factors), hold(int_factors2),
        hold(isCyclicVector), hold(lagrange), hold(laplace), 
        hold(liouvillianSolutions), hold(riccati),
        hold(simplifySolutions), hold(separate), hold(specfunc),
        hold(solve), hold(wronskianMatrix)  */
  }:

alias(path = pathname ("ODE")):

ode::new:= loadproc(ode::new, path, "new"):
ode::evaluate:= loadproc(ode::evaluate, path, "new"):
ode::getComponents:= loadproc(ode::getComponents, path, "new"):
ode::print:= loadproc(ode::print, path, "new"):
ode::subs:= loadproc(ode::subs, path, "new"):

  //ode::print:=proc(o) begin hold(ode)(extop(o)) end_proc;
  ode::maxDepth:=2: // maximal nesting of methods 
  ode::depth:=0: // current depth 
  ode::maxdegree:=1: /* maximal degree for which solve try to find radicals
                       or numbers of solutions are allowed */
  ode::isReducibleFlag:= FALSE: // necessary for printing correct warnings 
  ode::possiblyLostSolutionsFlag:=FALSE:

ode::isResultOfSolveOK:= loadproc(ode::isResultOfSolveOK,path,"solve"):

// methods for solving ordinary differential equations and systems 

ode::abel:= loadproc(ode::abel,path,"abel"):
//ode::autonomous:= loadproc(ode::autonomous,path,"autonom"):
ode::autonomousEq:= loadproc(ode::autonomousEq,path,"autonom"):
ode::bernoulli:= loadproc(ode::bernoulli,path,"bernoull"):
ode::bernoulliEq:= loadproc(ode::bernoulliEq,path,"bernoull"):
ode::chini:= loadproc(ode::chini,path,"chini"):
ode::clairaut:= loadproc(ode::clairaut,path,"clairaut"):
ode::clairautEq:= loadproc(ode::clairautEq,path,"clairaut"):
ode::contact:= loadproc(ode::contact,path,"contact"):
ode::combination:= loadproc(ode::combination,path,"combinat"):
ode::dAlembert:= loadproc(ode::dAlembert,path,"dAlember"):
ode::differentiation:= loadproc(ode::differentiation,path,"diff"):
ode::equidimensional_in_x:= 
                loadproc(ode::equidimensional_in_x,path,"equidimx"):
ode::equidimensional_in_y:= 
                loadproc(ode::equidimensional_in_y,path,"equidimy"):
ode::euler:= loadproc(ode::euler,path,"equidimx"):
ode::factor:= loadproc(ode::factor,path,"factor"):
ode::firstord:= loadproc(ode::firstord,path,"firstord"):
ode::generalReduction:= loadproc(ode::generalReduction,path,"dAlember"):
ode::homogeneous:= loadproc(ode::homogeneous,path,"homogen"):
ode::homogeneousG:= loadproc(ode::homogeneousG,path,"homogenG"):
ode::homogeneousC:= loadproc(ode::homogeneousC,path,"homogenC"):
ode::homogeneousD:= loadproc(ode::homogeneousD,path,"homogenD"):
ode::interchange:= loadproc(ode::interchange,path,"interch"):
ode::lagrange:= loadproc(ode::lagrange,path,"lagrange"):
ode::laplace:= loadproc(ode::laplace,path,"laplace"):
ode::laplaceScalar:= loadproc(ode::laplaceScalar,path,"laplace"):
ode::laplaceSystem:= loadproc(ode::laplaceSystem,path,"laplace"):
ode::linsys:= loadproc(ode::linsys,path,"linsys"):
ode::matrixRiccati:= loadproc(ode::matrixRiccati,path,"mriccati"):
ode::reduction:= loadproc(ode::reduction,path,"dAlember"):
ode::riccati:= loadproc(ode::riccati,path,"riccati"):
ode::scale_invariant:=loadproc(ode::scale_invariant,path,"scaleinv"):
ode::secondOrderReduction:= 
               loadproc(ode::secondOrderReduction,path,"dAlember"):
ode::separate:= loadproc(ode::separate,path,"separate"):
ode::solvable_for_x:= loadproc(ode::solvable_for_x,path,"solvablx"):
ode::solvable_for_y:= loadproc(ode::solvable_for_y,path,"solvably"):
ode::solve:= loadproc(ode::solve,path,"solve"):
ode::solve_intern:= loadproc(ode::solve_intern,path,"solve"):
ode::solve_eq:= loadproc(ode::solve_eq,path,"solve_eq"):
ode::solve_linear:= loadproc(ode::solve_linear,path,"solvelin"):
ode::constant:= loadproc(ode::constant,path,"solvelin"):
ode::solve_sys:= loadproc(ode::solve_sys,path,"solvesys"):
ode::solvesysinit:= loadproc(ode::solvesysinit,path,"solvesys"):
ode::ymissing:= loadproc(ode::ymissing,path,"ymissing"):


// algebraic methods to determine liouvillian solutions 

unalias(path):
alias(path = pathname("ODE","LIOUVILL")):

ode::combineSolutionsOfFactors:= 
                     loadproc(ode::combineSolutionsOfFactors,path,"ifReduc"):
ode::expsols:= loadproc(ode::expsols,path,"ExpSol"):
ode::exponentialSolutions:= loadproc(ode::exponentialSolutions,path,"ExpSol"):
ode::firstOrder:=    loadproc(ode::firstOrder,path,"ifReduc"):
ode::fracFreeSymPowerOrd2:=
                     loadproc(ode::fracFreeSymPowerOrd2,path,"sympower"):
ode::ifReducible:=   loadproc(ode::ifReducible,path,"ifReduc"):
ode::liouvillianSolutions:= 
                     loadproc(ode::liouvillianSolutions,path,"LiouvSol"):
ode::mkUnimodular:=loadproc(ode::mkUnimodular,path,"mkUnimod"):
ode::newtonPolygon:=loadproc(ode::newtonPolygon,path,"ExpSol"):
ode::polysols:= loadproc(ode::polysols,path,"PolySol"):
ode::polynomialSolutions:= loadproc(ode::polynomialSolutions,path,"PolySol"):
ode::ratInvars:= loadproc(ode::ratInvars,path,"RatSol"):
ode::rationalInvariants:= loadproc(ode::rationalInvariants,path,"RatSol"):
ode::rationalSolutions:= loadproc(ode::rationalSolutions,path,"RatSol"):
ode::ratSys:= loadproc(ode::ratSys,path,"RatSol"):
ode::ratsols:= loadproc(ode::ratsols,path,"RatSol"):
ode::reducibleCase:= loadproc(ode::reducibleCase,path,"ifReduc"):
ode::secondOrder:=   loadproc(ode::secondOrder,path,"2ndOrder"):
//ode::solveIfReducible:= loadproc(ode::solveIfReducible,path,"ifReduc"):
ode::symPower:= loadproc(ode::symPower,path,"sympower"):
ode::symPowerOrd2:= loadproc(ode::symPowerOrd2,path,"sympower"):
ode::symmetricPower:= loadproc(ode::symmetricPower,path,"sympower"):
ode::thirdOrder:=    loadproc(ode::thirdOrder,path,"3rdOrder"):
ode::unimodular:=loadproc(ode::unimodular,path,"mkUnimod"):

// methods for computing non-liouvillian solutions

unalias(path):
alias(path = pathname("ODE","NONLIOUVILL")):

ode::specfunc:=loadproc(ode::specfunc,path,"2ndorder"):

// integrating factor methods

unalias(path):
alias(path = pathname("ODE","INTFACTS")):
ode::integratingFactor:= loadproc(ode::integratingFactor,path,"integratingFactor"):
ode::integratingFactorsOrder1_1:= loadproc(ode::integratingFactorsOrder1_1,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_2:= loadproc(ode::integratingFactorsOrder1_2,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_3:= loadproc(ode::integratingFactorsOrder1_3,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_4:= loadproc(ode::integratingFactorsOrder1_4,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_5:= loadproc(ode::integratingFactorsOrder1_5,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_6:= loadproc(ode::integratingFactorsOrder1_6,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder1_7:= loadproc(ode::integratingFactorsOrder1_7,path,"integratingFactorsOrder1"):
ode::integratingFactorsOrder2_1:= loadproc(ode::integratingFactorsOrder2_1,path,"integratingFactorsOrder2"):
ode::exact_first_order:= loadproc(ode::exact_first_order,path,"exact1st"):
ode::exact_second_order:= loadproc(ode::exact_second_order,path,"exact2nd"):
ode::firint_second_order:= loadproc(ode::firint_second_order,path,"exact2nd"):
ode::exact_nth_order:= loadproc(ode::exact_nth_order,path,"exactnth"):
ode::exact_nth_order_nonlinear:= loadproc(ode::exact_nth_order_nonlinear,path,"exactnth"):
ode::separateByProduct:= loadproc(ode::separateByProduct,path,"utilities"):
ode::splitFactor:= loadproc(ode::splitFactor,path,"utilities"):
ode::eulerOperator:= loadproc(ode::eulerOperator,path,"utilities"):
ode::isQuasiLinear:= loadproc(ode::isQuasiLinear,path,"utilities"):
ode::quasiLinearForm:= loadproc(ode::quasiLinearForm,path,"utilities"):
//ode::simplifyExpOfLn:= loadproc(ode::simplifyExpOfLn,path,"utilities"):
ode::checkIntegration:= loadproc(ode::checkIntegration,path,"utilities"):


// methods for computing series solutions

unalias(path):
alias(path = pathname("ODE","SERIES")):

ode::repdiff:= loadproc(ode::repdiff,path,"repDiff"):
ode::series:= loadproc(ode::series,path,"series"):
ode::frobenius:= loadproc(ode::frobenius,path,"frobenius"):


// determining types of equations 

unalias(path):
alias(path = pathname("ODE","MATCH")):

ode::exponents:= loadproc(ode::exponents,path, "fuchsian"):
ode::indicialEquation:= loadproc(ode::indicialEquation,path, "fuchsian"):
ode::isFuchsian:= loadproc(ode::isFuchsian,path, "fuchsian"):
ode::isLODE:= loadproc(ode::isLODE,path,"isLODE"):
ode::lookUp2ndOrderLinear:= loadproc(ode::lookUp2ndOrderLinear,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_1_eq_4_and_6_p_214:= loadproc(ode::PZ_Sec_212_1_eq_4_and_6_p_214,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_1_eq_7_p_215:= loadproc(ode::PZ_Sec_212_1_eq_7_p_215,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_1_eq_9_p_215:= loadproc(ode::PZ_Sec_212_1_eq_9_p_215,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_1_eq_10_p_215:= loadproc(ode::PZ_Sec_212_1_eq_10_p_215,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_13_14_p_216:= loadproc(ode::PZ_Sec_212_2_eq_13_14_p_216,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_15_16_17_p_216:= loadproc(ode::PZ_Sec_212_2_eq_15_16_17_p_216,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_18_19_20_21_22_24_25_26_27_28_p_216_217:= loadproc(ode::PZ_Sec_212_2_eq_18_19_20_21_22_24_25_26_27_28_p_216_217,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_29_30_31_p_217:= loadproc(ode::PZ_Sec_212_2_eq_29_30_31_p_217,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_32_p_217:= loadproc(ode::PZ_Sec_212_2_eq_32_p_217,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_33_34_35_p_217:= loadproc(ode::PZ_Sec_212_2_eq_33_34_35_p_217,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_38_39_40_42_43_p_217_218:= loadproc(ode::PZ_Sec_212_2_eq_38_39_40_42_43_p_217_218,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_45_46_p_218:= loadproc(ode::PZ_Sec_212_2_eq_45_46_p_218,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_50_51_52_53_54_p_218:= loadproc(ode::PZ_Sec_212_2_eq_50_51_52_53_54_p_218,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_2_eq_55_56_57_58_59_60_p_218_219:= loadproc(ode::PZ_Sec_212_2_eq_55_56_57_58_59_60_p_218_219,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_3_eq_61_62_63_64_69_70_71_72_73_74_105_106_107_108_p_219_to_225:= loadproc(ode::PZ_Sec_212_3_eq_61_62_63_64_69_70_71_72_73_74_105_106_107_108_p_219_to_225,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_3_eq_65_66_67_68_p_220:= loadproc(ode::PZ_Sec_212_3_eq_65_66_67_68_p_220,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_4_eq_118_119_132_133_134_143_144_145_147_p_226_228_229_230:= loadproc(ode::PZ_Sec_212_4_eq_118_119_132_133_134_143_144_145_147_p_226_228_229_230,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_5_eq_149_p_230:= loadproc(ode::PZ_Sec_212_5_eq_149_p_230,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_5_eq_154_p_230:= loadproc(ode::PZ_Sec_212_5_eq_154_p_230,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_5_eq_hypergeom:= loadproc(ode::PZ_Sec_212_5_eq_hypergeom,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_5_eq_169_170_p_233_234:= loadproc(ode::PZ_Sec_212_5_eq_169_170_p_233_234,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_6_eq_186_190_194_p_237:= loadproc(ode::PZ_Sec_212_6_eq_186_190_194_p_237,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_6_eq_195_196_197_199_200_201_205_206_207_208_209_210_p_238:= loadproc(ode::PZ_Sec_212_6_eq_195_196_197_199_200_201_205_206_207_208_209_210_p_238,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_7_eq_215_217_218_219_228_229_230_231_233_234_p_240:= loadproc(ode::PZ_Sec_212_7_eq_215_217_218_219_228_229_230_231_233_234_p_240,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_8_eq_242_243_245_247_248_249_250_251_252_254_to_265_p_244:= loadproc(ode::PZ_Sec_212_8_eq_242_243_245_247_248_249_250_251_252_254_to_265_p_244,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_212_1_to_8_eq_47_183_202_p_218:= loadproc(ode::PZ_Sec_212_1_to_8_eq_47_183_202_p_218,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_219_1_eq_1_to_52_p_285_to_289:= loadproc(ode::PZ_Sec_219_1_eq_1_to_52_p_285_to_289,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_219_2_eq_53_to_91_p_289_to_292:= loadproc(ode::PZ_Sec_219_2_eq_53_to_91_p_289_to_292,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_213_1_eq_1_to_79_p_246_to_252:= loadproc(ode::PZ_Sec_213_1_eq_1_to_79_p_246_to_252,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_215_1_eq_1_to_40_p_257_to_259:= loadproc(ode::PZ_Sec_215_1_eq_1_to_40_p_257_to_259,path,"lookUp2ndOrderLinear"):
ode::PZ_Sec_215_1_eq_1_to_132_p_260_to_271:= loadproc(ode::PZ_Sec_215_1_eq_1_to_132_p_260_to_271,path,"lookUp2ndOrderLinear"):
ode::PZ_2nd_order_linear_look_up_heuristics_1:= loadproc(ode::PZ_2nd_order_linear_look_up_heuristics_1,path,"lookUp2ndOrderLinear"):
ode::lookUp2F1:= loadproc(ode::lookUp2F1,path,"lookUp2F1"):
ode::lookUpHypergeomOrder3:= loadproc(ode::lookUpHypergeomOrder3,path,"lookUpHypergeomOrder3"):
ode::lookUp1stOrderRiccati:= loadproc(ode::lookUp1stOrderRiccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec122_Riccati:= loadproc(ode::PZ_Sec122_Riccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec123_Riccati:= loadproc(ode::PZ_Sec123_Riccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec124_Riccati:= loadproc(ode::PZ_Sec124_Riccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec125_Riccati:= loadproc(ode::PZ_Sec125_Riccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec126_Riccati:= loadproc(ode::PZ_Sec126_Riccati,path,"lookUp1stOrderRiccati"):
ode::PZ_Sec128_Riccati:= loadproc(ode::PZ_Sec128_Riccati,path,"lookUp1stOrderRiccati"):
ode::RiccatiSolutionGenerator:= loadproc(ode::RiccatiSolutionGenerator,path,"lookUp1stOrderRiccati"):
ode::lookUp3rdOrderLinear:= loadproc(ode::lookUp3rdOrderLinear,path,"lookUp3rdOrderLinear"):
ode::solutionGenerator3rdOrderLinear:= loadproc(ode::solutionGenerator3rdOrderLinear,path,"lookUp3rdOrderLinear"):
ode::reduce3rdOrderLinear:= loadproc(ode::reduce3rdOrderLinear,path,"lookUp3rdOrderLinear"):
ode::PZ_Sec_319_1_p_550:= loadproc(ode::PZ_Sec_319_1_p_550,path,"lookUp3rdOrderLinear"):
ode::lookUp1stOrderNonLinearVariousODEs:= loadproc(ode::lookUp1stOrderNonLinearVariousODEs,path,"lookUp1stOrderNonLinearVariousODEs"):


// tools for handling differential equations 


unalias(path):
alias(path = pathname("ODE","TOOLS")):

ode::compSys:= loadproc(ode::compSys,path,"compSys"):
ode::companionSystem:= loadproc(ode::companionSystem,path,"compSys"):
ode::cyclicVector:= loadproc(ode::cyclicVector,path,"compSys"):
ode::diffvars:= loadproc(ode::diffvars,path,"diffvars"):
ode::distributePiecewise:= loadproc(ode::distributePiecewise, path, "distributePiecewise"):
ode::evalOde:= loadproc(ode::evalOde,path,"tools"): 
ode::getOrder:= loadproc(ode::getOrder,path,"tools"):
ode::odeIndets:= loadproc(ode::odeIndets,path,"indets"):
ode::indets2:= loadproc(ode::indets2,path,"indets"):
ode::derivationOfRootOf:= loadproc(ode::derivationOfRootOf,path,"tools"):

ode::isCyclicVector:= loadproc(ode::isCyclicVector,path,"compSys"):
//ode::lodeExpr:= loadproc(ode::lodeExpr,path,"tools"): 
//ode::lodoExpr:= loadproc(ode::lodoExpr,path,"tools"): 
ode::mapsol:= loadproc(ode::mapsol,path,"mapsol"):
ode::mkODE:= loadproc(ode::mkODE,path,"mkODE"):
ode::normalize:= loadproc(ode::normalize,path,"normal"):
ode::normal:= loadproc(ode::normal,path,"normal"):
ode::removeDenominator:= loadproc(ode::removeDenominator,path,"normal"):
ode::ode2poly:= loadproc(ode::ode2poly,path,"ode2poly"):
ode::order:= loadproc(ode::order,path,"order"):
ode::printMinPol:= loadproc(ode::printMinPol,path,"tools"):
ode::scalarEquation:= loadproc(ode::scalarEquation,path,"compSys"):
ode::selectSolutions:= loadproc(ode::selectSolutions, path, "selectSolutions"):
ode::simplifyIntegrationConstants:= loadproc(ode::simplifyIntegrationConstants,
                                             path, "simplifyIntegrationConstants"):
ode::simplifySolutions:= loadproc(ode::simplifySolutions,path,"SimpSol"):
//ode::split:= loadproc(ode::split,path,"split"):
ode::subsvars:= loadproc(ode::subsvars,path,"subsvars"):
ode::vectorize:= loadproc(ode::vectorize,path,"vectoriz"):
ode::vspace:= loadproc(ode::vspace,path,"vspace"):
ode::wronskianMatrix:= loadproc(ode::wronskianMatrix,path,"wronsk"):
ode::wronskian:= loadproc(ode::wronskian,path,"wronsk"):
ode::wronskianOf:= loadproc(ode::wronskianOf,path,"wronsk"):
ode::odeWarning:= loadproc(ode::odeWarning,path,"warning"):
ode::removeConstants:= loadproc(ode::removeConstants,path,"removeConstants"):
ode::insertInits:= loadproc(ode::insertInits,path,"insertInits"):
ode::solveWithoutProperties:= loadproc(ode::solveWithoutProperties,path,"solveWithoutProperties"):
ode::odeIszero:= loadproc(ode::odeIszero,path,"odeIszero"):
ode::hopelessCases:= loadproc(ode::hopelessCases,path,"hopelessCases"):

unalias(path):

ode::printWarningsFlag:= TRUE:

ode::simplifyTime:=300:

ode::noTrace:={hold(getComponents)}:
prog::setcheckglobals(ode,{calledFromWithinDSolve}):

null():
