/*--
output.mu -- define/load auxiliary functions for output
--*/

output:= newDomain("output"):
output::create_dom:=hold(output):

output::info:= "Library 'output': utilities for the output of data":
output::interface:= {
    hold(ordinal), hold(roman), 
    hold(tableForm), hold(tree), hold(fence),
    hold(subexpr), hold(asciiAbbreviate),   
    hold(mathText)
}:

alias(path = pathname("OUTPUT")):

autoload(output::roman):
autoload(output::ordinal):
autoload(output::tableForm):
autoload(output::tree):

autoload(output::fence):
output::fenceSymbols := loadproc(output::fenceSymbols, path, "fence"):

// typesetting and MathML stuff
autoload(output::CatUtils):
autoload(output::CatContent):
autoload(output::MMLContent):
autoload(output::MMLPresentation):
autoload(output::Indent):
autoload(output::Priority):

autoload(output::mathText):
autoload(output::subexpr):
autoload(output::asciiAbbreviate):

null():

// end of file 
