//   

//
// prog.mu -- define/load auxiliary functions
//

prog:= newDomain("prog"):
prog::create_dom:=hold(prog):

prog::info:= "Library 'prog': programming utilities":
prog::interface:=
   {
    //hold(findSlot),
    // hold(bless),
    hold(calltree),
    hold(calledFrom),
    hold(check),
    //hold(checkFile), // not yet documented
    //hold(checkDisableMessage),
    hold(error),
    hold(exprlist),
    hold(exprtree),
    //hold(exprtable), // not documented
    hold(find),
    hold(fullTrace),
    hold(getname),
    hold(getOptions),
    hold(init),
    hold(isGlobal),
    // nur noch interner Gebrauch
    //hold(makeBinLib),
    hold(memuse),
    hold(ntime),
    hold(profile),
    hold(remember),
    hold(sort),
    hold(tcov),
    hold(test),
    hold(testcall),
    hold(testerrors),
    hold(testfunc),
    hold(testinit),
    hold(testmethod),
    hold(testnum),
    hold(testexit),
    hold(trace),
    hold(traced),
    hold(untrace),
    hold(wait)
    }:

alias(path = pathname("PROG")):

// default output - screen
prog::OUT := 0:

// internal for prog::check
prog::globalIdents:= table():
prog::protectedIdents:= table():
prog::PATH:= []: //
prog::NMSG:= {}: // disabled messages
prog::Entries:= loadproc(prog::Entries , path, "checkini"):
prog::VNM:= loadproc(prog::VNM , path, "check"):
prog::type:= loadproc(prog::type, path, "check"):
prog::isGlobal:= loadproc(prog::isGlobal, path, "checkini"):

prog::calltree:= loadproc(prog::calltree, path, "calltree"):

prog::check:= loadproc(prog::check, path, "check"):
prog::indets:= loadproc(prog::indets, path, "check"):
prog::checkDisableMessage:= loadproc(prog::checkDisableMessage, path, "checkset"):
prog::setcheckglobals:= loadproc(prog::setcheckglobals, path, "checkset"):
prog::setCheckedProtectedAssignments:=
   loadproc(prog::setCheckedProtectedAssignments, path, "checkset"):


prog::error:= loadproc(prog::error, path, "error"):

prog::exprlist:= loadproc(prog::exprlist, path, "exprlist"):
prog::exprtree:= loadproc(prog::exprtree, path, "exprtree"):
prog::exprtable:= loadproc(prog::exprtable, path, "exprtable"):

// analyze MuPAD library
prog::analyze:= loadproc(prog::analyze, path, "analyze"):

prog::find:= loadproc(prog::find, path, "find"):
prog::findSlot:= loadproc(prog::findSlot, path, "findSlot"):

// the new kernel function
prog::getOptions := stdlib::getOptions:

// converts Pref::userOptions into a table
autoload(prog::scanUserOptions):

autoload(prog::checkFile):

autoload(prog::getname):
autoload(prog::calledFrom):

prog::init := loadproc(prog::init , path, "checkini"):

prog::makeBinLib:= loadproc(prog::makeBinLib, path, "makelib"):

autoload(prog::memuse):

// system independend time unit
autoload(prog::ntime):

// utility for the daily tests
autoload(prog::timererror):

//
autoload(prog::profile):

// complex remember mechanism
autoload(prog::remember):
prog::clearRememberFuncs:=
       loadproc(prog::clearRememberFuncs, path, "remember"):
prog::rememberFuncsOrig:=
       loadproc(prog::rememberFuncsOrig, path, "remember"):
prog::showRememberFuncs:=
       loadproc(prog::showRememberFuncs, path, "remember"):

//
autoload(prog::tcov):

autoload(prog::bless):

// test environment

// this default is identical to the user configuration
prog::TestDefaultConfiguration :=
  table(hold(Debug)           = FALSE,
        hold(TCov)            = FALSE,
        hold(Testargs)        = FALSE,
        hold(TypeCheck)       = Interactive,
        hold(WarnAboutErrors) = FALSE):
prog::TestConfiguration := prog::TestDefaultConfiguration:


autoload(prog::test):
prog::acceptedErrors :=
       loadproc(prog::acceptedErrors, path, "test"):
autoload(prog::testexit):
autoload(prog::testfunc):
autoload(prog::testinit):
autoload(prog::testmethod):
autoload(prog::testnum):
autoload(prog::lasterror):
autoload(prog::testerrors):
autoload(prog::testcall):
autoload(prog::setTestConfiguration):
prog::syserror := error:

autoload(prog::complexity):

// bisher undokumentiert
autoload(prog::genidentgenerator):
autoload(prog::nameofdomvar):

// trace functions
prog::trace     := loadproc(prog::trace,     path, "trace"):
prog::traced    := loadproc(prog::traced,    path, "trace"):
prog::untrace   := loadproc(prog::untrace,   path, "trace"):
prog::fullTrace := loadproc(prog::fullTrace, path, "trace"):

// manipulate functions to write test files
prog::makeTestFile:= loadproc(prog::makeTestFile, path, "makeTestFile"):

// wait for a while
prog::wait:= loadproc(prog::wait, path, "wait"):

// sort by a function, that returns numerical values
prog::sort := loadproc(prog::sort, path, "sort"):

prog::setcheckglobals(prog,
   { ` saved values for prog::remember-functions ` } );


null():
