//   

// property - Functionallity to compute Properties
//
// September 1997 - Juergen Billing

property:= newDomain("property"):
property::create_dom:=hold(property):
property::info:= "Library 'property': properties of identifiers":
property::Name:= "property":
property::type:= "property":
property::propertiesCRC := 0;

property::flignoreInconsistentAssumptions := FALSE;

property::interface:=
        {
         hold(depends),
         hold(hasprop)
         }:

PROPERTIES := table("checklist" = table(),
  "set_lookup" = table(),
  "cond_lookup" = table(),
  "idx" = 0);

// maximale Laenge eines eingegebenen Ausdrucks (is)
property::MAXLENGTH:= 777:

autoload( property::_cond2set ):
autoload( property::_getprop ):
autoload( property::gbasis ):
autoload( property::hasprop ):
autoload( property::_insertAssumption ):
autoload( property::_set2sysprop ):
autoload( property::removeAssumptions ):
autoload( property::_setgroup ):
autoload( property::_setAssumptions ):
autoload( property::showprops ):
autoload( property::_showprops ):
autoload( property::_typeresidue ):
autoload( property::freeIndets ):
autoload(property::splitRoots):

autoload( property::_convertSet ):
autoload( property::_getpropRec ):
autoload( property::subsIdent ):

// Domain
autoload( property::_is ):
autoload( property::_assume ):
autoload( property::_checkSanity ):


/* Hilfsfunktionen */
autoload( property::isConstReal ):
autoload( property::constRel ):
autoload( property::isConstInteger ):
autoload( property::normalGroebner ):

/* Hilfsfunktionen fr is() */
autoload( property::_rewrite_cond ):
autoload( property::_rewrite_cond_equality ):
autoload( property::_rewrite_cond_inequality ):

autoload( property::_rectform ):
autoload( property::_rectformSymbolic ):
autoload( property::_decide ):
autoload( property::_typereal ):
autoload( property::_typeinteger ):
autoload( property::_typerational ):
autoload( property::reduceZPolyModPrime ):
autoload( property::checkPolyInteger ):
autoload( property::simplifyZPolyResidueProp ):
autoload( property::_typeeven ):
autoload( property::_typeodd ):
autoload(property::complexity):
autoload(property::prop2set):

autoload( property::_getPropertyList ):
property::traced    := loadproc(property::traced,  pathname("PROPERTY"), "trace"):
property::tracing   := loadproc(property::tracing, pathname("PROPERTY"), "trace"):
property::trace     := loadproc(property::trace,   pathname("PROPERTY"), "trace"):
property::untrace   := loadproc(property::untrace, pathname("PROPERTY"), "trace"):

// alle properties gultig?
property::depends:=
  proc(EXPR = 0)
    option noDebug;
  begin
    table(
      map(
        _union(
          op(map(
            select(
              map( indets([args()]), properties ),
              _unequal, FAIL ),
            op, 5 ))
        ),
        X->X=op(properties(X),3)  )
     );
  end_proc:

prog::setcheckglobals(property, {PROPERTIES}):
prog::setCheckedProtectedAssignments( property, {PROPERTIES} ):

null():
