//    

// solvelib.mu--library for solving equations 

/*++

User functions:


solve - solve an equation or a system of equations

++*/

solvelib:=newDomain("solvelib"):
solvelib::create_dom:=hold(solvelib):
solvelib::info:="Library 'solvelib': methods for solving equations, systems of equations, and inequalities":

solvelib::interface:={
                      BasicSet,
                      cartesianPower,
                      cartesianProduct,
                      conditionalSort,
                      getElement,
                      isFinite,
                      pdioe,
                      preImage,
                      splitVectorSet,
                      Union,
                      VectorImageSet
                      }:

alias(path = pathname("SOLVELIB")):

/* solve: in stdlib */


// methods belonging to the equation solver
solvelib::solve_eq       := loadproc(solvelib::solve_eq,       path,"equation"):
solvelib::solve_isalgebraic:= loadproc(solvelib::solve_isalgebraic,path,"isalgeb"):
solvelib::solve_islinear := loadproc(solvelib::solve_islinear, path,"islin"):
solvelib::isolate        := loadproc(solvelib::isolate,        path,"isolate"):
solvelib::solve_poly_irred:= loadproc(solvelib::solve_poly_irred,path,"pirred"):
solvelib::solve_poly     := loadproc(solvelib::solve_poly,     path,"poly"):
solvelib::solve_poly3    := loadproc(solvelib::solve_poly3,    path,"poly3"):
solvelib::realRootCubic  := loadproc(solvelib::realRootCubic, path, "poly3"):
solvelib::solve_poly4    := loadproc(solvelib::solve_poly4,    path,"poly4"):
solvelib::purePolynomial := loadproc(solvelib::purePolynomial, path,"purePoly"):
solvelib::solve_sys      := loadproc(solvelib::solve_sys,      path,"system"):
solvelib::solveIn        := loadproc(solvelib::solveIn,        path,"solveIn"):
solvelib::twoTerms       := loadproc(solvelib::twoTerms,       path, "twoTerms"):

// methods belonging to the inequality solver
solvelib::ineqs          := loadproc(solvelib::ineqs,          path,"ineqs"):
solvelib::ineqsys        := loadproc(solvelib::ineqsys,        path, "ineqs"):
solvelib::conditionalSort:= loadproc(solvelib::conditionalSort,path, "condsort"):
solvelib::ineqsReal      := loadproc(solvelib::ineqsReal,      path,"ineqsReal"):
solvelib::preImageIntervalReal:=
loadproc(solvelib::preImageIntervalReal, path, "preImageIntervalReal"):
solvelib::preImageInterval:= 
loadproc(solvelib::preImageInterval, path, "preImageInterval"):

// other methods

solvelib::makeSystem     := loadproc(solvelib::makeSystem,     path, "makeSys"):
                            :
solvelib::domsolve	 := loadproc(solvelib::domsolve,       path,"domsolve"):

solvelib::discreteSolve	 := loadproc(solvelib::discreteSolve, path,"disSolve"):

solvelib::checkSolutions:= loadproc(solvelib::checkSolutions, path, "checkSolutions"):
solvelib::checkVectorSolutions:= loadproc(solvelib::checkVectorSolutions, path, "checkVectorSolutions"):

solvelib::iroots	 := loadproc(solvelib::iroots,         path,"iroots"):	

solvelib::solve_algebraic:= loadproc(solvelib::solve_algebraic,path,"algebraic"):
solvelib::vectorForm     := loadproc(solvelib::vectorForm, path,    "vecForm"):

solvelib::convertToAssignments:= loadproc(solvelib::convertToAssignments, path, "convertToAssignments"):

solvelib::allvalues      := loadproc(solvelib::allvalues,      path,"allvals"):
solvelib::pdioe          := loadproc(solvelib::pdioe,          path,"pdioe"):
solvelib::diophantine    := loadproc(solvelib::diophantine,    path,"diophant"):
solvelib::solveSzalay    := loadproc(solvelib::solveSzalay,    path, "solveSzalay"):


solvelib::matchplus      := loadproc(solvelib::matchplus,      path, "matchplus"):
solvelib::matchmult      := loadproc(solvelib::matchmult,      path, "matchmult"):


solvelib::indets         := loadproc(solvelib::indets,         path, "indets"):

solvelib::getOptions     := loadproc(solvelib::getOptions,     path,"getopt"):
solvelib::nonDefaultOptions 
			 := loadproc(solvelib::nonDefaultOptions,
							       path,"getopt"):
solvelib::setOptions     := loadproc(solvelib::setOptions,     path, "getopt"):
solvelib::restoreDefaultOptions:= loadproc(solvelib::restoreDefaultOptions, path, "getopt"):

solvelib::substituteBySet:= loadproc(solvelib::substituteBySet,path,"subsBySe"):
solvelib::preImage       := loadproc(solvelib::preImage,       path,"preImage"):
solvelib::preImageReal   := loadproc(solvelib::preImageReal,   path,"preImage"):solvelib::handlePreImageR:= loadproc(solvelib::handlePreImageR, path, "handlePreImageR"):
solvelib::Union          := loadproc(solvelib::Union,          path,"Union"): 
solvelib::BasicSet       := loadproc(solvelib::BasicSet,       path,"BasicSet"):
solvelib::isEmpty        := loadproc(solvelib::isEmpty,        path,"isEmpty"):
solvelib::solve_intersect:= loadproc(solvelib::solve_intersect,path,"intersect"):
solvelib::solve_union    := loadproc(solvelib::solve_union, path, "solve_union"):

solvelib::cartesianPower:=  loadproc(solvelib::cartesianPower, path,
                                     "cartesianPower"):
solvelib::cartesianProduct:= loadproc(solvelib::cartesianProduct, path,
                                      "cartesianProduct"):

solvelib::splitVectorSet := loadproc(solvelib::splitVectorSet, path,
                                     "splitVectorSet"):
solvelib::VectorImageSet:= loadproc(solvelib::VectorImageSet, path,
                                    "VectorImageSet"):

solvelib::numberSetToVectorSet:= loadproc(solvelib::numberSetToVectorSet, path,
                                          "numberSetToVectorSet"):
solvelib::vectorSetToNumberSet:= loadproc(solvelib::vectorSetToNumberSet, path,
                                          "vectorSetToNumberSet"):

solvelib::dimension      := loadproc(solvelib::dimension, path, "dimension"):

solvelib::insertCoordinate:= loadproc(solvelib::insertCoordinate, path, "insertCoordinate"):
solvelib::selectIndices  := loadproc(solvelib::selectIndices,  path,
                                     "selectIndices"):
solvelib::getIdent       := loadproc(solvelib::getIdent, path, "getIdent"):
solvelib::preferredIdents:= loadproc(solvelib::preferredIdents, path, "getIdent"):
solvelib::preferredPrefixes:= loadproc(solvelib::preferredPrefixes, path, "getIdent"):
solvelib::setPreferredIdents:= loadproc(solvelib::setPreferredIdents, path, "getIdent"):
solvelib::setPreferredPrefix:= loadproc(solvelib::setPreferredPrefix, path, "getIdent"):
solvelib::getMultipleIdent:= loadproc(solvelib::getMultipleIdent, path,
                                      "getMultipleIdent"):

solvelib::_equal         := loadproc(solvelib::_equal,         path,"_equal"):
solvelib::solve_minus    := loadproc(solvelib::solve_minus,    path,"minus"):
solvelib::getElement     := loadproc(solvelib::getElement,     path,"getElem"):
solvelib::isFinite       := loadproc(solvelib::isFinite,       path,"isFinite"):
solvelib::ignoreSpecialCases:= loadproc(solvelib::ignoreSpecialCases,
                                        path, "ignoreSp"):
solvelib::specialToFalse := loadproc(solvelib::specialToFalse, path, "specialToFalse"):
solvelib::isBigSet       := loadproc(solvelib::isBigSet,       path, "isBigSet"):
solvelib::principalValue := loadproc(solvelib::principalValue, path,
                                     "principalValue"):

solvelib::free2Bound     := loadproc(solvelib::free2Bound,     path,"frBound"):
solvelib::bound2Free     := loadproc(solvelib::bound2Free,     path,"boundFr"):
solvelib::completeLinearSolution:= loadproc(solvelib::completeLinearSolution,
                                        path, "completeLinearSolution"):
solvelib::avoidAliasProblem:= loadproc(solvelib::avoidAliasProblem, path,
                                       "avoidAliasProblem"):
solvelib::expandTrig:= loadproc(solvelib::expandTrig, path, "expandTrig"):


//////////////////////////////////////////////////////////////////////
//       define basic sets 
//////////////////////////////////////////////////////////////////////

N_       := loadproc(N_,       path,"BasicSet"):
Z_       := loadproc(Z_,       path,"BasicSet"):
Q_       := loadproc(Q_,       path,"BasicSet"):
R_       := loadproc(R_,       path,"BasicSet"):
C_       := loadproc(C_,       path,"BasicSet"):

null():

