//    

// kg, 13/01/94 

/*--
specfunc.mu -- define/load special functions
--*/

specfunc::interface := {}:

alias(path = pathname("SPECFUNC")):

/* define special functions which are evaluated numerically by system
  functions */

kroneckerDelta:= loadproc(kroneckerDelta, path, "kroneckerDelta"):
sin:= loadproc(sin, path, "sin"):
cos:= loadproc(cos, path, "cos"):
tan:= loadproc(tan, path, "tan"):
arcsin:= loadproc(arcsin, path, "asin"):
arccos:= loadproc(arccos, path, "acos"):
arctan:= loadproc(arctan, path, "atan"):
arg:= loadproc(arg, path, "arg"):
sinh:= loadproc(sinh, path, "sinh"):
cosh:= loadproc(cosh, path, "cosh"):
tanh:= loadproc(tanh, path, "tanh"):
arcsinh:= loadproc(arcsinh, path, "asinh"):
arccosh:= loadproc(arccosh, path, "acosh"):
arctanh:= loadproc(arctanh, path, "atanh"):
exp:= loadproc(exp, path, "exp"):
laguerreL:= loadproc(laguerreL, path, "laguerreL"):
ln:= loadproc(ln, path, "ln"):
log:= loadproc(log, path, "log"):
sqrt:= loadproc(sqrt, path, "sqrt"):
surd:= loadproc(surd, path, "surd"):
gamma:= loadproc(gamma, path, "gamma"):
lngamma:= loadproc(lngamma, path, "lngamma"):
zeta:= loadproc(zeta, path, "zeta"):
erfc:=loadproc(erfc, path, "erfc"):
erfi:=loadproc(erfi, path, "erfi"):
Ei:= loadproc(Ei, path, "Ei"):
Li:= loadproc(Li, path, "Li"):
lambertW:= loadproc(lambertW, path, "lambertW"):
Ci:=loadproc(Ci, path, "Ci"):
Si:=loadproc(Si, path, "Si"):
Ssi:=loadproc(Ssi, path, "Ssi"):
Chi:=loadproc(Chi, path, "Chi"):
Shi:=loadproc(Shi, path, "Shi"):
psi:= loadproc(psi, path, "psi"):
// specfunc::ibeta = undocumented utility function without
// interface, used for statistical distributions
specfunc::ibeta:= loadproc(specfunc::ibeta, path, "ibeta"):
// specfunc::inverf = undocumented utility function without
// interface, used for statistical distributions
specfunc::inverf:= loadproc(specfunc::inverf, path, "inverf"):
igamma:= loadproc(igamma, path, "igamma"):
floor:= loadproc(floor, path, "floor"):
ceil := loadproc(ceil, path, "ceil"):
frac := loadproc(frac, path, "frac"):
round:= loadproc(round, path, "round"):
trunc:= loadproc(trunc, path, "trunc"):
cot:= loadproc(cot, path, "cot"):
csc:= loadproc(csc, path, "csc"):
sec:= loadproc(sec, path, "sec"):
arccot:= loadproc(arccot, path, "acot"):
arcsec:= loadproc(arcsec, path, "asec"):
arccsc:= loadproc(arccsc, path, "acsc"):
coth:= loadproc(coth, path, "coth"):
csch:= loadproc(csch, path, "csch"):
sech:= loadproc(sech, path, "sech"):
arccoth:= loadproc(arccoth, path, "acoth"):
arccsch:= loadproc(arccsch, path, "acsch"):
arcsech:= loadproc(arcsech, path, "asech"):
besselI:= loadproc(besselI, path, "besselI"):
besselJ:= loadproc(besselJ, path, "besselJ"):
besselY:= loadproc(besselY, path, "besselY"):
besselK:= loadproc(besselK, path, "besselK"):
hypergeom:= loadproc(hypergeom, path, "hypergeom"):
meijerG:= loadproc(meijerG, path, "meijerG"):
specfunc::MeijerG := loadproc(specfunc::MeijerG, path, "meijerG"):
erf:= loadproc(erf, path, "erf"):
inverf:= loadproc(inverf, path, "inverf"):
inverfc:= loadproc(inverfc, path, "inverfc"):
fact:= loadproc(fact, path, "fact"):
fact2:= loadproc(fact2, path, "fact2"):
dirac:= loadproc(dirac, path, "dirac"):
harmonic:= loadproc(harmonic, path, "harmonic"):
heaviside:= loadproc(heaviside, path, "heavisid"):
abs:= loadproc(abs, path, "abs"):
beta:= loadproc(beta, path, "beta"):
dawson:= loadproc(dawson, path, "dawson"):
dilog:= loadproc(dilog, path, "dilog"):
polylog:= loadproc(polylog, path, "polylog"):
bernoulli:= loadproc(bernoulli, path, "bernoull"):
binomial:= loadproc(binomial, path, "binomial"):
sign:= loadproc(sign, pathname("SPECFUNC","SIGN"), "sign"):
signIm:= loadproc(signIm, path, "signIm"):
whittakerM:= loadproc(whittakerM, path, "whittakerM"):
whittakerW:= loadproc(whittakerW, path, "whittakerW"):
kummerU:= loadproc(kummerU, path, "kummerU"):
airyAi:= loadproc(airyAi, path, "airyAi"):
airyBi:= loadproc(airyBi, path, "airyBi"):
pochhammer := loadproc(pochhammer, path, "pochhammer"):
wrightOmega:= loadproc(wrightOmega, path, "wrightOmega"):
ellipticK:= loadproc(ellipticK, path, "ellipticK"):
ellipticE:= loadproc(ellipticE, path, "ellipticE"):
ellipticCK:= loadproc(ellipticCK, path, "ellipticCK"):
ellipticCE:= loadproc(ellipticCE, path, "ellipticCE"):
ellipticF:= loadproc(ellipticF, path, "ellipticF"):
ellipticPi:= loadproc(ellipticPi, path, "ellipticPi"):
ellipticCPi:= loadproc(ellipticCPi, path, "ellipticCPi"):
ellipticNome:= loadproc(ellipticNome, path, "ellipticNome"):
jacobiSN:= loadproc(jacobiSN, path, "jacobian"):
jacobiCN:= loadproc(jacobiCN, path, "jacobian"):
jacobiDN:= loadproc(jacobiDN, path, "jacobian"):
jacobiCD:= loadproc(jacobiCD, path, "jacobian"):
jacobiSD:= loadproc(jacobiSD, path, "jacobian"):
jacobiND:= loadproc(jacobiND, path, "jacobian"):
jacobiDC:= loadproc(jacobiDC, path, "jacobian"):
jacobiNC:= loadproc(jacobiNC, path, "jacobian"):
jacobiSC:= loadproc(jacobiSC, path, "jacobian"):
jacobiNS:= loadproc(jacobiNS, path, "jacobian"):
jacobiDS:= loadproc(jacobiDS, path, "jacobian"):
jacobiCS:= loadproc(jacobiCS, path, "jacobian"):
jacobiAM:= loadproc(jacobiAM, path, "jacobiAM"):
jacobiZeta:= loadproc(jacobiZeta, path, "jacobiZeta"):

dedekindEta:= loadproc(dedekindEta, path, "dedekindEta"):
theta:= loadproc(theta, path, "theta"):
fresnelC:= loadproc(fresnelC, path, "fresnelC"):
fresnelS:= loadproc(fresnelS, path, "fresnelS"):
euler:= loadproc(euler, path, "euler"):

/* auxiliary function for dedekindEta */
// move it to the interface ?!

specfunc::eulerQProduct:= loadproc(specfunc::eulerQProduct, path, "eulerQProduct"):

/* Auxilary functions for bessel{IJKY} */

specfunc::Bessel:= loadproc(specfunc::Bessel, path, "bess_aux"):
specfunc::Hypergeom:= loadproc(specfunc::Hypergeom, path, "hyper_aux"):

/* utility for computing square roots, used in hypergeom::simplify etc. */
specfunc::Wurzelbehandlung:= loadproc(specfunc::Wurzelbehandlung, path, "Wurzelbehandlung"):

null():

// end of file 

