// stdlib.mu -- lib-file for standard library STDLIB

// the minimal expected Kernel Buildnumber for this library
stdlib::MinKernelBuildNumber:= 58658:

stdlib::interface:= {}:

/*--
  If a library routine often uses protected variables, these
  statements may be executed by syseval.
  This routine is used by loadlib and loadproc, so it has to
  be defined before the first execution of both.

  Usage:

     stdlib::syseval( expr )

  !!! stdlib::syseval is used inside of loadproc. Do not move !!!!
--*/
stdlib::syseval :=
proc()
  option hold, noDebug;
  local oldAssign, res;
begin
   oldAssign := ::_assign;
   sysassign(::_assign, sysassign);
   res := context(args());
   sysassign(::_assign, oldAssign);
  res
end_proc:

/*--
  The following sets are used for the protect mechanism of the
  MuPAD library. The variables in stdlib::ENVIRONMENT_VARIABLES
  and stdlib::SYSTEM_CONSTANTS are not protected, the variables
  in stdlib::LIBRARY_CONSTANTS are protected.
  The protection is done at the end of sysinit.mu
--*/
stdlib::ENVIRONMENT_VARIABLES:= {
  hold(DIGITS), hold(HISTORY),
  hold(LEVEL), hold(LIBPATH), hold(PACKAGEPATH), hold(MAXDEPTH), hold(MAXLEVEL),
  hold(ORDER), hold(MAXEFFORT), hold(PRETTYPRINT), hold(READPATH),
  hold(ROUNDING), hold(SEED), hold(TEXTWIDTH), hold(WRITEPATH),
  hold(_mod)
}:


stdlib::SYSTEM_CONSTANTS :=
{
 hold(CATALAN), hold(EULER), hold(PI), hold(I),
 hold(TRUE), hold(FALSE), hold(UNKNOWN),
 hold(NIL), hold(FILEPATH), hold(NOTEBOOKPATH), hold(NOTEBOOKFILE)
}:

stdlib::LIBRARY_CONSTANTS := {
  hold(infinity), hold(toBeDefined), hold(UNBOUNDED),
  hold(undefined), hold(EMPTY), hold(OPTIMAL), hold(complexInfinity)}:

stdlib::OPTIONS :=
{
 hold(ABM4),
 hold(Abel),
 hold(AbsErr),
 hold(Absolute),
 hold(AbsoluteError),
 hold(AbsoluteOrder),     // for taylor, mtaylor
 hold(AcceptSingularity),
 hold(Adaptive),
 hold(AdaptiveMesh),
 hold(Adjoin),
 hold(AffectViewingBox),
 hold(Alias),
 hold(All),
 hold(Alldata),
 hold(AllExponents),
 hold(AllRealRoots),
 hold(Always),
 hold(Angle),
 hold(AngleBegin),
 hold(AngleEnd),
 hold(AngleRange),
 hold(AnimationStyle),
 hold(Annotate),
 hold(Annotation),
 hold(AntiAliased),
 hold(Any),
 hold(Append),
 hold(ApplyRule),
 hold(ApproximateFloats), // rationalize
 hold(Arch),
 hold(Area),
 hold(Args),
 hold(ArithmeticOnly),
 hold(ArrowLength),
 hold(Ascii),  // for export::stl
 hold(Associative),
 hold(Assign),
 hold(Automatic),
 hold(AutoPlay),
 hold(AutoViewingBox),
 hold(Averaged),
 hold(AVIMode),
 hold(Axes),
 hold(AxesInFront),
 hold(AxesLineColor),
 hold(AxesLineWidth),
 hold(AxesOrigin),
 hold(AxesOriginX),
 hold(AxesOriginY),
 hold(AxesOriginZ),
 hold(AxesTips),
 hold(AxesTitleAlignment),
 hold(AxesTitleFont),
 hold(AxesTitles),
 hold(AxesVisible),
 hold(Axis),
 hold(AxisX),
 hold(AxisY),
 hold(AxisZ),

 hold(BackAndForth),
 hold(BackgroundColor),
 hold(BackgroundColor2),
 hold(BackgroundStyle),
 hold(BackgroundTransparent),
 hold(BackSubstitution),
 hold(Banded),
 hold(BarCenters),
 hold(BarStyle),
 hold(BarWidths),
 hold(Base),
 hold(BaseLine),
 hold(Baseline),
 hold(BaseRadius),
 hold(BaseX),
 hold(BaseY),
 hold(BaseZ),
 hold(BeforeFacets),
 hold(BeforePoints),
 hold(Begin),
 hold(BehindFacets),
 hold(BehindPoints),
 hold(Bellman),
 hold(Bernoulli),
 hold(BigEndian),
 hold(Billboarding),
 hold(Bin),
 hold(Binary),
 hold(BitsInLong),
 hold(Block),
 hold(Bold),
 hold(Bool),
 hold(BorderColor),
 hold(BorderWidth),
 hold(Bottom),
 hold(BottomMargin),
 hold(Boxed),
 hold(Boxes),
 hold(BoxCenters),
 hold(BoxWidths),
 hold(BravaisPearson),
 hold(BugId),
 hold(BuildNr), // undocumented option of Pref::kernel
 hold(BUTCHER6),
 hold(Byte),

 hold(CameraCoordinates),
 hold(CameraDirection),
 hold(CameraDirectionX),
 hold(CameraDirectionY),
 hold(CameraDirectionZ),
 hold(CDF),
 hold(Cells),
 hold(CellsClosed),  // for stats::frequency
 hold(Center),
 hold(CenterX),
 hold(CenterY),
 hold(CenterZ),
 hold(Chini),
 hold(Circles),
 hold(CK45),
 hold(CK54),
 hold(Clairaut),
 hold(Classes),  // for stats::frequency
 hold(ClassesClosed),  // for stats::frequency
 hold(Clean), // for numeric::{inv}fft
 hold(Clear),
 hold(ClearPrevent),
 hold(Closed),
 hold(Coeff),
 hold(Coeffs),
 hold(CollectInformation),
 hold(Color),
 hold(ColorData),
 hold(ColorQuads),
 hold(Colors),
 hold(ColumnElimination),
 hold(Columns),
 hold(Commutative),
 hold(CommandList),
 hold(Comment),
 hold(Complete),
 hold(Cond),
 hold(Consecutive),
 hold(Const),
 hold(Constrained),
 hold(Content),
 hold(Contfrac),
 hold(Continuous),
 hold(Contours),
 hold(CoordinateType),
 hold(Costs),
 hold(CovarianceMatrix),
 hold(Crit),
 hold(CrossedLines),
 hold(Crosses),
 hold(Cubic),
 hold(CurrentTime),
 hold(Cyclic),

 hold(Dashed),
 hold(Data),
 hold(DecimalComma),
 hold(Depth),
 hold(DegInvLex),
 hold(DegInvLexOrder),
 hold(DegLex),
 hold(Degree),
 hold(DegreeOrder),
 hold(DegRevLex),
 hold(Delete),
 hold(DensityData),
 hold(DensityFunction),
 hold(DescendInto), // rationalize
 hold(Developers),
 hold(Diagonal),
 hold(Diagonalization),
 hold(DiagonalLines),
 hold(DiagonalStrategy), // undocumented option of matrix::gaussElim
 hold(Diamonds),
 hold(Dichromatic),
 hold(DiffVars),
 hold(Dijkstra),
 hold(Dimension),
 hold(Directed),
 hold(Discard),
 hold(DiscontinuitySearch),
 hold(Domain),
 hold(DomainsOnly),
 hold(DontRewriteBySystem),
 hold(DOPRI45),
 hold(DOPRI54),
 hold(DOPRI56),
 hold(DOPRI65),
 hold(DOPRI78),
 hold(DOPRI87),
 hold(DotsPerInch),
 hold(Dotted),
 hold(Double),
 hold(Down),
 hold(DrawMode),
 hold(DualPrices),
 hold(Duplicate),

 hold(EdgeColor),
 hold(EdgeCosts),
 hold(EdgeDescriptions),
 hold(Edges),
 hold(EdgeWeights),
 hold(Empty),
 hold(End),
 hold(EndVertex),
 hold(Enhancement),
 hold(Environment),
 hold(EPSMode),
 hold(Error),
 hold(Escape),
 hold(Euclidean),
 hold(EULER1),
 hold(EvalChanges),
 hold(EvenOdd),
 hold(Exact),
 hold(ExactFirstOrder),
 hold(ExactSecondOrder),
 hold(Exclude),
 hold(Expand),
 hold(ExpandFinite),
 hold(ExpectedWarnings),
 hold(Explicit),
 hold(Export),
 hold(Expr),
 hold(Extended),
 hold(Extension),

 hold(Factor),
 hold(Factorbase),
 hold(FDiagonalLines),
 hold(Fechner),
 hold(FillColor),
 hold(FillColor2),
 hold(FillColorDirection),
 hold(FillColorDirectionX),
 hold(FillColorDirectionY),
 hold(FillColorDirectionZ),
 hold(FillColorFalse),
 hold(FillColorFunction),
 hold(FillColorTrue),
 hold(FillColorType),
 hold(FillColorUnknown),
 hold(Filled),
 hold(FilledCircles),
 hold(FilledDiamonds),
 hold(FilledSquares),
 hold(FillPattern),
 hold(FillPatterns),
 hold(FillStyle),
 hold(FinalValuation),
 hold(FindRelations), // rationalize
 hold(Finite),
 hold(First),
 hold(Fixed),
 hold(FixedPrecision),
 hold(Flat),
 hold(Float),
 hold(FloatFormat),
 hold(FocalPoint),
 hold(FocalPointX),
 hold(FocalPointY),
 hold(FocalPointZ),
 hold(Footer),
 hold(FooterAlignment),
 hold(FooterFont),
 hold(Force),
 hold(Forced),
 hold(Format),
 hold(Forward),
 hold(Frame),
 hold(Frames),
 hold(FramesPerSecond),
 hold(Frobenius),
 hold(From),
 hold(FromX),
 hold(FromY),
 hold(FromZ),
 hold(Full),  // used in partfrac but undocumented
 hold(Function),
 hold(Function1),
 hold(Function2),
 hold(Functional),

 hold(Gap),
 hold(GAUSS),
 hold(Gauss),
 hold(GaussChebyshev),
 hold(GaussLegendre),
 hold(GaussTschebyscheff),
 hold(GC),
 hold(Generations),
 hold(Generic),
 hold(GenOrder),
 hold(GL),
 hold(Global),
 hold(Goal),
 hold(Graphical),
 hold(GridInFront),
 hold(GridLineColor),
 hold(GridLineStyle),
 hold(GridLineWidth),
 hold(GridVisible),
 hold(Ground),
 hold(GroupStyle),
 hold(GT),

 hold(Hard),
 hold(HardwareFloats),
 hold(Header),
 hold(HeaderAlignment),
 hold(HeaderFont),
 hold(Height),
 hold(Heights),
 hold(High),
 hold(Hidden),
 hold(Hlode),
 hold(HlodeOverRF),
 hold(Homogeneous),
 hold(Horizontal),
 hold(HorizontalAlignment),
 hold(HorizontalLines),

 hold(Ident),
 hold(IgnoreAnalyticConstraints),
 hold(IgnoreProperties),
 hold(IgnoreSpecialCases),
 hold(Include),
 hold(Index),
 hold(IndexList),
 hold(Inequalities),
 hold(Infinite),
 hold(Infinity),
 hold(Info),
 hold(InitialConditions),
 hold(InitialTime),
 hold(InputFile),
 hold(InputOnly),
 hold(InSet),
 hold(Int),
 hold(Integral),
 hold(IntegratingFactor),
 hold(Interactive),
 hold(InteractiveInput),
 hold(InternalPrecision),
 hold(Interface),
 hold(Interpolation),
 hold(InterpolationStyle),
 hold(Intervals),
 hold(IntMethod),
 hold(IntMod),
 hold(InverseTransformation),
 hold(Irreducible),
 hold(IsSimple),
 hold(Iszero),  // new (undocumented) option for numeric::linsolve
 hold(Italic),
 hold(IterationRules),
 hold(Iterations),

 hold(JPEGMode),

 hold(KeepOrder),
 hold(KeepUpVector),
 hold(KernelSteps),
 hold(Krylov),

 hold(Lagrange),
 hold(LargeFactorBound),
 hold(Laurent),
 hold(Layout),
 hold(Left),
 hold(LeftMargin),
 hold(LeftRight),
 hold(Legend),
 hold(LegendAlignment),
 hold(LegendColor),
 hold(LegendEntry),
 hold(LegendFont),
 hold(LegendPlacement),
 hold(LegendText),
 hold(LegendVisible),
 hold(Length),
 hold(Level),
 hold(Lex),
 hold(Lexicographical),
 hold(LexOrder),
 hold(LieGroupAction),
 hold(LightColor),
 hold(Lighting),
 hold(LightIntensity),
 hold(Line),
 hold(Linear),
 hold(LineColor),
 hold(LineColor2),
 hold(LineColorDirection),
 hold(LineColorDirectionX),
 hold(LineColorDirectionY),
 hold(LineColorDirectionZ),
 hold(LineColorFunction),
 hold(LineColorType),
 hold(Lines),
 hold(LinesPoints),
 hold(LineStyle),
 hold(LinesVisible),
 hold(LineWidth),
 hold(LinLin),
 hold(LinLog),
 hold(List),
 hold(Lists),
 hold(LittleEndian),
 hold(Local),
 hold(Localf),
 hold(Lode),
 hold(LodeOverRF),
 hold(Logarithmic),
 hold(Logic),
 hold(LogLin),
 hold(LogLog),
 hold(Loop),
 hold(Low),
 
 hold(Mapcoeffs),
 hold(Margin),
 hold(Matrix),
 hold(Matrix2d),
 hold(Matrix3d),
 hold(Max),
 hold(MaxCalls),
 hold(MaxDegree),
 hold(MaxDepth),
 hold(MaxExponent),
 hold(Maximum),
 hold(MaxInFactorbase),
 hold(MaxInfoDepth),
 hold(MaxOrder),
 hold(MaxPart),
 hold(MaxRecLevel),
 hold(MaxSteps),
 hold(MaxStepsize),
 hold(Medium),
 hold(Mem),
 hold(Merge),
 hold(Mesh),
 hold(MeshList),
 hold(MeshListNormals),
 hold(MeshListType),
 hold(MeshVisible),
 hold(Message),
 hold(Method),
 hold(Min),
 hold(MinimalExpectedCellFrequency),
 hold(MinimalPolynomials), // rationalize 
 hold(Minimize),
 hold(MinimumDistance),
 hold(MinorExpansion),
 hold(MinPart),
 hold(ModuleTrace),
 hold(Monic),
 hold(Monochrome),
 hold(Move),
 hold(Moves),
 hold(Multiple),
 hold(MultipleBars),
 hold(MultiSolutions),

 hold(Name),
 hold(Nary),
 hold(Natural),
 hold(NC),
 hold(New),
 hold(NewtonCotes),
 hold(NoArgs),
 hold(Nocase),
 hold(NoCheck),
 hold(Nodes),
 hold(NoErrors),
 hold(NoGcd),
 hold(NoLeftVectors),
 hold(None),
 hold(NoNL),
 hold(NonNegative),
 hold(NonNested),
 hold(Noop),
 hold(NoOperators),
 hold(NoRightVectors),
 hold(NoResidues), // fuer numeric::singularvectors
 hold(Normal),
 hold(NormalX),
 hold(NormalY),
 hold(NormalZ),
 hold(Not),
 hold(NotAKnot),
 hold(Notched),
 hold(NotchWidth),
 hold(NoWarning),
 hold(Null),
 hold(NumberOfPolynomials),
 hold(NumberOfRandomTests),

 hold(ODEMethod),
 hold(OldFromNew),
 hold(OnlySpecifiedEdges),
 hold(Open),
 hold(Order),
 hold(Origin),
 hold(OrthogonalProjection),
 hold(Otherwise),
 hold(Output),
 hold(OutputBox),     // for export::stl
 hold(OutputDomain),
 hold(OutputFile),
 hold(OutputOnly),
 hold(OutputOptions),
 hold(OutputType),
 hold(OutputUnits),
 hold(OutSet),

 hold(ParameterBegin),
 hold(ParameterEnd),
 hold(ParameterName),
 hold(ParameterRange),
 hold(ParameterValue),
 hold(Parent),
 hold(Path),
 hold(PDF),
 hold(Periodic),
 hold(PF),
 hold(Plain),
 hold(PlotAt),
 hold(PointColor),
 hold(PointColor2),
 hold(PointColorType),
 hold(Points),
 hold(Points2d),
 hold(Points3d),
 hold(PointSize),
 hold(PointStyle),
 hold(PointsVisible),
 hold(PolyExpr),
 hold(Pop),
 hold(Population),
 hold(Position),
 hold(PositionX),
 hold(PositionY),
 hold(PositionZ),
 hold(Postfix),
 hold(PostMap),
 hold(Preconditioning),
 hold(Prefix),
 hold(PreMap),
 hold(Presentation),
 hold(PreventRecursion),
 hold(PrimeLimit),
 hold(Primitive),
 hold(PrincipalValue),
 hold(Print),
 hold(Priority),
 hold(Projectors),
 hold(Properties),
 hold(Proportional),
 hold(Protect),
 hold(Protected),
 hold(ProtectLevelError),
 hold(ProtectLevelNone),
 hold(ProtectLevelWarning),
 hold(Puiseux),
 hold(Push),
 hold(PValue),
 hold(PValue1),
 hold(PValue2),
 hold(Pyramid),

 hold(QDet),
 hold(QRD),
 hold(Quads),
 hold(QuadStrip),
 hold(Quality),
 hold(Quiet),
 hold(Quo),

 hold(Radius),
 hold(RadiusFunction),
 hold(Rainbow),
 hold(Random),
 hold(Ranges),
 hold(RatExpr),
 hold(RationalExpression), // attribute for plot::Rootlocus
 hold(Rationalize),        // for normal
 hold(Raw),
 hold(Read),
 hold(Real),
 hold(Recursive),
 hold(ReduceTo256Colors),
 hold(Relative),
 hold(RelativeError),
 hold(RelativeOrder),     // for taylor, mtaylor
 hold(RelErr),
 hold(Rem),
 hold(Remember),
 hold(RememberLast),
 hold(Reorder),
 hold(ReplaceHardToEval), // rationalize 
 hold(ReplaceTypes), // rationalize
 hold(Reset),
 hold(Restore),
 hold(RestrictedSearch),
 hold(ReturnAsGraph),
 hold(ReturnAsTable),
 hold(ReturnMatches),
 hold(ReturnType),
 hold(Reverse),
 hold(ReverseNocase),
 hold(RevLex),
 hold(Riccati),
 hold(RiemannMiddle),
 hold(RiemannLeft),
 hold(RiemannLower),
 hold(RiemannLowerAbs),
 hold(RiemannRight),
 hold(RiemannUpper),
 hold(RiemannUpperAbs),
 hold(Right),
 hold(RightMargin),
 hold(RK4),
 hold(RKF34),
 hold(RKF43),
 hold(RKF45a),
 hold(RKF45b),
 hold(RKF54a),
 hold(RKF54b),
 hold(RKF78),
 hold(RKF87),
 hold(Root),
 hold(RotationAngle),
 hold(Rows),
 hold(RuleBase),
 hold(RunOnce),

 hold(Save),
 hold(Sample),
 hold(Scale),
 hold(Scales),
 hold(ScaleX),
 hold(ScaleY),
 hold(ScaleZ),
 hold(Scaling),
 hold(SearchFor),
 hold(SearchLevel),
 hold(SearchWith),
 hold(Seconds),
 hold(Seed),
 hold(SelectRules),
 hold(SemiAxes),
 hold(SemiAxisX),
 hold(SemiAxisY),
 hold(SemiAxisZ),
 hold(SemiInfinite),
 hold(Separator),
 hold(Shading),
 hold(Shadows),
 hold(Shift),
 hold(Shifted),
 hold(ShiftX),
 hold(ShiftY),
 hold(ShiftZ),
 hold(Short),
 hold(Show),
 hold(ShowAssumptions),
 hold(ShowDependencies),
 hold(ShowInfo),
 hold(SieveArrayLimit),
 hold(SignedByte),
 hold(SignedShort),
 hold(SignedWord),
 hold(Simpson),
 hold(SingleBars),
 hold(Size),
 hold(Small),
 hold(Smooth),
 hold(Soft),
 hold(SoftwareFloats),
 hold(Solid),
 hold(Solved),
 hold(Sort),
 hold(Spacing),
 hold(Sparse),
 hold(Special),
 hold(SpecialEdgeColor),
 hold(SpecialEdges),
 hold(SpecialVertexColor),
 hold(SpecialVertices),
 hold(Spectral),
 hold(Splines),
 hold(SpotAngle),
 hold(SquareFree),
 hold(Squares),
 hold(Stars),
 hold(StartingPoint),
 hold(StartingValues),
 hold(StartRule),
 hold(StartVertex),
 hold(StatValue),
 hold(StatValue1),
 hold(StatValue2),
 hold(StepLength),
 hold(Steps),
 hold(Stepsize),
 hold(StopIf),
 hold(StopOn), // rationalize
 hold(StopOnConstants), // rationalize 
 hold(Strategy),
 hold(String),
 hold(Style),
 hold(SubgridLineColor),
 hold(SubgridLineStyle),
 hold(SubgridLineWidth),
 hold(SubgridVisible),
 hold(Submesh),
 hold(Subset),
 hold(Suffix),
 hold(Summary),
 hold(Superset),
 hold(SVD),
 hold(Symbolic),
 hold(SymbolicAnalysis),
 hold(Symmetric),
 hold(System),

 hold(Table),
 hold(Tabular),
 hold(Tangent1),
 hold(Tangent1X),
 hold(Tangent1Y),
 hold(Tangent1Z),
 hold(Tangent2),
 hold(Tangent2X),
 hold(Tangent2Y),
 hold(Tangent2Z),
 hold(Target),
 hold(TargetX),
 hold(TargetY),
 hold(TargetZ),
 hold(Taylor),
 hold(TaylorExpansion),
 hold(TempFile),
 hold(Terms),
 hold(Test),
 hold(Text),
 hold(TextFont),
 hold(TextOrientation),
 hold(TextRotation),
 hold(TicksAnchor),
 hold(TicksAt),
 hold(TicksBetween),
 hold(TicksDistance),
 hold(TicksLabelFont),
 hold(TicksLabelStyle),
 hold(TicksLabelsVisible),
 hold(TicksLength),
 hold(TicksNumber),
 hold(TicksVisible),
 hold(TimeBegin),
 hold(TimeEnd),
 hold(TimeMesh),
 hold(Timeout),
 hold(TimeRange),
 hold(TimeValue),
 hold(TipAngle),
 hold(TipLength),
 hold(TipStyle),
 hold(Title),
 hold(TitleAlignment),
 hold(TitleFont),
 hold(TitlePosition),
 hold(TitlePositionX),
 hold(TitlePositionY),
 hold(TitlePositionZ),
 hold(Titles),
 hold(To),
 hold(ToCancel),
 hold(ToInfinity),
 hold(Tolerance),
 hold(ToMinusInfinity),
 hold(ToNearest),
 hold(Top),
 hold(TopBottom),
 hold(TopMargin),
 hold(TopRadius),
 hold(TopX),
 hold(TopY),
 hold(TopZ),
 hold(ToX),
 hold(ToY),
 hold(ToZ),
 hold(ToZero),
 hold(Trace),
 hold(TrailingZeroes),
 hold(Transform),
 hold(Transformation),
 hold(Transposed),
 hold(TrapError),
 hold(Trapezoid),
 hold(Tree),
 hold(TriangleFan),
 hold(Triangles),
 hold(TriangleStrip),
 hold(Trim),
 hold(TubeDiameter),
 hold(Tubular),
 hold(TurtleRules),
 hold(Type),
 hold(Typeset),

 hold(ULinesVisible),
 hold(UMax),
 hold(UMesh),
 hold(UMin),
 hold(UName),
 hold(Unconstrained),
 hold(Undefined),
 hold(Undirected),
 hold(Unimodular),
 hold(Unique),
 hold(UnitVectors),
 hold(Unquoted),
 hold(UnrestrictedSearch),
 hold(Unsimplified),
 hold(Unsorted),
 hold(Unused),
 hold(Up),
 hold(UpVector),
 hold(UpVectorX),
 hold(UpVectorY),
 hold(UpVectorZ),
 hold(URange),
 hold(UseDigits),
 hold(UseGseries),
 hold(UseNormals),
 hold(UsePrimeTab),
 hold(User),
 hold(UseSolver),
 hold(USubmesh),

 hold(Valuation),
 hold(VectorFormat),
 hold(Vertex),
 hold(Vertex1Color),
 hold(Vertex2Color),
 hold(VertexColor),
 hold(VertexOrder),
 hold(VertexWeights),
 hold(Vertical),
 hold(VerticalAlignment),
 hold(VerticalAsymptotesColor),
 hold(VerticalAsymptotesStyle),
 hold(VerticalAsymptotesVisible),
 hold(VerticalAsymptotesWidth),
 hold(VerticalLines),
 hold(VerticesPerLine),
 hold(ViewDirectional),
 hold(ViewFocalPointX),
 hold(ViewFocalPointY),
 hold(ViewFocalPointZ),
 hold(ViewingAngle),
 hold(ViewingBox),
 hold(ViewingBoxXMax),
 hold(ViewingBoxXMin),
 hold(ViewingBoxXRange),
 hold(ViewingBoxYMax),
 hold(ViewingBoxYMin),
 hold(ViewingBoxYRange),
 hold(ViewingBoxZMax),
 hold(ViewingBoxZMin),
 hold(ViewingBoxZRange),
 hold(ViewKeepUpVector),
 hold(ViewOrthogonalProjection),
 hold(ViewPositionX),
 hold(ViewPositionY),
 hold(ViewPositionZ),
 hold(ViewTranslationX),
 hold(ViewTranslationY),
 hold(ViewTranslationZ),
 hold(ViewUpVectorX),
 hold(ViewUpVectorY),
 hold(ViewUpVectorZ),
 hold(ViewViewingAngle),
 hold(ViewXMax),
 hold(ViewXMin),
 hold(ViewYMax),
 hold(ViewYMin),
 hold(Visible),
 hold(VisibleAfter),
 hold(VisibleAfterEnd),
 hold(VisibleBefore),
 hold(VisibleBeforeBegin),
 hold(VisibleFromTo),
 hold(VLinesVisible),
 hold(VMax),
 hold(VMesh),
 hold(VMin),
 hold(VName),
 hold(VRange),
 hold(VSubmesh),

 hold(WeightedDegLex),
 hold(WeightedDegRevLex),
 hold(WeightedLex),
 hold(WeightedRevLex),
 hold(Weights),
 hold(Width),
 hold(Winding),
 hold(WMFMode),
 hold(Word),
 hold(Write),

 hold(XAxisTitle),
 hold(XAxisTitleAlignment),
 hold(XAxisVisible),
 hold(xCK45),
 hold(xCK54),
 hold(XContours),
 hold(XCrossedLines),
 hold(XCrosses),
 hold(xDOPRI45),
 hold(xDOPRI54),
 hold(xDOPRI56),
 hold(xDOPRI65),
 hold(xDOPRI78),
 hold(xDOPRI87),
 hold(XFunction),
 hold(XFunction1),
 hold(XFunction2),
 hold(XGap),
 hold(XGridVisible),
 hold(XLinesVisible),
 hold(XMax),
 hold(XMesh),
 hold(XMin),
 hold(XName),
 hold(XRange),
 hold(xRKF34),
 hold(xRKF43),
 hold(xRKF45a),
 hold(xRKF45b),
 hold(xRKF54a),
 hold(xRKF54b),
 hold(xRKF78),
 hold(xRKF87),
 hold(XSubgridVisible),
 hold(XSubmesh),
 hold(XTicksAnchor),
 hold(XTicksAt),
 hold(XTicksBetween),
 hold(XTicksDistance),
 hold(XTicksLabelStyle),
 hold(XTicksLabelsVisible),
 hold(XTicksNumber),
 hold(XTicksVisible),

 hold(YAxisTitle),
 hold(YAxisTitleAlignment),
 hold(YAxisTitleOrientation),
 hold(YAxisVisible),
 hold(YContours),
 hold(YFunction),
 hold(YFunction1),
 hold(YFunction2),
 hold(YGap),
 hold(YGridVisible),
 hold(YLinesVisible),
 hold(YMax),
 hold(YMesh),
 hold(YMin),
 hold(YName),
 hold(YRange),
 hold(YSubgridVisible),
 hold(YSubmesh),
 hold(YTicksAnchor),
 hold(YTicksAt),
 hold(YTicksBetween),
 hold(YTicksDistance),
 hold(YTicksLabelStyle),
 hold(YTicksLabelsVisible),
 hold(YTicksNumber),
 hold(YTicksVisible),
 hold(YXRatio),

 hold(ZAxisTitle),
 hold(ZAxisTitleAlignment),
 hold(ZAxisVisible),
 hold(ZContours),
 hold(ZFunction),
 hold(ZFunction1),
 hold(ZFunction2),
 hold(ZGridVisible),
 hold(ZMax),
 hold(ZMesh),
 hold(ZMin),
 hold(ZName),
 hold(Z_Name), // (hidden) attribute in plot::Rootlocus
 hold(ZRange),
 hold(ZSubgridVisible),
 hold(ZTicksAnchor),
 hold(ZTicksAt),
 hold(ZTicksBetween),
 hold(ZTicksDistance),
 hold(ZTicksLabelStyle),
 hold(ZTicksLabelsVisible),
 hold(ZTicksNumber),
 hold(ZTicksVisible),
 hold(ZXRatio),

 // targets for rewrite: first letter is lower case

 hold(andor),
 hold(sincos),
 hold(sinhcosh),

 // special options for plot::easy: start with #

 hold(#3D),
 hold(#Arrows),
 hold(#Constrained),
 hold(#Grid),
 hold(#Legend),
 hold(#Origin),
 hold(#Points),
 hold(#XRange),
 hold(#YRange),
 hold(#ZRange)

}:

stdlib::SYSTEM_TABLES := {
  hold(stdlib::Alias)
}:

alias(path = pathname("STDLIB")):

D:= loadproc(D, path, "D"):
Im:= loadproc(Im, pathname("STDLIB","IM"), "Im"):
O:= loadproc(O, path, "O"):
pade := loadproc(pade, path, "pade"):
Re:= loadproc(Re, pathname("STDLIB","RE"), "Re"):
taylor:= loadproc(taylor, path, "taylor"):
_fnest:= loadproc(_fnest, path, "fnest"):
_implies:= loadproc(_implies, path, "implies"):
`==>`:= loadproc(`==>`, path, "implies"):
_equiv:= loadproc(_equiv, path, "equiv"):
`<=>`:= loadproc(`<=>`, path, "equiv"):
_in:= loadproc(_in, path, "in"):
_subset := loadproc(_subset, path, "subset"):
_notsubset := loadproc(_notsubset, path, "subset"):
card:= loadproc(card, path, "card"):
_print_userinfo:= loadproc(_print_userinfo, path, "userinfo"):
_xor:= loadproc(_xor, path, "xor"):
_approx := loadproc(_approx, path, "approx"):
`~=` := loadproc(`~=`, path, "approx"):
anames:= loadproc(anames, path, "anames"):
assert:= loadproc(assert, path, "assert"):
assign:= loadproc(assign, path, "assign"):
asympt:= loadproc(asympt, path, "asympt"):
autoload := loadproc(autoload, path, "autoload"):
autoloadLibrary := loadproc(autoloadLibrary, path, "autoload"):
stdlib::standardFilename := loadproc(stdlib::standardFilename, path, "autoload"):
collect:= loadproc(collect, path, "collect"):
combine:= loadproc(combine, path, "combine"):
complexInfinity:= loadproc(complexInfinity, path, "cinfty"):
stdlib::CInfinity:= loadproc(stdlib::CInfinity, path, "cinfty"):
conjugate:= loadproc(conjugate, pathname("STDLIB","CONJ"), "conj"):
content:= loadproc(content, path, "content"):
contfrac:= loadproc(contfrac, path, "contfrac"):
stdlib::deferredAlias := loadproc(stdlib::deferredAlias, path, "deferredAlias"):
denom:= loadproc(denom, path, "denom"):
det:= loadproc(det, path, "det"):
stdlib::diff := loadproc(stdlib::diff, path, "diff"):
discont:= loadproc(discont, path, "discont"):
doprint:= loadproc(doprint, path, "doprint"):
evalassign:= loadproc(evalassign, path, "evalassign"):
evalAt:= loadproc(evalAt, path, "evalAt"):
`|`:= loadproc(`|`, path, "evalAt"):
expose:= loadproc(expose, path, "expose"):
factor:= loadproc(factor, path, "factor"):
factorout:= loadproc(factorout, path, "factorout"):
forget:= loadproc(forget, path, "forget"):
freeze:= loadproc(freeze, path, "freeze"):
stdlib::frozen:= loadproc(stdlib::frozen, path, "freeze"):
gcd:= loadproc(gcd, path, "gcd"):
gcdex:= loadproc(gcdex, path, "gcdex"):
ground:= loadproc(ground, path, "ground"):
stdlib::hasaccess:= loadproc(stdlib::hasaccess, path, "hasaccess"):
hastype:= loadproc(hastype, path, "hastype"):
stdlib::hasmsign:= loadproc(stdlib::hasmsign, path, "hasmsign"):
htranspose:= loadproc(htranspose, path, "htranspose"):
infinity:= loadproc(infinity, path, "infinity"):
stdlib::Infinity:= loadproc(stdlib::Infinity, path, "infinity"):
info:= loadproc(info, path, "info"):
int:= loadproc(int, path, "int"):
interpolate:= loadproc(interpolate, path, "interpolate"):
inverse:= loadproc(inverse, path, "inverse"):
iquo:= loadproc(iquo, path, "iquo"):
irem:= loadproc(irem, path, "irem"):
irreducible:= loadproc(irreducible, path, "irreduc"):
ithprime:=loadproc(ithprime, path, "ithprime"):
lcm:= loadproc(lcm, path, "lcm"):
lhs := loadproc(lhs,path,"lhsrhs"):
linsolve:= loadproc(linsolve, path, "linsolve"):
stdlib::mapEvalChanges:= loadproc(stdlib::mapEvalChanges, path, "mapEvalChanges"):
maprat:= loadproc(maprat, path, "maprat"):
match:= loadproc(match, pathname("MATCHLIB"), "match"):
max:= loadproc(max, path, "minmax"):
min:= loadproc(min, path, "minmax"):
mtaylor:= loadproc(mtaylor, path, "mtaylor"):
normal:= loadproc(normal, path, "normal"):
stdlib::normalNoExpand:= loadproc(stdlib::normalNoExpand, path, "normalNoExpand"):
stdlib::normalizesign:= loadproc(stdlib::normalizesign, path, "normalizesign"):
stdlib::normal:= loadproc(stdlib::normal, path, "normal"):
numer:= loadproc(numer, path, "numer"):
operator:= loadproc(operator, path, "operator"):
package := loadproc(package, path, "package"):
partfrac:= loadproc(partfrac, path, "partfrac"):
plotfunc2d:= loadproc(plotfunc2d, path, "plotfunc2d"):
plotfunc3d:= loadproc(plotfunc3d, path, "plotfunc3d"):
powermod:= loadproc(powermod, path, "powermod"):
product:= loadproc(product, path, "product"):
radsimp:= loadproc(radsimp, path, "radsimp"):
stdlib::radsimp_matchsqrt:= loadproc(stdlib::radsimp_matchsqrt, path, "radsimp"):
stdlib::radnormal:= loadproc(stdlib::radnormal, path, "radsimp"):
random:= loadproc(random, path, "random"):
rationalize := loadproc(rationalize, path, "rationalize"):
readbytes := loadproc(readbytes, path, "readbytes"):
rectform:= loadproc(rectform, pathname("STDLIB","RECTFORM"), "rectform"):
remember:= loadproc(remember, path, "remember"):
revert := loadproc(revert, path, "revert"):
rewrite:= loadproc(rewrite, path, "rewrite"):
stdlib::D2diff:= loadproc(stdlib::D2diff, path, "rewrite"):
stdlib::diff2D:= loadproc(stdlib::diff2D, path, "rewrite"):
rhs := loadproc(rhs,path,"lhsrhs"):
series:= loadproc(series, path, "series"):
setuserinfo:= loadproc(setuserinfo, path, "setuinfo"):
simplify:= loadproc(simplify, pathname("STDLIB","SIMPLIFY"), "simplify"):
stdlib::simplify_dirac:= loadproc(stdlib::simplify_dirac, 
                    pathname("STDLIB","SIMPLIFY"), "simplify_dirac"):
sum:= loadproc(sum, path, "sum"):
sysevalassign:= loadproc(sysevalassign, path, "sysevalassign"):
undefined:= loadproc(undefined, path, "undef"):
stdlib::Undefined := loadproc(stdlib::Undefined, path, "undef"):
transpose:= loadproc(transpose, path, "transpose"):
unfreeze:= loadproc(unfreeze, path, "freeze"):
universe:= loadproc(universe, path, "universe"):
unuse:= loadproc(unuse, path, "unuse"):
use:= loadproc(use, path, "use"):
version:= loadproc(version, path, "version"):
ifactor:= loadproc(ifactor, path, "ifactor"):
coerce:= loadproc(coerce, path, "coerce"):
densematrix:= loadproc(densematrix, path, "densematrix"):
sparsematrix:= loadproc(sparsematrix, path, "sparsematrix"):
matrix:= loadproc(matrix, path, "matrix"):
Factored:= loadproc(Factored, path, "Factored"):
frandom:= loadproc(frandom, path, "frandom"):

testeq := loadproc(testeq, path, "testeq"):

/* -------- RootOf -------- */
RootOf := loadproc(RootOf, path, "RootOf"):
// the following methods are used in 'sum':
stdlib::RootOf_polysum:= loadproc(stdlib::RootOf_polysum, path, "RootOf" ):
stdlib::RootOf_evala:= loadproc(stdlib::RootOf_evala, path, "RootOf" ):
stdlib::RootOf_expand_power:= loadproc(stdlib::RootOf_expand_power, path, "RootOf" ):

/* -------- block/unblock --*/
block := loadproc(block, path, "block"):
blockIdents:= loadproc(blockIdents, path, "block"):
blockTransparent:= loadproc(blockTransparent, path, "block"):
unblock:= loadproc(unblock, path, "block"):


/* ------- limit --------- */
limit:= loadproc(limit, path, "limit"):
/* -------  solve --------- */
solve                  := loadproc(solve,                  path,"solve"):

/* ------- piecewise ------- */
piecewise:= loadproc(piecewise, path, "piecewis"):
stdlib::branch:= loadproc(stdlib::branch, path, "piecewis"):

/* ------- DOM_SET --------- */
DOM_SET::func_call:= DOM_ARRAY::func_call:
DOM_SET::new:= proc() name new; begin {args()} end_proc:
DOM_SET::new_extelement:= DOM_ARRAY::new_extelement:
DOM_SET::sort:= loadproc(DOM_SET::sort, path, "setops"):
DOM_SET::_index:= loadproc(DOM_SET::_index, path, "setops"):
DOM_SET::_plus:= loadproc(DOM_SET::_plus, path, "setops"):
DOM_SET::_mult:= loadproc(DOM_SET::_mult, path, "setops"):
DOM_SET::_power:= loadproc(DOM_SET::_power, path, "setops"):
DOM_SET::bin_power:= loadproc(DOM_SET::bin_power, path, "setops"):
DOM_SET::inhomogleft_power:= loadproc(DOM_SET::inhomogleft_power, path, "setops"):
DOM_SET::inhomogright_power:= loadproc(DOM_SET::inhomogright_power, path, "setops"):
DOM_SET::coerce:= loadproc(DOM_SET::coerce, path, "setops"):


/* ------- DOM_LIST --------- */
DOM_LIST::_plus:= loadproc(DOM_LIST::_plus, path, "listops"):
DOM_LIST::_mult:= loadproc(DOM_LIST::_mult, path, "listops"):
DOM_LIST::_power:= loadproc(DOM_LIST::_power, path, "listops"):

/* ------- _plus, _mult, _power for other sets -------*/
stdlib::set_plus:= loadproc(stdlib::set_plus, path, "setfuncs"):
stdlib::set_mult:= loadproc(stdlib::set_mult, path, "setfuncs"):
stdlib::set_power:= loadproc(stdlib::set_power, path, "setfuncs"):

/*-------- combine-attributes for _plus, _mult, _power -----------*/

_plus:= slot(_plus,"combine",
        loadproc(slot(_plus,"combine"),pathname("STDLIB","COMBINE"),
        "_plus")):


_mult:= slot(_mult,"combine",
        loadproc(slot(_mult,"combine"),pathname("STDLIB","COMBINE"),
        "_mult")):

_power:= slot(_power, "combine",
              loadproc(slot(_power, "combine"), pathname("STDLIB","COMBINE"),
        "_power")):

// the bitmap module, for import::readbitmap
stdlib::bitmap := loadproc(stdlib::bitmap, path, "bitmap"):

/*-------- export some of the functions of property ----- */
is := loadproc(is, path, "is" ):
showprop := loadproc(showprop, path, "showprop" ):
assume := loadproc(assume, path, "assume" ):
assumeAlso:= loadproc(assumeAlso, path, "assumeAlso" ):
_assuming := loadproc(_assuming,  path, "_assuming"):
_assumingAlso := loadproc(_assumingAlso,  path, "_assumingAlso"):
getprop := loadproc(getprop, path, "getprop" ):
unassume := loadproc(unassume, path, "unassume" ):

/*------ CONTINUE -----------*/
alias(ProtOldOptions = [hold(None), hold(Warning), hold(Error)]):
alias(ProtNewOptions = [hold(ProtectLevelNone), hold(ProtectLevelWarning),
                           hold(ProtectLevelError)]):
alias(old2new(OPT) = _if(contains(ProtOldOptions, OPT) > 0,
                         op(ProtNewOptions, contains(ProtOldOptions, OPT)),
                         OPT)):
alias(new2old(OPT) = _if(contains(ProtNewOptions, OPT) > 0,
                         op(ProtOldOptions, contains(ProtNewOptions, OPT)),
                         OPT)):
protect:=
  proc()
    name protect;
    option hold;
    local LEVEL;
  begin
    sysassign(stdlib::PROTECTED, stdlib::PROTECTED union {args(1)});
    LEVEL:= (if args(0) = 2 then
               protected(args(1), new2old(context(args(2))))
             else
               protected(args(1), hold(Warning))
             end_if);
    old2new(LEVEL)
  end_proc:

unprotect:=
  proc()
    name unprotect;
    option hold;
    local LEVEL;
  begin
    sysassign(stdlib::PROTECTED, stdlib::PROTECTED minus {args(1)});
    LEVEL:= protected(args(1), hold(None));
    old2new(LEVEL)
  end_proc:

unalias(ProtOldOptions):
unalias(ProtNewOptions):
unalias(old2new):
unalias(new2old):

// Domain fuer spez. Ausgabe
stdlib::Exposed:= newDomain("stdlib::Exposed"):
stdlib::Exposed::create_dom:=hold(stdlib::Exposed):
stdlib::Exposed::op:= proc(x, rg = null()) begin op(extop(x, 2..extnops(x)), rg) end_proc:
stdlib::Exposed::subsop:= proc(x) begin subsop(extop(x, 2..extnops(x)), args(2..args(0))) end_proc:
stdlib::Exposed::nops:= (x)-> extnops(x) - 1:
stdlib::Exposed::print:= proc(x) begin extop(x, 1)(extop(x, 2..extnops(x))) end_proc:
// erstes
stdlib::Exposed::new:=
  proc(x)
  begin
    if args(0) = 1 or not(contains({DOM_PROC, DOM_FUNC_ENV}, type(x))) then
      new(stdlib::Exposed, extop, args())
    else
      new(stdlib::Exposed, args())
    end_if
  end_proc:
stdlib::Exposed::Content := () -> error("not yet implemented"):

// function environment uses for Pretty outputs -- used in Dom::ImageSet
_outputSequence :=
funcenv(_outputSequence,
        builtin(1100, 25, "", "_outputSequence")):
_outputSequenceINFINITE :=
funcenv(hold(_outputSequenceINFINITE),
        builtin(1100, 1000000, "", "_outputSequenceINFINITE")):
_outputSequencePlus :=
funcenv(_outputSequencePlus,
        builtin(1100, 1000, "", "_outputSequencePlus")):
_outputSequenceMult :=
funcenv(_outputSequenceMult,
        builtin(1100, 1100, "", "_outputSequenceMult")):
_outputSequencePower :=
funcenv(_outputSequencePower,
        builtin(1100, 1200, "", "_outputSequencePower")):


/*
 * Generate output Function for template t which expects exactly n
 * arguments. If the number of arguments in the input differs,
 * use functional output.
 * If the number of expected arguments is n -1, the template accepts
 * any number of arguments and is always used.
 * If m and n are given, the number of arguments must be between those two.
 * In that case m can be infinity.
 */
stdlib::genOutFunc :=  proc(t : DOM_STRING, n = -1 : DOM_INT, m = -1)
                          option escape;
                        begin
                          (Out, data) ->
                          if n = -1 or nops(data) = n or
                             // number of args between n and m
                             n <= nops(data) and nops(data) <= m then
                            Out::Capply(slot(Out, t), op(map([op(data)],Out)));
                          else
                            Out::stdFunc(data);
                          end_if:
                        end:

// stdlib::interactive(): Has the calling function been called interactively?
stdlib::interactive := () -> bool(context(hold(context(hold(_act_proc_env())))) = null()):

// Aligns strings by adding spaces in front of short strings and
// concatenating them with newline inbetween; used for int, sum, product outputs
stdlib::align :=
proc()
  local len, strings, i ,j;
begin
  len := max(op(map([args()], length)));
  if len > TEXTWIDTH - 3 then
    len := TEXTWIDTH - 3
  end_if;
  strings := [args()];
  for i from 1 to nops(strings) do
    strings[i] := _concat(" " $ j = 1..(len-length(strings[i])+1) div 2).strings[i];
    if i < nops(strings) then
      strings[i] := strings[i]."\n"
    end_if;
  end_for;
  _concat(op(strings))
end_proc:

_pref(hold(Alias)=[TRUE,
                   proc()
                     option noDebug;
                     local config, trap;
                   begin
                     config := _parser_config();
                     if config = null() then
                       return(table())
                     else
                       config := op(config,2);
                       trap := traperror((config := map([op(config)],
                                     x -> (x,
//                                           text2expr(expr2text(op(x,1)))=
//                                           op(x, 2),
//                                           text2expr(expr2text(eval(op(x,1))))=
//                                           op(x, 2),
                                           eval(op(x, 1))=op(x, 2)))));
                       if trap = 0 then
                         return(table(op(config)));
                       else
                       // if this line is reached, we had an error above
                         return(table());
                       end_if;
                     end_if;
                   end_proc]):

// initialisiere Completion
_pref(hold(Complete) =
proc(x)
    name Complete;
    option noDebug;
    local globals, libs, funcEnvs, interface, all, makeNames, i,
          num, domName, DOMAIN, verboseRead, try, masked_x;
begin
  // disable verboseRead during Completion
  verboseRead := Pref::verboseRead(0);

  makeNames := proc(d, s)
    name makeNames;
    local i;
  begin
     d."::".op(s,i) $ i = 1..nops(s);
  end_proc:

  // if procedure gets the whole input line:
  // extract left word // !! end of loop: stringlib::FirstIndex !!
  try := x;
  for i from length(try) downto 1 do
    x := substring(try, i..length(try));
    if contains(stringlib::punctuation, substring(try, i)) <> 0
       and contains(["_", ":"], substring(try, i)) = 0 then
      break
    end_if
  end_for;

  if contains({"", ":", "::"}, x) or
    x[1]=":" and length(x) > 1 and x[2] <> ":" then
    return("")
  end_if;

  masked_x := "^".stringlib::maskMeta(x);

  // select only matching globals to determine DOM_DOMAIN and DOM_FUNC_ENV
  globals := map(select(stdlib::anames(3),
			X -> strmatch(expr2text(X), masked_x)),
                 X -> context(hold(val)(X)));
  [libs,funcEnvs,globals] :=
      split(globals, X -> op([UNKNOWN, TRUE, FALSE],
                             contains([DOM_DOMAIN, DOM_FUNC_ENV],
                                      type(X)) + 1));
  // All
  all:= select(Pref::allComplete(), strmatch, masked_x);

  // if given a ':' or '::'
  num := op(strmatch(x, ".*:+", Index), 2):

  if type(num) = DOM_INT then
    // possibly domain
    if x[num - 1] = ":" then
      // two ':'
      if num > 2 and x[num - 2] = ":" then
        // more than two ':'
        return("")
      else
        num:= num - 1
      end_if
    end_if;
    domName := substring(x, 1, num-1);

    if contains(Pref::keywords(), domName) then
      return("")
    else
      if traperror((DOMAIN := eval(text2expr(domName)))) <> 0 then
        return("");
      end_if;
      interface := {};
      if domtype(DOMAIN) = DOM_DOMAIN or
        // completion for domain elements
        domtype(DOMAIN::dom::complete(DOMAIN)) = DOM_SET then
        if domtype(DOMAIN) = DOM_DOMAIN then
          if domtype(DOMAIN::interface) = DOM_SET then
            interface := map(DOMAIN::interface, expr2text);
          elif domtype(DOMAIN::allEntries()) = DOM_SET then
            interface := DOMAIN::allEntries();
          end_if
        else
          // completion for domain elements
          interface := map(DOMAIN::dom::complete(DOMAIN), expr2text);
        end_if;

        interface := {makeNames(domName, interface)};
      elif domtype(DOMAIN) = DOM_FUNC_ENV then
        // DOMAIN is a function environment
        if domtype(op(DOMAIN,3)) = DOM_TABLE then
          // there are slots defined
          if domtype(DOMAIN::interface) = DOM_SET then
            interface := {makeNames(domName, DOMAIN::interface)};
          else
            interface := {};
          end_if;
        else
          interface := {};
        end_if;
      else
        // DOMAIN is no domain
        interface := {};
      end_if
    end_if
  else

    // uniq completion; try loading loadproc
    if nops(all) = 1 and not contains(Pref::keywords(), op(all,1)) then
        text2expr(op(all, 1));
        if traperror((DOMAIN := eval(%))) <> 0 then
          return("");
        end_if;
        if domtype(DOMAIN) = DOM_DOMAIN then
          // do not use expr2text; now densematrix shows ::
          if DOMAIN::interface = {} then
            libs := {};
          else
            libs := all;
          end_if;
        else
          libs := {}
        end_if;
    else
      // normal name completion, no ':' given
      libs:= select(libs, x->x::interface <> {});
      libs:= map(libs, expr2text);
    end_if;

    if nops(libs) = 1 and all = libs then
      // additionally the domain without '::'
      all:= all union map(libs minus Pref::noComplete(), _concat, "::")
    end_if;
    interface := {};
  end_if;

  all := op(sort(select([op((interface union all) minus
                            Pref::noComplete())], strmatch, "^".x),
                 (s1, s2) -> stringlib::lower(s1) < stringlib::lower(s2)));
  // restore Pref::verboseRead
  Pref::verboseRead(verboseRead);
  if domtype(all) = DOM_STRING /* and x <> all */ then
      // try to complete domains in domains
    try :=  _pref(hold(Complete))(all."::");
    if try <> null() and try <> "" then
      return(all, all."::")
    end_if
  end_if;
  all;
end_proc):

// this set contains names ot temporary files which will be deleted
// by Pref::callOnExit, when the system quits
stdlib::TempFiles := {}:

// This set contains types used by rationalize::descent
stdlib::rDHSet := {"_mult", "_plus", DOM_SET, DOM_LIST}:

// special environments used for integration
// _pattern -- defining patterns used in intlib's pattern matcher
_pattern:=funcenv(_pattern):
_pattern::type := "_pattern": // for pattern variable

// counter to detect recursion level of method int (used in INTLIB/int.mu
protected(intlibDepthLevel,Error):
// global flag used in definite integration to prevent some simplifications
protected(calledFromWithinDefInt,Error):

// global flag for ode solver, it needs to be global for using save which is
// necessary to be correct if errors/exceptions occurs
protected(calledFromWithinDSolve,Error):

null():
