// Trans.mu  --  library for transformations

transform:= newDomain("transform"):
transform::create_dom:=hold(transform):
transform::info := "Library 'transform': library for integral transformations":
transform::interface := { hold(laplace),hold(invlaplace),
                          hold(fourier),hold(invfourier),
                          hold(ztrans) ,hold(invztrans)
                       // hold(mellin) // raus, da mellin nicht funktioniert
		       }:

alias(path = pathname("TRANS"));

transform::IntTrans:= loadproc( transform::IntTrans, path, "IntTrans" ):

unalias(path):

alias(path = pathname("TRANS","LAPLACE")):

transform::laplace   := loadproc( transform::laplace,  path, "laplace" ):
transform::invlaplace:= loadproc( transform::invlaplace, path, "ilaplace" ):

unalias(path):

//alias(path = pathname("TRANS","FOURIER")):
// use Paul's version from STDLIB until Dirk has fixed/written it. 
alias(path = pathname("TRANS")):

transform::fourier   := loadproc(transform::fourier,    path, "fourier"):
transform::invfourier:= loadproc(transform::invfourier, path, "ifourier"):

unalias(path):

alias(path = pathname("TRANS","ZTRANS")):
transform::ztrans     := loadproc(transform::ztrans,    path, "ztrans"):
transform::invztrans  := loadproc(transform::invztrans, path, "invztrans"):
unalias(path):

alias(path = pathname("TRANS")):
autoload(transform::mellin):

//------------------------------------------------------------------
// Utilities
//------------------------------------------------------------------

autoload(transform::expand):
autoload(transform::TypeLinear):

unalias(path):

prog::setcheckglobals(transform, {_X, _Y}):

null():

