/*++
     addrow.mu

 linalg::addRow()    -- form linear combinations of matrix rows

 addRow(A,p1,p2,s1, s2 = 1)

 A     : matrix, square matrix
 p1,p2 : positive integers
 s1,s2 : any

 After s1, s2 are converted into elements of A::coeffRing, 
 'addRow' returns a copy of matrix A in which row 
 p2 of A is replaced by s1*row(A,p1) + s2*row(A,p2).
++*/

linalg::addRow := proc(A, p1, p2, s1, s2 = 1)
    local R, r1, r2;
begin
    if testargs() then
      if args(0) < 4 or args(0) > 5 then 
         error("expecting 4 or 5 arguments") 
      end_if;
      if A::dom::hasProp( Cat::Matrix ) <> TRUE then
        error("first argument is not of 'Cat::Matrix'")
      end_if;
      if (not testtype( p1,Type::PosInt )) or 
         (not testtype( p2,Type::PosInt )) then
        error("invalid indices")
      end_if;
      R := op( A::dom::matdim(A),1 );
      if p1 > R or p2 > R then
        error("indices larger than upper matrix bound")
      end_if;
      if not testtype(s1,A::dom::coeffRing ) then
        // Konvertierungsstrategie eingebaut 
	// Kai, den 04.05.2004 
        if A::dom::coeffRing::coerce(s1) = FAIL then 
          error("unable to convert ".expr2text(s1))
        end_if;
      end_if;
      if args(0) > 4 and
         not testtype(s2,A::dom::coeffRing ) then
        if A::dom::coeffRing::coerce(s2) = FAIL then 
          error("unable to convert ".expr2text(s2))
        end_if;
      end_if;
    end_if;

    if A::dom::addRow <> FAIL then
       return(A::dom::addRow(args()));
    end_if;

    R:= A::dom::coeffRing;
    if domtype(s1) <> R then s1:= R::coerce(s1) end_if;
    if args(0) > 4 then
       if domtype(s2) <> R then s2:= R::coerce(s2) end_if;
    end_if;

    r1:= A::dom::row(A, p1);
    r2:= A::dom::row(A, p2);
    if args(0) = 4 then
        A::dom::setRow(A, p2, map(r1, R::_mult, s1) + r2);
    else
        A::dom::setRow(A, p2, map(r1, R::_mult, s1) +
                              map(r2, R::_mult, s2));
    end_if;
end_proc:

// end of file 
