/*
    linalg::basis  --  return a set of linear independent vectors
                       over a field

    basis(S)

    S : list or set of vectors

    Removes such vectors in S which are linearly dependent of all
    the other vectors in S.

    The computed set is a basis for the vectorspace spanned by
    the vectors in S.
*/

linalg::basis:= proc(S)
    local i, j, p, k, kk, n, t, R, FS, s, c, Miszero, u, v, l;
begin
    if testargs() then
        if args(0) <> 1 then
            error("expecting one argument")
        elif domtype(S) <> DOM_LIST and domtype(S) <> DOM_SET then
            error("expecting a set or list of vectors")
        end_if;

        if nops(S) = 0 then return( S ) end_if;
        v:= op(S,1);
        if not testtype(v,linalg::vectorOf(Type::AnyType)) then
            error("expecting a set or list of vectors")
        end_if;
        n:= nops(v);
        R:= v::dom::coeffRing;
        if not R::hasProp( Cat::Field ) then
            error("expecting vectors over a 'Cat::Field'")
        elif domtype(S) = DOM_LIST then
            if not testtype( S,Type::ListOf(linalg::vectorOf(R,n)) ) then
                 error("vectors are not compatible")
            end_if
        elif not testtype( S,Type::SetOf(linalg::vectorOf(R,n)) ) then
            error("vectors are not compatible")
        end_if
    end_if;

    s:= [ op(S) ];
    if nops(s) = 0 then return( s ) end_if;

    v:= s[1];
    R:= v::dom::coeffRing;
    Miszero := v::dom::iszero;

    n:= nops(v);
    FS:= [];
    t:= [ NIL $ n ]; 
    p:= 1;
    for i from 1 to nops(s) do
      if Miszero( s[i] ) then next end_if;
      t[p]:= s[i];
      kk:= 1;
      u:= t[p];
      // test whether u is linearly dependent of one of the other vectors:
      for j from 1 to p-1 do
        v := t[j];
        for k from kk to n do
          if R::iszero(u[k]) and not R::iszero(v[k]) then
            break  // u and v are linearly independent 
          end_if;
          if R::iszero(u[k]) then
            next // next k
          end_if;
          kk := k;
          if R::iszero(v[k]) then
            t[j] := u; u := v; t[p] := v;
            break // next j 
          end_if;
          c := R::_negate( R::_divide(u[k],v[k]) );
          u[k] := R::zero;
          (u[l] := R::_plus(u[l],R::_mult(v[l],c))) $ l=k+1..n;
          t[p] := u;
          break // next j
        end_for
     end_for;
     if not Miszero(u) then
       FS := append( FS,s[i] );
       if nops(FS) = n then break end_if;
       p := p + 1
     end_if
   end_for;
   if domtype(S) = DOM_LIST then FS else {op(FS)} end_if
end_proc:

