/*
     linalg::delCol(A,p)           -- delete column p of A
     linalg::delCol(A,i..j)        -- delete columns i to j of A 
     linalg::delCol(A,[i1,i2,...]) -- delete columns i1,i2,... of A
*/

linalg::delCol := proc(A,p)
    local c, i, res;
begin
 if testargs() then
   if args(0) <> 2 then error("expecting 2 arguments") end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   c := op( A::dom::matdim(A),2 );
   if testtype( p,Type::PosInt ) then
     if p > c then
       error("index out of range")
     end_if
   elif type(p) = "_range" then
    if not testtype( op(p,1),Type::PosInt )
    or not testtype( op(p,2),Type::PosInt )
    then
      error("expecting range of positive integers")
    end_if;
    if op(p,1) > c or op(p,2) > c then
      error("range larger than upper matrix bound")
    end_if
   elif testtype(p,Type::ListOf(Type::PosInt,1)) then
     if max(op(p)) > c then
       error("indices in list larger than upper matrix bound")
     end_if
   else
     error("invalid 2nd argument")
   end_if
 end_if;

 if domtype(p) = DOM_INT then
   return( A::dom::delCol(A,p) )
 elif domtype(p) = DOM_LIST then
   c:= [i $ i in p]
 elif op(p,1) > op(p,2) then return( A )
 elif op(p,2) - op(p,1) = op( A::dom::matdim(A),2 ) - 1 then
   return( NIL )
 else
   c:= [i $ i=p ]
 end_if;
 
 res:= A::dom::concatMatrix( op( eval(subsop(
        [A::dom::col(A,i) $ i=1..A::dom::matdim(A)[2]],op(map(c,_equal,hold(null)()))
        )) ) );
        
 if res = null() then 
   return(NIL);
 else 
   return(res);   
 end_if;   
end_proc:
