/*
     linalg::delRow(A,p)           -- delete row p of A
     linalg::delRow(A,i..j)        -- delete rows i to j of A
     linalg::delCol(A,[i1,i2,...]) -- delete rows i1,i2,... of A
*/

linalg::delRow := proc(A,p)
    local i, r, res;
begin
 if testargs() then
   if args(0) <> 2 then error("expecting 2 arguments") end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   r:= A::dom::matdim(A)[1];
   if testtype( p,Type::PosInt ) then
     if p > r then
       error("index out of range")
     end_if
   elif type(p) = "_range" then
     if not testtype( op(p,1),Type::PosInt )
     or not testtype( op(p,2),Type::PosInt )
     then
       error("expecting range of positive integers")
     end_if;
     if op(p,1) > r or op(p,2) > r then
       error("range larger than upper matrix bound")
     end_if
   elif testtype(p,Type::ListOf(Type::PosInt,1)) then
     if max(op(p)) > r then
       error("indices in list larger than upper matrix bound")
     end_if
   else
     error("expecting an integer or range of integer")
   end_if
 end_if;

 if domtype(p) = DOM_INT then
   return( A::dom::delRow(A,p) )
 elif domtype(p) = DOM_LIST then
   r:= [i $ i in p]
 elif op(p,1) > op(p,2) then return( A )
 elif op(p,2) - op(p,1) = op( A::dom::matdim(A),1 ) - 1 then
   return( NIL )
 else
   r:= [i $ i=op(p,1)..op(p,2)]
 end_if;

 res:= A::dom::stackMatrix( op(eval(subsop( 
       [A::dom::row(A,i) $ i=1..A::dom::matdim(A)[1]],op(map(r,_equal,hold(null)())) 
       ))) );
       
 if res = null() then 
   return(NIL);
 else
   return(res);
 end_if;
end_proc:

