// Gauss-Jordan variant of the single step fraction free Gauss elimination

linalg::ffGaussJordan := 
 proc(x)
   // option remember;
 local n, m, i, j, l, f, f0, r, k, p, l0, ps, sig, charind, 
       R, Mat, Rnormal, Rzero, Rone, mydivide, vars, polyRing, opt;
begin
  if args(0) < 1 then error("expecting one argument") end_if;
  opt:= args(2 .. args(0));
  Mat:= x::dom;
  if Mat::hasProp(Cat::Matrix) <> TRUE then
    error("expecting a matrix of 'Cat::Matrix'");
  end_if;
  R:= x::dom::coeffRing;
  if Mat::constructor <> Dom::Matrix then 
    // Convert the matrix into a matrix over Dom::Matrix
    x:= Dom::Matrix(R)(x);
  end_if;
  m:= extop(x,1); // number of rows
  n:= extop(x,2); // number of columns
  Rnormal:= (if R = Dom::ExpressionField() then
                x -> normal(x, Expand = FALSE, opt); 
             elif R::normal <> FAIL then 
                normal; // normal should be overloaded by R::normal
             else id 
             end_if);
  Rzero:= R::zero;
  Rone:= R::one;
  mydivide:= (x, y) -> Rnormal(x/y, opt);

  // Special case: with the flag "UsePoly", the exact divisions 
  // of the fraction free Gauss algo are done via divide(.., Quo) 
  // to avoid the use of Rnormal:
  if has([args()], "UsePoly") then
     vars:= [];
     polyRing:= Expr;
     for i from 1 to nops(x) do
       if domtype(op(x, i)) = DOM_POLY then
          vars:= op(x, [i, 2]);
          polyRing:= op(x, [i, 3]);
          break;
       end_if;
     end_for;
     if nops(vars) = 0 then 
       vars:= [genident("x")]; 
     end_if;
     Rnormal:= () -> args(1):
     mydivide:= (x, y) -> (if iszero(x) then return(x) end_if;
                           return(x/y);
                           divide(x, y, Exact)):
     Rzero:= poly(Rzero, vars, polyRing);  
     Rone:= poly(Rone, vars, polyRing);
  end_if:

  ps:= R::pivotSize; // if ps = FAIL then no pivot strategy will be used, otherwise
                     // the pivot in respect to < will be choosen
  userinfo(1,"perform 1-step fraction free Gaussian elimination");
  sig:= 1;      // the sign of the determinant
  charind:= {k $ k = 1..n}; // the characteristic column indices


  //=====================================================
  // start of single-step fraction free Gauss elimination
  //=====================================================
  f0:= Rone;  // the determinant
  r:= 1; 
  for k from 1 to n do
      // We are eliminating an m x n matrix:
      // k is the index of the column that
      // we are presently eliminating.
      // r is the index of the row that is
      // used the elimination 
      if r > m then 
          break 
      end_if;

      //=============
      // pivot search
      //=============
      userinfo(2,"searching for pivot element in row/column ",r,k);
      p:= m + 1; 
      l0:= FAIL; // initial value
      for i from r to m do
          if linalg::zeroTest(x[i,k]) = FALSE then
              if ps = FAIL then 
                p:= i; 
                break
              elif l0 = FAIL then 
                l0:= ps(x[i,k]); 
                p:= i
              elif (l:= ps(x[i,k])) < l0 then 
                l0:= l; 
                p:= i 
              end_if
          end_if
      end_for;
      if p > m then  // no pivot element found
        charind:= charind minus {k};
        next;
      end_if;
      // move pivot element into r-th row
      if r <> p then 
         userinfo(3,"swap rows ",r,p);
         x:= x::dom::swapRow(x, r, p);
         sig:= -sig
      end_if;
      //==============
      // pivoting done
      //==============

     for i from 1 to m do
       if i = r then next; end_if;
       f:= -x[i,k];
       for j from 1 to k-1 do
         // The following code does nothing but
         // x[i,j]:= mydivide((x[r,k] * x[i,j] + x[r,j] * f), f0);
         // Since x[r,j] = 0 for j = 1..k-1, this simplifies to
         // x[i,j]:= mydivide(x[r,k] * x[i,j], f0);
         // Further, most of the elements x[i,j] are zero,
         // many coincide with f0:
         if linalg::zeroTest(x[i,j]) = FALSE then 
           if x[i, j] = f0 then
              x[i,j]:= x[r, k];
           else
              x[i,j]:= mydivide(x[r,k] * x[i,j], f0);
           end_if:
         end_if:
       end_for;
       x[i,k]:= Rzero;
       for j from k+1 to n do
         x[i,j]:= mydivide((x[r,k] * x[i,j] + x[r,j] * f), f0);
       end_for;
     end_for;

     f0:= x[r,k]; 
     r:= r + 1
  end_for;
  // ============================================
  // end of single-step fraction free elimination
  // ============================================

  charind:= charind minus {l $ l = k..n};
  r:= r - 1;
  if n = m then
     if r = m then 
        if sig = -1 then 
           f0:= -f0 
        end_if;
     else 
        f0:= Rzero
     end_if;
  end_if;
  return([x, r, f0, charind, sig])
end_proc:

