/*
    linalg::gaussElim  --  two-step fraction-free Gaussian elimination

    gaussElim(A)     - returns A in upper triangular form
    gaussElim(A,All) - returns [A,rank(A),det(A),ci] where A is in
                       upper triangular form and ci is the set of
                       characteristic column indices of A.
*/

linalg::gaussElim := proc(A)
begin
    if testargs() then
      if args(0) < 1 or args(0) > 2 then 
        error("expecting 1 or 2 arguments")
      end_if;
    if A::dom::hasProp( Cat::Matrix ) <> TRUE then
      error("first argument is not of 'Cat::Matrix'")
    end_if;
    if not (A::dom::coeffRing)::hasProp( Cat::IntegralDomain ) then
      error("expecting matrix over 'Cat::IntegralDomain'")
    end_if;
    if args(0) = 2 then
      if args(2) <> hold(All) then
        error("expecting 'All' as option")
      end_if
    end_if
  end_if;
  if args(0) >= 2 and 
     args(2) = All then 
      A::dom::gaussElim(A) 
  else 
      op( A::dom::gaussElim(A),1 ) 
  end_if
end_proc:

