//      

/*
        linalg::hessian -- computes the hessian of a scalar function over fields

        hessian(x,m)

        x       : expression (the scalar function)
        m       : list of (indexed) identifiers

        This function computes the hessian of 'x'. 
        linalg::hessian operates on the cartesian coordinate system. 
        Hence the result is the matrix jacobian(grad(x,m)[i],m[j]),
        where i,j range over the length of 'm'.
*/

linalg::hessian:= proc( f,x )
begin
    if testargs() then
        if args(0) <> 2 then error("expecting 2 arguments") end_if;
        if not testtype(f,Type::Arithmetical) then
            error("1st argument must be of type 'Type::Arithmetical'")
        elif not testtype( x,Type::ListOf(Type::Unknown) ) then
            error("2nd argument must be a list of (indexed) identifiers")
        end_if
    end_if;

    return( linalg::jacobian( linalg::grad(f,x),x ) )
end_proc:

