/*
        linalg::isHermitean -- test for Hermitean matrices

        isHermitean(A)

        A: square matrix

        linalg::isHermitean(A) returns TRUE if A is Hermitean and FALSE
        otherwise. A is a Hermitean matrix iff conjugate(transpose(A))=A.
        For real matrices A is tested to be symmetric.
*/

linalg::isHermitean := proc(A)
    local tmp;
begin
    if testargs() then
        if args(0) <> 1 or A::dom::hasProp( Cat::Matrix ) <> TRUE then
            error("expecting a square matrix of 'Cat::Matrix'")
        end_if;
        tmp:= A::dom::matdim(A);
        if tmp[1] <> tmp[2] then
            error("not a square matrix")
        end_if
    end_if;

    tmp:= A::dom;
    tmp::equal( A,tmp::transpose(tmp::conjugate(A)) )
end_proc:

