/*
        linalg::isUnitary -- tests for unitary matrices

        isUnitary(A)

        A: square matrix

        This function tries to find out if A is unitary.

        Matrix A is orthogonal iff A^(-1) = transpose(conjugate(A)). This is 
        equivalent to the fact that the columns of A build an orthonormal system 
        (in respect to the scalar product defined by linalg::scalarProduct).
        
        Note that one can only be sure that A is not an unitary matrix
        if the axiom 'canonicalRep' is stated for the coefficient domain 
        of A. In respect to axiom 'canonicalRep' is stated or not, FALSE
        and UNKNOWN is returned, respectively.

        The coefficient domain of A has to be an integral domain.
*/

linalg::isUnitary:= proc(A)
    local i, j, n, R, c, col, ret, scalarProduct, Riszero, 
          Rone, Requal, Rzero;
begin
    if testargs() then
        if args(0) <> 1 then
            error("expecting one argument")
        elif A::dom::hasProp( Cat::Matrix ) <> TRUE then
            error("argument is not of 'Cat::Matrix'")
        elif not (A::dom::coeffRing)::hasProp( Cat::IntegralDomain ) then
            error("expecting matrix over 'Cat::IntegralDomain'")
        end_if
    end_if;
   
    n:= A::dom::matdim(A);
    if n[1] <> n[2] then 
        error("not a square matrix")
    end_if;

    R:= A::dom::coeffRing;

    scalarProduct:= linalg::scalarProduct;
    col:= A::dom::col;
    Requal:= R::equal;
    Rone:= R::one;
    Rzero:= R::zero;
    Riszero:= R::iszero;
    scalarProduct:= linalg::scalarProduct;

    n:= n[1];
    c:= [FAIL $ n]; // the columns of A
    for i from 1 to n do
      for j from i to n do
        if c[j] = FAIL then c[j]:= col(A,j) end_if;
        if (ret:= Requal( scalarProduct( c[i],c[j] ), if i=j then Rone else Rzero end_if)) 
           <> TRUE then
          if ret = FALSE then
             return(FALSE)
          end_if:
          if type(ret) <> "_equal" then
           return(UNKNOWN);
          end_if;
          if traperror((ret:= bool(ret))) <> 0 then
             return(UNKNOWN)
          end_if;
          if ret = FALSE then
             return(FALSE)
          end_if:
        end_if:
      end_for
    end_for;
    return( TRUE )
end_proc: 

