//
// Kai Gehrs, 02/10/03

/*
linalg::kroneckerProduct --  Kronecker product of 2 matrices

Calls:      kroneckerProduct(A, B)

Parameters: A, B - matrices of the same type Dom::Matrix(R)

ReturnValue:  a Dom::Matrix(R) of dimension mA*mB x nA*nB, where 
              [mA, nA] = A::dom::matdim(A), 
              [mB, nB] = B::dom::matdim(B).

Details:
 * The Kronecker product AB of A and B is the matrix

     [ A[1,1]*B , A[1,2]*B, ...]
     [ A[2,1]*B , A[2,2]*B, ...]
     [   ...    ,   ...   , ...]

   In components:

     AB[mB*(iA - 1) + iB, nB*(jA - 1) + jB] =  A[iA, jA] * B[iB, jB],
    
   with  iA = 1..mA, iB = 1..mB, jA = 1..nA, jB = 1..nB.
*/

linalg::kroneckerProduct:= proc(A,B)
    local AA, BB;
begin
 if args(0) > 2 then
    return(dom::kroneckerProduct(A::dom::kroneckerProduct(A, B), args(3..args(0))));
 end_if;
 if testargs() then
   if args(0) < 1 then
      error("expecting at least one argument"):
   end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   if args(0) = 1 then
      return(A);
   end_if;
   if B::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("second argument is not of 'Cat::Matrix'")
   end_if;
 end_if;
 if args(0) = 1 then
    return(A);
 end_if;
 if A::dom = B::dom then 
   if A::dom::kroneckerProduct = FAIL then 
      error("Kronecker product not implemented for the first argument");
   end_if;
   return(A::dom::kroneckerProduct(A,B));
 end_if;
 if (BB:= A::dom::coerce(B)) <> FAIL then 
    if A::dom::kroneckerProduct = FAIL then 
       error("Kronecker product not implemented for the first argument");
    end_if;
    return(A::dom::kroneckerProduct(A, BB));
 end_if; 
 if (AA:= B::dom::coerce(A)) <> FAIL then 
   if B::dom::kroneckerProduct = FAIL then 
     error("Kronecker product not implemented for the second argument");
   end_if;
   return(B::dom::kroneckerProduct(AA,B));
 end_if;
 error("cannot convert the factors to a common matrix domain"):
end_proc:

