/*
 linalg::normalize -- normalizes vectors over fields
                      using the 2-norm

 normalize(v)

 v: vector

 This function normalizes v. An error occurs if v
 can not be normalized over its component ring.
*/

linalg::normalize:= proc(x)
    local n;
begin
 if testargs() then
   if args(0) <> 1 then error("expecting 1 argument") end_if;
   if not testtype( x,linalg::vectorOf(Type::AnyType) ) then
     error("expecting a vector")
   end_if;
   if not (x::dom::coeffRing)::hasProp( Cat::Field ) then
     error("expecting a vector over 'Cat::Field'")
   end_if
 end_if;

 n:= x::dom::norm(x,2);
 if n = FAIL or (n:= x::dom::coeffRing::coerce(n)) = FAIL then
   error("can't normalize given vector over its component ring")	
 else
   x::dom::_mult(x,1/n)
 end_if
end_proc:

