/*
    linalg::orthog  --  returns an orthogonal system of vectors

 orthog( S )

 S : list or set of vectors

 Orthogonalize the vectors in S using the Gram-Schmidt process.

 The vectors must be of same dimensions and defined over a field. 
*/

linalg::orthog:= proc(S)
    local R, s, OS, bi, bj, aj, scalarProduct,
   Riszero, viszero, vplus, Rmult, Rnegate, Rdivide, MatrixOutput, i;
begin
    if args(0) <> 1 then error("expecting one argument") end_if;
    OS:= Type::ListOf;
    MatrixOutput:= FALSE;
    case domtype(S)  
    of DOM_SET  do 
      OS:= Type::SetOf
    of DOM_LIST do
      if nops(S) = 0 then return( S ) end_if;
      bi:= op(S,1);
      if not testtype( bi,linalg::vectorOf(Type::AnyType) ) then
        error("expecting list or set of vectors")
      end_if;
      R:= bi::dom::coeffRing;
      if not R::hasProp( Cat::Field ) then
        error("expecting vectors over a 'Cat::Field'")
      end_if;
      s:= max( op(bi::dom::matdim(bi)) );
      if not testtype( S,OS(linalg::vectorOf(R,s)) ) then
        error("vectors are not compatible")
      end_if;
      break
    otherwise
      if S::dom::hasProp(Cat::Matrix) then 
        S:= [linalg::col(S, i) $ i = 1..linalg::matdim(S)[2]];
        MatrixOutput:= TRUE;
      else 
        error("expecting a matrix, a list or a set of vectors")
      end_if;
    end_case;

  if nops(S) = 0 then return( S ) end_if;

  aj:= S[1];
  vplus:= aj::dom::_plus;
  viszero:= aj::dom::iszero;
  R:= aj::dom::coeffRing;
  Rmult:= R::_mult;
  Riszero:= R::iszero;
  Rnegate:= R::_negate;
  Rdivide:= R::_divide;
  scalarProduct:= linalg::scalarProduct;

  if domtype( S ) = DOM_LIST then delete S[1] else S:= S minus {aj} end_if;
  OS:= [aj];

  for aj in S do
    bj:= aj;
    for bi in OS do
      s:= scalarProduct(bi,bi);
      if Riszero( s ) then next end_if;
        s:= Rnegate( Rdivide(scalarProduct(aj,bi),s) );
      if not Riszero( s ) then
        bj:= vplus( bj,map( bi,Rmult,s ) )
      end_if
    end_for;
    if not viszero(bj) then OS:= append( OS,bj ) end_if
  end_for;
  
  if MatrixOutput = TRUE then 
  // Note that in this case we always have a list of 
  // vectors. 
    return(linalg::concatMatrix(OS[i] $ i = 1..nops(OS)))  
  end_if;
  
  if domtype(S) = DOM_LIST then OS else {op(OS)} end_if

end_proc:

