/*++
  rank.mu

 linalg::rank - compute the rank of a matrix over an 
                integral domain

 rank( A )
 rank( S )

 A - matrix over an integral domain
 S - set or list of vectors defined over an integral domain

 rank(A) computes the rank of A.
 rank(S) computes the rank of the matrix which has
         the vectors in S as its columns.
++*/

linalg::rank := proc(x)
  local op1, r;
begin
 if testargs() then
   if args(0) <> 1 then error("expecting one argument") end_if;
   if x::dom::hasProp( Cat::Matrix ) <> TRUE then
     case domtype(x)
     of DOM_SET do
       if nops(x) = 0 then break end_if;
       op1 := op(x,1);
       if op1::dom::coeffRing::hasProp(Cat::IntegralDomain) <> TRUE then
         error("expecting vectors over an integral domain")
       elif not testtype( x,Type::SetOf( linalg::vectorOf( op1::dom::coeffRing,nops(op1))) ) then
         error("incompatible vectors")
       end_if;
       break
     of DOM_LIST do
       if nops(x) = 0 then break end_if;
       op1 := op(x,1);
       if op1::dom::coeffRing::hasProp(Cat::IntegralDomain) <> TRUE then
         error("expecting vectors over an integral domain")
       elif not testtype( x,Type::ListOf( linalg::vectorOf( op1::dom::coeffRing,nops(op1))) ) then
         error("incompatible vectors")
       end_if;
       break
     otherwise
       error("expecting a matrix or a set or list of vectors")
     end_case
   elif not x::dom::coeffRing::hasProp(Cat::IntegralDomain) then
     error("expecting matrix over 'Cat::IntegralDomain'")
   end_if
 end_if;

 if domtype(x) = DOM_LIST or 
    domtype(x) = DOM_SET then
   if nops(x) = 0 then 
      return(0) 
   else 
      op1 := op(x,1);
      return(op(op1::dom::gaussElim(_concat(op(x))),2 ));
   end_if
 end_if;
 if (x::dom = matrix or x::dom = densematrix) and
    (r:= linalg::symbolicRank(x)) <> FAIL then
    return(r)
 end_if;
 return(op( x::dom::gaussElim(x),2 ));
end_proc:

// end of file 
