/*
 linalg::setCol(A,p,c)  --  sets column p of A to column c

 A: matrix
 c: expression
 p: positive integer
*/

linalg::setCol := proc(A,p,c)
    local T;
begin
 if testargs() then
   if args(0) <> 3 then error("expecting 3 arguments") end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   if not testtype( p,Type::PosInt ) then
     error("index must be a positive integer")
   end_if;
   if p > op( A::dom::matdim(A),2 ) then
     error("index out of range")
   end_if
 end_if;

 T:= A::dom;
 if T::constructor = Dom::SquareMatrix then T:= T::getSuperDomain() end_if;
 if T <> domtype(c) then c:= T::coerce(c) end_if;
   if c = FAIL then
     error("invalid column vector")
   elif c::dom::matdim(c) <> [A::dom::matdim(A)[1],1] then
     error("colunm vector has an invalid dimension")
   else
     A::dom::setCol( A,p,c )
   end_if
end_proc:

