/* symbolicDet -- a special procedure to compute the determinant of matrices 
                  with many symbolic coeffcients  
             
   PARAMETERS: 

   -- M, a square matrix

   REFERENCE:
   
   Efficient Gaussian Elimination Method for Symbolic
   Determinants and Linear Systems, T. Sasaki, H. Murao, 
   ACM Transactions on Mathematical Software, Vol. 8, 
   No. 3, September 1982, Pages 228-289. 

   The algorithm makes use of the subroutine 'linalg::otimes'.
*/

linalg::symbolicDet:= proc(M) 
        local m, n, nm2, A, X1X2ETC, R, Q, prod, sig, k, i, j;
      begin
        m:= M::dom::matdim(M)[1];
        n:= M::dom::matdim(M)[2];
        if m <> n then 
          error("expecting a square matrix");
        end_if;
        // Special Cases for 1x1 and 2x2 matrices
        if n = 2 then 
          return(expand(M[1,1] * M[2,2] - M[1,2] * M[2,1]));
        elif n = 1 then 
          return(M[1,1]);
        end_if;
        nm2:= n - 2;
        A:= [M[k,k] $ k = 1..nm2];
        for k from 1 to nm2 do 
          M[k,k]:= `#X`[k];
        end_for;
        M:= map(M, poly, [`#X`[j] $ j = 1..nm2]);
        for k from 1 to n - 1 do 
          if k = 1 then 
            Q:= poly(1, [`#X`[j] $ j = 1..nm2]);
          else
              X1X2ETC:= poly( _mult(`#X`[i] $ i = 1..k-1), [`#X`[j] $ j = 1..nm2]);
              R:= M[k-1,k-1] - X1X2ETC;
              Q:= X1X2ETC - R;
              sig:= 1;
              prod:= R;
              while not iszero(prod) do
                prod:= linalg::otimes(prod, R, 1, k-1, nm2); 
                if iszero(prod) then
                   break;
                end_if;
                if sig = 1 then
                   Q:= Q + prod
                else
                   Q:= Q - prod
                end_if;
                sig:= -sig;
              end_while;
          end_if;
          for i from k+1 to n do 
            for j from k+1 to n do
              M[i,j]:= linalg::otimes( linalg::otimes(M[k,k], M[i,j], 1, k-1, nm2)
                              -linalg::otimes(M[i,k], M[k,j], 1, k-1, nm2),
                              Q, 1, k-1, nm2);
            end_for;
          end_for;
        end_for;
        return(expand(subs(extop(M[n,n], 1), `#X`[k] = A[k] $ k = 1..nm2)));
      end_proc:


