/* 
symbolicDet_Fu -- a special procedure to compute the 
   determinant of matrices with many symbolic coefficients

   PARAMETERS:

     -- M, a square matrix

   REFERENCE:

     Modified Gauss Algorithm for Matrices with Symbolic Entries,
     B. Fuchssteiner, ACM Communications in Computer Algebra, 42(3),
     3. September 2008

   The algorithm makes use of the subroutine 'linalg::otimes_Fu'
*/

//=======================================================
linalg::symbolicDet_Fu:= proc(M)
local m, n, MList, i, j, k, jj, P, PP, det;
begin
  [m, n]:= M::dom::matdim(M);
  if m <> n then
     error("expecting a square matrix");
  end_if;
  // Special Cases for 1x1 and 2x2 matrices
  if n = 1 then
     return(M[1,1]);
  elif n = 2 then
     return(expand(M[1,1]*M[2,2] - M[1,2]*M[2,1]));
  end_if;
  M:= array(1..n, 1..n, [op(M)]);
  MList:= [0 $ n]:
  for k from 1 to n-1 do
    MList[k]:= M[k, k];
    for i from k+1 to m do
      P := poly(M[i,k],  [#Z[jj] $ jj = 0..k-1]);
      for j from k+1 to n do
        PP:= poly(M[k,j], [#Z[jj] $ jj = 0..k-1]);
        M[i,j]:= M[i,j] - #Z[k]*linalg::otimes_Fu(P,PP, 1, k-1);
      end_for:
    end_for;
    for j from k+1 to n do
      M[k, j]:= #Z[k]*M[k, j];
    end_for:
  end_for;
  MList[n]:= M[n, n];
  det:= M[n,n];
  for k from n-1 downto 1 do
    det:= poly(det, [#Z[k]]); // this is important for efficiency!!!
    det:= MList[k]*coeff(det, #Z[k], 0) + coeff(det, #Z[k], 1);
  end_for:
  return(expand(det, ArithmeticOnly));
end_proc:
