/*++
      Domain eines min-heaps.
      Ein Heap besteht aus einem table extop(H,1) mit den Eintraegen
      (indiziert wird von 1 an) und der derzeitigen Elementanzahl extop(H,2) 
++*/

alias(Heap = linopt::Heap):
alias(Heap_node = (linopt::Heap)::Heap_node):
alias(vater(i) = trunc(i/2)):
alias(leftson(i) = _mult(i,2)):



    Heap::new		:=	proc()							// neuer Heap 
				local	F;

				begin
				  F:= table();
				  return(new(Heap,F,0)):				// Field and number 
				end_proc:

    Heap::up		:= 	proc(F,ind,elem)					// erledigt den up-heap 
				local i;

				begin
				  i := ind:
				  while(i>1 and elem < F[vater(i)]) do
				    F[i] := F[vater(i)]:
				    i := vater(i):
				  end_while:
				  F[i] := elem:
				  return(F):
				end_proc:

    Heap::up_bound	:= 	proc(F,ind,elem,N)					 /* variante von up: beim Aufsteigen
											  werden die passierten Elemente darauf
											  ueberprueft, ob sie einen Wert >= N
											  darstellen; falls dies der Fall ist,*/

				local i;

				begin
				  i := ind:
				  while(i>1 and F[vater(i)] >= N and elem < F[vater(i)]) do
				    F[i] := Heap_node::dispose(F[vater(i)]):
				    i := vater(i):
				  end_while:
				  while(i>1 and elem < F[vater(i)]) do
				    F[i] := F[vater(i)]:
				    i := vater(i):
				  end_while:
				  F[i] := elem:
				  return(F):
				end_proc:



    Heap::down		:=	proc(F,anz,ind,elem)					//  erledigt den down-heap 
				local i,j;

				begin
				  i := ind:
				  j := leftson(i):
				  while(j <= anz and (F[j] < elem or j+1<=anz and F[j+1] < elem)) do
				    if j < anz and F[j+1] < F[j] then j := j+1 end_if:
				    F[i] := F[j]:
				    i := j:
				    j := leftson(i)
				  end_while:
				  F[i] := elem:
				  return(F)
				end_proc:

    Heap::down_botup	:=	proc(F,anz,ind,elem)					/* down-heap mit der Strategie
												  "bottom-up" */
				local i,j;

				begin
				  i := ind:
				  j := leftson(i):
				  while(j < anz) do
				    if F[j+1] < F[j] then j := j+1 end_if:
				    F[i] := F[j]:
				    i := j:
				    j := leftson(i)
				  end_while:
				  if j = anz
				  then if F[j] < elem 
				       then F[i] := F[j]: F[j] := elem: return(F) 
				       else return(Heap::up(F,i,elem))
				       end_if
				  end_if:
				  return(Heap::up(F,i,elem))
				end_proc:

 
    Heap::ins		:= 	proc(H,value, cont)					// insert 

				begin
				  return(new(Heap,Heap::up(extop(H,1),extop(H,2)+1,Heap_node(value,cont)),extop(H,2)+1))
				end_proc:

    Heap::ins_bound	:=	proc(H,value,cont,N)					/* variante von ins: falls das letzte
											  Element einen Wert >= N hat, wird es
											  ueberschrieben */


				begin
				  if extop(H,2) > 0 and extop(H,1)[extop(H,2)] >= N 
				  then return(new(Heap,Heap::up_bound(extop(H,1),extop(H,2),Heap_node(value,cont),N),extop(H,2)))
				  else return(new(Heap,Heap::up_bound(extop(H,1),extop(H,2)+1,Heap_node(value,cont),N),extop(H,2)+1))
				  end_if
				end_proc:

    Heap::del_min	:=	proc(H)							/* delete_minimum, benutzt "down_heap"
											  mit bottom-up-strategie */

				begin
				  if Heap::empty(H) then return(H) end_if:
				  return(new(Heap,Heap::down_botup(extop(H,1),extop(H,2)-1,1,extop(H,1)[extop(H,2)]),extop(H,2)-1))					
				end_proc:

    Heap::del_ins	:=	proc(H,value,cont)					/* delete_insert: erst delete_minimum,
											  dann insert(elem); geht schneller als
											  Einzelaufrufe, benutzt normales "down_heap" */

				begin
				  if Heap::empty(H) then return(Heap::ins(H,value,cont)) end_if:
				  return(new(Heap,Heap::down(extop(H,1),extop(H,2),1,Heap_node(value,cont)),extop(H,2)))
				end_proc:

    Heap::empty		:=	proc (H)
				begin
				  if extop(H,2) = 0 or Heap_node::content(extop(H,1)[1]) = "" then TRUE else FALSE end_if
				end_proc:

    Heap::mini		:=	proc (H)						// minimum 
				begin
				  if not Heap::empty(H) then return(Heap_node::content(extop(H,1)[1]))
				  else return( NIL ) 
				  end_if
				end_proc:

    Heap::print		:=	proc(H)
				local i,j,m,n,A;

				begin
				  if extop(H,2) = 0 then return(null()) end_if:

			          m := floor(ln(extop(H,2))/ln(2))+1: n := 2^m-1:
				  A := array(1..m,1..n):
				  for i from 1 to m do
				      for j from 1 to n do
					A[i,j]:= "_"
				      end_for
				  end_for:

				  for i from 1 to m do
				      for j from 1 to 2^(i-1) do
					if 2^(i-1)+j-1 <= extop(H,2) 
					then A[i,floor(2^(m-i)*(2*j-1))] := extop(H,1)[2^(i-1)+j-1] 
					else break
					end_if
				      end_for
				  end_for:	

				  A
				end_proc:
				
unalias(vater):
unalias(leftson):
unalias(Heap):
unalias(Heap_node):
