//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
newequ.mu --  insert a new restriction x = a in Tableau T
++*/ 

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):

Tableau::newequation	:=	proc(T,k,a,pivotel)

/* Eingabe: Tableau T, Zeilenindex k, konstanter Teil der Gleichung und erstes Pivotelement der Reoptimierung
  Ausgabe: das komplette neue Tableau
*/

				local piv,
                  j,i,						// Laufvariable			
				      v,						// Variable zu Zeile i		
				      tbl,n,m,/*insertedvars,*/equations,//scrollanz,
				      interval,/*assoziated,integer,internalorder,*/	// Tablaukomponenten		
				      newtbl						// Neue Tableaukomponente tbl	
				      /*piv2*/						// weitere Pivotvariable		
				      /*mini*/;						// zur Berechnung von piv2	

				begin

              piv:=pivotel;
				  tbl := T[1]:
				  m := T[2]:
				  n := T[3]:
				  equations := T[5]:
				  interval := T[9]:

				  v := tbl[k,1]:

				  if interval[v,"greater"] <> UNKNOWN and 
				     (0 > a or interval[v,"lower"] <> UNKNOWN and interval[v,"lower"] < a) or
				     T[12][v] and not testtype(a,DOM_INT)
				    then return({}) 
				  end_if:

				  newtbl := array(1..m+2,1..n+1):

				  if interval[v,"greater"] = TRUE
				    then tbl := assignElements(tbl,[[k,j],-tbl[k,j]]$ j=3..n+2):
				         tbl[k,2] := interval[v,"lower"]-tbl[k,2]:
					 interval[v,"greater"] := FALSE
				  end_if:

				  tbl[k,2] := tbl[k,2]-a:

				      piv := append(piv,tbl[piv[1],piv[2]]):

				      newtbl := assignElements(newtbl,[[piv[1],j],tbl[piv[1],j]/piv[3]]$ j=2..piv[2]-1,
							[[piv[1],j],tbl[piv[1],j+1]/piv[3]]$ j=piv[2]..n+1):

				      interval[v,"greater"] := a:
				      interval[v,"lower"] := a:
				      equations := {(op(equations,[i,1]) = subs(op(equations,[i,2]),{v=a}))$ i=1..nops(equations)} union {v = a}:

	 	 		      newtbl := assignElements(newtbl,([[i,j],tbl[i,j]-tbl[i,piv[2]]*newtbl[piv[1],j]]$ j=2..piv[2]-1,
						                     [[i,j],tbl[i,j+1]-tbl[i,piv[2]]*newtbl[piv[1],j]]$ j=piv[2]..n+1)
							            $ i=2..piv[1]-1,
						                    ([[i,j],tbl[i,j]-tbl[i,piv[2]]*newtbl[piv[1],j]]$ j=2..piv[2]-1,
						                     [[i,j],tbl[i,j+1]-tbl[i,piv[2]]*newtbl[piv[1],j]]$ j=piv[2]..n+1)
							            $ i=piv[1]+1..m+2,

							             [[1,j],tbl[1,j]]$ j=1..piv[2]-1,
								     [[1,j],tbl[1,j+1]]$ j=piv[2]..n+1,
								     [[i,1],tbl[i,1]]$ i=2..piv[1]-1,
								     [[piv[1],1],tbl[1,piv[2]]],
								     [[i,1],tbl[i,1]]$ i=piv[1]+1..m+2):

				  return(new(Tableau,newtbl,m,n-1,T[4],equations,T[6],T[7],T[8],interval,T[10],T[11],T[12]))

				end_proc:
unalias(Tableau):
unalias(Heap):
