//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
newupper.mu -- insert a new upper bound b in tableau T for the variable in row i
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):

Tableau::newupperbound	:=	proc(T,i,b)

/* Eingabe: Tableau T, Zeilenindex i, obere Schranke b
  Ausgabe: das komplette neue Tableau
*/

				local j, 						// Laufvariable			
				      v,						// Variable zu Zeile i		
				      tbl,n,insertedvars,equations,scrollanz,
				      interval,assoziated,integer,internalorder;	// Tablaukomponenten		

				begin
				  tbl := T[1]:
				  n := T[3]:
				  insertedvars := T[4]:
				  equations := T[5]:
				  scrollanz := T[8]:
				  interval := T[9]:
				  assoziated := T[10]:
				  internalorder := T[11]:
				  integer := T[12]:

				  v := tbl[i,1]:

				  if interval[v,"greater"] = UNKNOWN
				  then scrollanz := scrollanz+1:
				       tbl := assignElements(tbl,[[i,1],linopt::scr[scrollanz]],[[i,2],b-tbl[i,2]],([[i,j],-tbl[i,j]])$ j=3..n+2):
				       interval[linopt::scr[scrollanz],"greater"] := 0:
				       interval[linopt::scr[scrollanz],"lower"] := UNKNOWN:
				       integer[linopt::scr[scrollanz]] := integer[v]:
				       interval[v,"lower"] := b:
				       equations := {op(equations,[i,1]) = 
							subs(op(equations,[i,2]),{v = -linopt::scr[scrollanz]+b})$ i=1..nops(equations)} 
						    union {v = -linopt::scr[scrollanz]+b}:
				       assoziated[linopt::scr[scrollanz]] := [-1,v,b]:
				       insertedvars := insertedvars union {linopt::scr[scrollanz]}:
				       internalorder[linopt::scr[scrollanz]] := internalorder[v]:
				       return(new(Tableau,tbl,T[2],n,insertedvars,equations,T[6],T[7],
							scrollanz,interval,assoziated,internalorder,integer))
				  elif interval[v,"lower"] = UNKNOWN
				    then interval[v,"greater"] := FALSE:
					 interval[v,"lower"] := b:
					 return(new(Tableau,tbl,T[2],n,insertedvars,equations,T[6],T[7],
							scrollanz,interval,assoziated,internalorder,integer))
				    else if interval[v,"greater"] then tbl := assignElements(tbl,[[i,2],tbl[i,2]+b-interval[v,"lower"]]) end_if:
					 interval[v,"lower"] := b:		 
					 return(new(Tableau,tbl,T[2],n,insertedvars,equations,T[6],T[7],
							scrollanz,interval,assoziated,internalorder,integer))
				  end_if
				end_proc:

unalias(Tableau):
unalias(Heap):
