//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
pivot1.mu -- get arbitrary pivot for phase I
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):



Tableau::pivot1:=
proc(tbl,m,n,interval,ii)

// Eingabe: Tableaukomponenten tbl,m,n,interval und der Index i der Zeile,
// ab der fuer alle unteren Zeilen schon Zulaessigkeit bekannt ist.
//
// Ausgabe: Pivotelement [i,j,tbl[i,j],upperboundpivot]
 
  local i,
  j,		      // Laufvariable Spalten			
  k,		      // Pivotzeile				
  fixk,		   // gedachte Zielfunktionszeile		
  l,		      // Pivotspalte				
  mini,		   // Bestimmung Pivotzeile:  kleinster Quotient			
  intervalpiv;	// Pivotschritt um beidseitig beschraenkte Variable?		
  
begin
  i:=ii;
  userinfo(8," Entering Tableau::pivot1 "):
  l:=0:
  k:=0:
  j := 3:
  while (i>=3) do                // letzte schlechte Zeile 
    if (interval[tbl[i,1],"greater"] <> UNKNOWN) and
      (tbl[i,2] < 0 or (interval[tbl[i,1],"lower"] <> UNKNOWN and
                        tbl[i,2] > interval[tbl[i,1],"lower"])
       )
      then k:=i: break end_if:
    i := i-1
  end_while:
  
  if k=0 then return([k,l]) end_if:				// b>=0 
  
  fixk := k:
  
  if tbl[fixk,2] < 0
    then while (j <= n+2) do				// suche tbl[fixk,j] < 0 oder unbeschraenkte var 
           if tbl[fixk,j] < 0 or ( interval[tbl[1,j],"greater"] = UNKNOWN and
                                  (tbl[fixk,j]<>0) )
             then if l = 0 or abs(tbl[2,j]) > abs(tbl[2,l])
                    then l:=j
                  end_if
           end_if:
           j := j+1
         end_while
  else while (j <= n+2) do				// suche tbl[fixk,j] < 0 oder unbeschraenkte var 
         if tbl[fixk,j] > 0 or ( interval[tbl[1,j],"greater"] = UNKNOWN and
                                (tbl[fixk,j]<>0) )
           then if l = 0 or abs(tbl[fixk,j]) > abs(tbl[fixk,l])
                  then l:=j
                end_if
         end_if:
         j := j+1
       end_while
  end_if:
  
  if l = 0 then return([k,l]) end_if:				// Loesungsmenge ist leer 
  
  i := 3:
  
  if tbl[fixk,2] < 0
    then if tbl[fixk,l] < 0
           then mini := tbl[fixk,2]/tbl[fixk,l]:
           intervalpiv := FALSE:
           
           if interval[tbl[1,l],"lower"] <> UNKNOWN
             then if mini > interval[tbl[1,l],"lower"] then
                    k := 1:
                    mini := interval[tbl[1,l],"lower"]:
                    intervalpiv := TRUE
                  end_if
           end_if:
           while i < fixk do
             if interval[tbl[i,1],"greater"] <> UNKNOWN
               then if interval[tbl[i,1],"greater"] = TRUE
                      then if tbl[i,l] > 0
                             then if  (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                                    then k:=i:
                                    mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                                    intervalpiv := FALSE
                                  end_if
                           elif tbl[i,l] < 0 and tbl[i,2] <= interval[tbl[i,1],"lower"] and
                             (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                             then k:=i:
                             mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                             intervalpiv := TRUE
                           end_if
                    elif tbl[i,l] > 0
                      then if tbl[i,2] >= 0 and tbl[i,2]/tbl[i,l] < mini
								then k:=i:
                             mini := tbl[k,2]/tbl[k,l]:
                             intervalpiv := FALSE
                           end_if
                    elif interval[tbl[i,1],"lower"] <> UNKNOWN then
                      if tbl[i,l] < 0 and tbl[i,2] <= interval[tbl[i,1],"lower"] and
                        (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                        then k:=i:
                        mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                        intervalpiv := TRUE
                      end_if
                    end_if
             end_if:
             i:=i+1
           end_while:
           
           i := fixk+1:
           while i <= m+2 do
             if interval[tbl[i,1],"greater"] <> UNKNOWN
               then if interval[tbl[i,1],"greater"] = TRUE
                      then if tbl[i,l] > 0
                             then if (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                                    then k:=i:
                                    mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                                    intervalpiv := FALSE
                                  end_if
                           elif tbl[i,l] < 0 and (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                             then k:=i:
                             mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                             intervalpiv := TRUE
                           end_if
                    elif tbl[i,l] > 0
                      then if tbl[i,2]/tbl[i,l] < mini
                             then k:=i:
                             mini := tbl[k,2]/tbl[k,l]:
                             intervalpiv := FALSE
                           end_if
                    elif interval[tbl[i,1],"lower"] <> UNKNOWN then
                      if tbl[i,l] < 0 and (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                        then k:=i:
                        mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                        intervalpiv := TRUE
                      end_if
                    end_if
             end_if:
             i:=i+1
           end_while
           
         else mini := tbl[fixk,2]/tbl[fixk,l]:					// tbl[fixk,l] > 0 
           intervalpiv := FALSE:
           
           while i < fixk do
             if interval[tbl[i,1],"greater"] <> UNKNOWN
               then if tbl[i,l] < 0
                      then if tbl[i,2] >= 0 and tbl[i,2]/tbl[i,l] > mini
                             then k:=i:
                             mini := tbl[k,2]/tbl[k,l]:
                             intervalpiv := FALSE
                           end_if
                    elif interval[tbl[i,1],"lower"] <> UNKNOWN then
                      if tbl[i,l] > 0 and tbl[i,2] <= interval[tbl[i,1],"lower"] and
                        (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] > mini
                        then k:=i:
                        mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                        intervalpiv := TRUE
                      end_if
                    end_if
             end_if:
             i:=i+1
           end_while:
           
           i := fixk+1:
           while i<= m+2 do
             if interval[tbl[i,1],"greater"] <> UNKNOWN
               then if tbl[i,l] < 0
                      then if tbl[i,2]/tbl[i,l] > mini
                             then k:=i:
                             mini := tbl[k,2]/tbl[k,l]:
                             intervalpiv := FALSE
                           end_if
                    elif interval[tbl[i,1],"lower"] <> UNKNOWN then
                      if tbl[i,l] > 0 and
                        (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] > mini
                        then k:=i:
                        mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                        intervalpiv := TRUE
                      end_if
                    end_if
             end_if:
             i:=i+1
           end_while
         end_if
    
  elif tbl[fixk,l] > 0							// tbl[fixk,2] >= 0 
    then mini := (tbl[fixk,2]-interval[tbl[fixk,1],"lower"])/tbl[fixk,l]:
    intervalpiv := TRUE:
    
    if interval[tbl[1,l],"lower"] <> UNKNOWN and mini > interval[tbl[1,l],"lower"]
      then k := 1:
      mini := interval[tbl[1,l],"lower"]:
      intervalpiv := TRUE
    end_if:
    
    while i < fixk do
      if interval[tbl[i,1],"greater"] <> UNKNOWN
        then if tbl[i,l] > 0
               then if tbl[i,2] >= 0 and tbl[i,2]/tbl[i,l] < mini
                      then k:=i:
                      mini := tbl[k,2]/tbl[k,l]:
                      intervalpiv := FALSE
                    end_if
             elif interval[tbl[i,1],"lower"] <> UNKNOWN then
               if tbl[i,l] < 0 and tbl[i,2] <= interval[tbl[i,1],"lower"] and
                 (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                 then k:=i:
                 mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                 intervalpiv := TRUE
               end_if
             end_if
      end_if:
      i:=i+1
    end_while:
    
    i := fixk:                         //+1:
    while i<= m+2 do
      if interval[tbl[i,1],"greater"] <> UNKNOWN
        then if tbl[i,l] > 0
               then if tbl[i,2]/tbl[i,l] < mini
                      then k:=i:
                      mini := tbl[k,2]/tbl[k,l]:
                      intervalpiv := FALSE
                    end_if
             elif interval[tbl[i,1],"lower"] <> UNKNOWN then
               if tbl[i,l] < 0 and
                 (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] < mini
                 then k:=i:
                 mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                 intervalpiv := TRUE
               end_if
             end_if
      end_if:
      i:=i+1
    end_while
    
  else mini := (tbl[fixk,2]-interval[tbl[fixk,1],"lower"])/tbl[fixk,l]:     // tbl[fixk,l] < 0 
    intervalpiv := TRUE:
    
    while i < fixk do
      if interval[tbl[i,1],"greater"] <> UNKNOWN
        then if tbl[i,l] < 0
               then if tbl[i,2] >= 0 and tbl[i,2]/tbl[i,l] > mini
                      then k:=i:
                      mini := tbl[k,2]/tbl[k,l]:
                      intervalpiv := FALSE
                    end_if
             elif interval[tbl[i,1],"lower"] <> UNKNOWN then
               if tbl[i,l] > 0 and tbl[i,2] <= interval[tbl[i,1],"lower"] and
                 (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] > mini
                 then k:=i:
                 mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                 intervalpiv := TRUE
               end_if
             end_if
      end_if:
      i:=i+1
    end_while:
    
    i := fixk:			//+1:
    while i<= m+2 do
      if interval[tbl[i,1],"greater"] <> UNKNOWN
        then if tbl[i,l] < 0
               then if tbl[i,2]/tbl[i,l] > mini
                      then k:=i:
                      mini := tbl[k,2]/tbl[k,l]:
                      intervalpiv := FALSE
                    end_if
             elif interval[tbl[i,1],"lower"] <> UNKNOWN then
               if tbl[i,l] > 0 and
                 (tbl[i,2]-interval[tbl[i,1],"lower"])/tbl[i,l] > mini
                 then k:=i:
                 mini := (tbl[k,2]-interval[tbl[k,1],"lower"])/tbl[k,l]:
                 intervalpiv := TRUE
               end_if
             end_if
      end_if:
      i:=i+1
    end_while
    
  end_if:
  
  return([k,l,tbl[k,l],intervalpiv,fixk])			// k > 1 ? 
  
end_proc:




unalias(Tableau):
unalias(Heap):
