//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
result.mu -- get the associated corner to the given Tableau T
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):


    Tableau::result	:= 	proc(T)

/* Eingabe: Tableau T, <Any>
  Ausgabe: Menge von Gleichungen, die jeder Variablen einen Wert zuweist. Sofern Any gesetzt ist,
           erhaelt man eine Liste solcher Mengen zurueck, wobei jede Kombination von Werten freier
           Variablen vorkommt; wichtig, wenn alle Ecken berechnet werden sollen.
*/

				local erg,ergclean,				// (bereinigtes) Ergebnis	
				      tbl,m,n,insertedvars,equations,		
				      freevars,interval,slackanz,		// Tableaukomponenten		
				      i,j,k;					// Laufvariablen			

				begin

				  if args(0) > 1 and args(2) <> Any then error(" Tableau and/or option 'Any' expected!") end_if:

				  erg := {}:
				  tbl := T[1]:
				  m := T[2]:
				  n := T[3]:
				  insertedvars := T[4]:
				  equations := T[5]:
				  freevars := T[6]:
				  slackanz := T[7]:
				  interval := T[9]:

				  for i from 3 to m+2 do
				     if interval[tbl[i,1],"lower"] <> UNKNOWN and  interval[tbl[i,1],"greater"]
				       then erg := erg union {tbl[i,1] = interval[tbl[i,1],"lower"]-tbl[i,2]}
				       else erg := erg union {tbl[i,1] = tbl[i,2]}
				     end_if
				  end_for: 

				  for j from 3 to n+2 do
				     if interval[tbl[1,j],"lower"] <> UNKNOWN and interval[tbl[1,j],"greater"]
				       then erg := erg union {tbl[1,j] = interval[tbl[1,j],"lower"]}
				       else erg := erg union {tbl[1,j] = 0}
			             end_if
				  end_for:

				  erg := erg union {op(equations,[i,1]) = subs(op(equations,[i,2]),erg)$ i=1..nops(equations)}:	        

				  ergclean := {}:

				  if args(0) = 1 
				    then for i from 1 to nops(erg) do
					   if not contains(insertedvars,op(erg,[i,1]))
					     then ergclean := ergclean union 
							{op(erg,[i,1])=subs(op(erg,[i,2]),{op(freevars,j)=0$ j=1..nops(freevars)})}
					   end_if:
					 end_for:
					 erg := ergclean:

					 for i in (freevars minus insertedvars) do
					   erg := erg union {i=0}
					 end_for:
				    else for i from 1 to nops(erg) do
					   if not contains(insertedvars,op(erg,[i,1]))
					     then ergclean := ergclean union {op(erg,i)}
					   end_if
					 end_for:
					 erg := [ergclean]:

					 for i in freevars do
					   if interval[i,"lower"] = UNKNOWN 
					     then if not contains(insertedvars,i)
						    then erg := [({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=0})$ k=1..nops(erg[j])} 
								  union {i=0})$ j=1..nops(erg)]
						    else erg := [({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=0})$ k=1..nops(erg[j])})
									$ j=1..nops(erg)]
						  end_if
					     elif not contains(insertedvars,i)
						 then erg := [({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=0})$ k=1..nops(erg[j])} 
								 union {i=0})$ j=1..nops(erg),
							  ({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=interval[i,"lower"]})
								$ k=1..nops(erg[j])} 
							   union {i=interval[i,"lower"]})$ j=1..nops(erg)] 
						 else erg := [({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=0})$ k=1..nops(erg[j])})
							$ j=1..nops(erg),
							  ({op(erg,[j,k,1])=subs(op(erg,[j,k,2]),{i=interval[i,"lower"]})
								$ k=1..nops(erg[j])})$ j=1..nops(erg)] 
					   end_if
					 end_for 
				  end_if:
				  return(erg)
				end_proc:
unalias(Tableau):
unalias(Heap):
